/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jstl.rt.SqlQueryTag;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;

public class SqlTransactionTag
extends TagSupport
implements TryCatchFinally {
    private static final Logger log = Log.open(SqlTransactionTag.class);
    private static final L10N L = new L10N(SqlTransactionTag.class);
    private Object _dataSource;
    private String _isolation;
    private Connection _conn;
    private int _oldIsolation;

    public void setDataSource(Object dataSource) {
        this._dataSource = dataSource;
    }

    public void setIsolation(String isolation) {
        this._isolation = isolation;
    }

    public int doStartTag() throws JspException {
        if (this.pageContext.getAttribute("caucho.jstl.sql.conn") != null) {
            throw new JspTagException(L.l("nested sql:transaction are forbidden"));
        }
        try {
            DataSource ds = SqlQueryTag.getDataSource(this.pageContext, this._dataSource);
            int isolationCode = -1;
            if (this._isolation != null) {
                if (this._isolation.equals("read_committed")) {
                    isolationCode = 2;
                } else if (this._isolation.equals("read_uncommitted")) {
                    isolationCode = 1;
                } else if (this._isolation.equals("repeatable_read")) {
                    isolationCode = 4;
                } else if (this._isolation.equals("serializable")) {
                    isolationCode = 8;
                } else {
                    throw new JspTagException(L.l("unknown sql:transaction isolation ~{0}'", (Object)this._isolation));
                }
            }
            this._conn = ds.getConnection();
            this._oldIsolation = this._conn.getTransactionIsolation();
            this._conn.setAutoCommit(false);
            if (isolationCode < 0 || isolationCode == this._oldIsolation) {
                this._oldIsolation = -1;
            } else if (isolationCode == 2) {
                this._oldIsolation = -1;
            } else {
                this._conn.setTransactionIsolation(isolationCode);
            }
            this.pageContext.setAttribute("caucho.jstl.sql.conn", (Object)this._conn);
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCatch(Throwable t) throws Throwable {
        Connection conn = this._conn;
        this._conn = null;
        if (conn != null) {
            try {
                conn.rollback();
                Object var4_3 = null;
                this.close(conn);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.close(conn);
                throw throwable;
            }
        }
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinally() {
        block4: {
            try {
                this.pageContext.removeAttribute("caucho.jstl.sql.conn");
                Connection conn = this._conn;
                this._conn = null;
                if (conn == null) break block4;
                try {
                    conn.commit();
                    Object var3_3 = null;
                    this.close(conn);
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.close(conn);
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }

    private void close(Connection conn) {
        try {
            if (this._oldIsolation >= 0) {
                conn.setTransactionIsolation(this._oldIsolation);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

