/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.jstl.rt.SqlQueryTag;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class SqlUpdateTag
extends BodyTagSupport
implements SQLExecutionTag {
    private static final Logger log = Log.open(SqlUpdateTag.class);
    private static final L10N L = new L10N(SqlUpdateTag.class);
    private String _sql;
    private String _var;
    private String _scope;
    private Object _dataSource;
    private ArrayList<Object> _params;

    public void setSql(String sql) {
        this._sql = sql;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setDataSource(Object dataSource) throws JspException {
        this._dataSource = dataSource;
        if (this.pageContext.getAttribute("caucho.jstl.sql.conn") != null) {
            throw new JspException(L.l("sql:query cannot set data-source inside sql:transaction"));
        }
    }

    public void addSQLParameter(Object value) {
        if (this._params == null) {
            this._params = new ArrayList();
        }
        this._params.add(value);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        Statement stmt;
        Connection conn = null;
        boolean isTransaction = false;
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        String sql = null;
        sql = this._sql != null ? this._sql : this.bodyContent.getString();
        conn = (Connection)pageContext.getAttribute("caucho.jstl.sql.conn");
        if (conn != null) {
            isTransaction = true;
        }
        if (!isTransaction) {
            conn = SqlQueryTag.getConnection(pageContext, this._dataSource);
        }
        Object value = null;
        ArrayList<Object> params = this._params;
        this._params = null;
        int paramCount = this.countParameters(sql);
        if (params == null && paramCount != 0 || params != null && paramCount != params.size()) {
            throw new JspException(L.l("sql:param does not match expected parameters\nin '{0}'", (Object)sql));
        }
        int rows = 0;
        if (params == null) {
            stmt = conn.createStatement();
            rows = stmt.executeUpdate(sql);
        } else {
            PreparedStatement pstmt = conn.prepareStatement(sql);
            stmt = pstmt;
            for (int i = 0; i < params.size(); ++i) {
                Object paramValue = params.get(i);
                if (paramValue == null) {
                    pstmt.setNull(i + 1, 12);
                    continue;
                }
                pstmt.setObject(i + 1, paramValue);
            }
            rows = pstmt.executeUpdate();
        }
        stmt.close();
        CoreSetTag.setValue(pageContext, this._var, this._scope, new Integer(rows));
        Object var15_16 = null;
        if (isTransaction) return 6;
        if (conn == null) return 6;
        try {
            conn.close();
            return 6;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return 6;
        {
            catch (RuntimeException e) {
                throw e;
            }
            catch (JspException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JspException(L.l("sql:update '{0}' failed:\n{1}", (Object)sql, (Object)e.getMessage()), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (isTransaction || conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            throw throwable;
        }
    }

    private int countParameters(String sql) {
        if (sql == null) {
            return 0;
        }
        int len = sql.length();
        boolean inQuote = false;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = sql.charAt(i);
            if (ch == '\'') {
                inQuote = !inQuote;
                continue;
            }
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (ch != '?') continue;
            ++count;
        }
        return count;
    }
}

