/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.BodyContentImpl;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.L10N;
import com.caucho.vfs.TempCharReader;
import com.caucho.vfs.Vfs;
import java.io.Reader;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class XmlParseTag
extends BodyTagSupport {
    private static L10N L = new L10N(XmlParseTag.class);
    private Object _xml;
    private String _systemId;
    private Object _filter;
    private XMLReader _saxReader;
    private String _var;
    private String _scope;
    private String _varDom;
    private String _scopeDom;

    public void setXml(Object xml) {
        this._xml = xml;
    }

    public void setDoc(Object xml) {
        this.setXml(xml);
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    public void setFilter(Object filter) {
        this._filter = filter;
    }

    public void setSaxReader(XMLReader reader) {
        this._saxReader = reader;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setVarDom(String var) {
        this._varDom = var;
    }

    public void setScopeDom(String scope) {
        this._scopeDom = scope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        try {
            Reader reader;
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            BodyContentImpl body = (BodyContentImpl)this.getBodyContent();
            if (this._xml != null) {
                Object obj = this._xml;
                if (obj instanceof Reader) {
                    reader = (Reader)obj;
                } else {
                    if (!(obj instanceof String)) throw new JspException(L.l("xml must be Reader or String at `{0}'", obj));
                    reader = Vfs.openString((String)obj).getReader();
                }
            } else {
                int ch;
                if (body == null) throw new JspException(L.l("doc attribute must be a Reader or String at `{0}'", null));
                TempCharReader tempReader = (TempCharReader)body.getReader();
                while (Character.isWhitespace(ch = tempReader.read())) {
                }
                if (ch >= 0) {
                    tempReader.unread();
                }
                reader = tempReader;
            }
            InputSource is = new InputSource(reader);
            if (this._systemId != null) {
                is.setSystemId(this._systemId);
            }
            Document doc = null;
            XMLFilter filter = (XMLFilter)this._filter;
            if (this._filter != null && this._var == null && this._varDom == null) {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                XMLReader parser = saxParser.getXMLReader();
                filter.setParent(parser);
                filter.parse(is);
                reader.close();
                return 6;
            } else {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder parser = factory.newDocumentBuilder();
                doc = parser.parse(is);
                reader.close();
                if (this._var != null) {
                    CoreSetTag.setValue(pageContext, this._var, this._scope, doc);
                    return 6;
                } else {
                    if (this._varDom == null) throw new JspException(L.l("x:parse needs either var or varDom"));
                    CoreSetTag.setValue(pageContext, this._varDom, this._scopeDom, doc);
                }
            }
            return 6;
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

