/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.lifecycle;

import com.caucho.lifecycle.LifecycleListener;
import com.caucho.lifecycle.LifecycleState;
import com.caucho.util.Alarm;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Lifecycle
implements LifecycleState {
    private final Logger _log;
    private String _name;
    private Level _level = Level.FINE;
    private Level _lowLevel = Level.FINER;
    private int _state;
    private long _activeCount;
    private long _failCount;
    private long _lastFailTime;
    private long _lastChangeTime;
    private ArrayList<WeakReference<LifecycleListener>> _listeners;

    public Lifecycle() {
        this._log = null;
    }

    public Lifecycle(Logger log) {
        this._log = log;
    }

    public Lifecycle(Logger log, String name) {
        this._log = log;
        this._name = name;
    }

    public Lifecycle(Logger log, String name, Level level) {
        this._log = log;
        this._name = name;
        this.setLevel(level);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Level getLevel() {
        return this._level;
    }

    public void setLevel(Level level) {
        this._level = level;
        if (level.intValue() < this._lowLevel.intValue()) {
            this._lowLevel = level;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LifecycleListener listener) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this.isDestroyed()) {
                IllegalStateException e = new IllegalStateException("attempted to add listener to a destroyed lifecyle " + this);
                if (this._log != null) {
                    this._log.log(Level.WARNING, e.toString(), e);
                } else {
                    Logger.getLogger(Lifecycle.class.getName()).log(Level.WARNING, e.toString(), e);
                }
                return;
            }
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                LifecycleListener oldListener = (LifecycleListener)this._listeners.get(i).get();
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
            this._listeners.add(new WeakReference<LifecycleListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LifecycleListener listener) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this._listeners == null) {
                return;
            }
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                LifecycleListener oldListener = (LifecycleListener)this._listeners.get(i).get();
                if (listener == oldListener) {
                    this._listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int oldState, int newState) {
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            if (this._listeners == null) {
                return;
            }
            for (int i = 0; i < this._listeners.size(); ++i) {
                LifecycleListener listener = (LifecycleListener)this._listeners.get(i).get();
                if (listener != null) {
                    listener.lifecycleEvent(oldState, newState);
                    continue;
                }
                this._listeners.remove(i);
                --i;
            }
        }
    }

    public int getState() {
        return this._state;
    }

    public static String getStateName(int state) {
        switch (state) {
            case 0: {
                return "new";
            }
            case 1: {
                return "initializing";
            }
            case 2: {
                return "init";
            }
            case 3: {
                return "starting";
            }
            case 6: {
                return "active";
            }
            case 7: {
                return "failed";
            }
            case 8: {
                return "stopping";
            }
            case 9: {
                return "stopped";
            }
            case 10: {
                return "destroying";
            }
            case 11: {
                return "destroyed";
            }
        }
        return "unknown";
    }

    public String getStateName() {
        return Lifecycle.getStateName(this._state);
    }

    public long getLastChangeTime() {
        return this._lastChangeTime;
    }

    public long getLastFailTime() {
        return this._lastFailTime;
    }

    public long getActiveCount() {
        return this._activeCount;
    }

    public long getFailCount() {
        return this._failCount;
    }

    public boolean isInitializing() {
        return this._state == 1;
    }

    public boolean isInit() {
        return this._state == 2;
    }

    public boolean isBeforeInit() {
        return this._state < 2;
    }

    public boolean isAfterInit() {
        return this._state >= 2;
    }

    public boolean isStarting() {
        return this._state == 3;
    }

    public boolean isWarmup() {
        return this._state == 5;
    }

    public boolean isBeforeActive() {
        return this._state < 6;
    }

    public boolean isAfterActive() {
        return 6 < this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForActive(long timeout) {
        if (this._state == 6) {
            return true;
        }
        long waitEnd = Alarm.getCurrentTime() + timeout;
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            while (Alarm.getCurrentTime() < waitEnd) {
                if (this._state == 6) {
                    return true;
                }
                if (6 < this._state) {
                    return false;
                }
                if (Alarm.isTest()) {
                    return false;
                }
                try {
                    this.wait(waitEnd - Alarm.getCurrentTime());
                }
                catch (InterruptedException e) {}
            }
        }
        return this._state == 6;
    }

    public boolean isActive() {
        return this._state == 6;
    }

    public boolean isRunnable() {
        return 5 <= this._state && this._state <= 6;
    }

    public boolean isError() {
        return this.isFailed();
    }

    public boolean isFailed() {
        return this._state == 7;
    }

    public boolean isStopping() {
        return 8 <= this._state;
    }

    public boolean isStopped() {
        return 8 <= this._state;
    }

    public boolean isDestroying() {
        return 10 <= this._state;
    }

    public boolean isDestroyed() {
        return 11 <= this._state;
    }

    public synchronized boolean toInitializing() {
        if (1 <= this._state) {
            return false;
        }
        int oldState = this._state;
        this._state = 1;
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._lowLevel)) {
            this._log.log(this._lowLevel, this._name + " initializing");
        }
        this.notifyListeners(oldState, this._state);
        return true;
    }

    public synchronized boolean toInit() {
        if (2 <= this._state) {
            return false;
        }
        int oldState = this._state;
        this._state = 2;
        this._lastChangeTime = Alarm.getCurrentTime();
        if (this._log != null && this._log.isLoggable(this._lowLevel)) {
            this._log.log(this._lowLevel, this._name + " initialized");
        }
        this.notifyListeners(oldState, this._state);
        return true;
    }

    public synchronized boolean toPostInit() {
        if (9 == this._state) {
            int oldState = this._state;
            this._state = 2;
            this._lastChangeTime = Alarm.getCurrentTime();
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return 2 == this._state;
    }

    public synchronized boolean toStarting() {
        if (this._state < 3 || this._state == 9) {
            int oldState = this._state;
            this._state = 3;
            this._lastChangeTime = Alarm.getCurrentTime();
            if (this._log != null && this._log.isLoggable(Level.FINE) && this._log.isLoggable(this._level)) {
                this._log.fine(this._name + " starting");
            }
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return false;
    }

    public synchronized boolean toActive() {
        if (this._state < 6 || 7 <= this._state && this._state <= 9) {
            int oldState = this._state;
            this._state = 6;
            this._lastChangeTime = Alarm.getCurrentTime();
            ++this._activeCount;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, this._name + " active");
            }
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public boolean toError() {
        return this.toFail();
    }

    public synchronized boolean toFail() {
        if (this._state < 10 && this._state != 7) {
            int oldState = this._state;
            this._state = 7;
            this._lastChangeTime = Alarm.getCurrentTime();
            ++this._failCount;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, this._name + " error");
            }
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toStopping() {
        if (this._state < 8 && this._state != 3) {
            int oldState = this._state;
            this._state = 8;
            this._lastChangeTime = Alarm.getCurrentTime();
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, this._name + " stopping");
            }
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return false;
    }

    public synchronized boolean toStop() {
        if (this._state < 9) {
            if (this._log != null) {
                if (this._state < 8 && this._log.isLoggable(this._level)) {
                    this._log.log(this._level, this._name + " stopped");
                } else if (this._log.isLoggable(this._lowLevel)) {
                    this._log.log(this._lowLevel, this._name + " stopped");
                }
            }
            int oldState = this._state;
            this._state = 9;
            this._lastChangeTime = Alarm.getCurrentTime();
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toDestroying() {
        if (this._state < 10) {
            int oldState = this._state;
            this._state = 10;
            this._lastChangeTime = Alarm.getCurrentTime();
            if (this._log != null && this._log.isLoggable(this._lowLevel)) {
                this._log.log(this._lowLevel, this._name + " destroying");
            }
            this.notifyListeners(oldState, this._state);
            return true;
        }
        return false;
    }

    public synchronized boolean toDestroy() {
        if (this._state < 11) {
            int oldState = this._state;
            this._state = 11;
            this._lastChangeTime = Alarm.getCurrentTime();
            if (this._log != null && this._log.isLoggable(this._lowLevel)) {
                this._log.log(this._lowLevel, this._name + " destroyed");
            }
            this.notifyListeners(oldState, this._state);
            this.notifyAll();
            return true;
        }
        return false;
    }

    public void copyState(Lifecycle source) {
        this._state = source._state;
    }

    public String toString() {
        if (this._name != null) {
            return "Lifecycle[" + this._name + ", " + this.getStateName() + "]";
        }
        return "Lifecycle[" + this.getStateName() + "]";
    }
}

