/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Loader;
import com.caucho.loader.RequireReload;
import com.caucho.log.Log;
import com.caucho.make.DependencyContainer;
import com.caucho.util.ByteBuffer;
import com.caucho.util.QDate;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.CodeSource;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassEntry
implements Dependency {
    private static final Logger log = Log.open(ClassEntry.class);
    private static boolean _hasJNIReload;
    private static boolean _hasAnnotations;
    private DynamicClassLoader _loader;
    private String _name;
    private Path _classPath;
    private PersistentDependency _depend;
    private boolean _classIsModified;
    private Path _sourcePath;
    private long _sourceLastModified;
    private long _sourceLength;
    private ClassPackage _classPackage;
    private CodeSource _codeSource;
    private ClassNotFoundException _exn;
    private WeakReference<Class> _clRef;

    public ClassEntry(DynamicClassLoader loader, String name, Path sourcePath, Path classPath, CodeSource codeSource) {
        this._loader = loader;
        this._name = name;
        this._classPath = classPath;
        this.setDependPath(classPath);
        if (sourcePath != null && !sourcePath.equals((Object)classPath)) {
            this._sourcePath = sourcePath;
            this._sourceLastModified = sourcePath.getLastModified();
            this._sourceLength = sourcePath.getLength();
        }
        this._codeSource = codeSource;
    }

    public ClassEntry(Loader loader, String name, Path sourcePath, Path classPath) {
        this(loader.getLoader(), name, sourcePath, classPath, loader.getCodeSource(classPath));
    }

    public String getName() {
        return this._name;
    }

    public DynamicClassLoader getClassLoader() {
        return this._loader;
    }

    public CodeSource getCodeSource() {
        return this._codeSource;
    }

    public Path getSourcePath() {
        return this._sourcePath;
    }

    protected void setDependPath(Path dependPath) {
        this._depend = dependPath instanceof JarPath ? ((JarPath)dependPath).getDepend() : new Depend(dependPath);
    }

    protected boolean addDependencies(DependencyContainer container) {
        if (this._classPath instanceof JarPath) {
            container.add((Dependency)this._depend);
            return false;
        }
        if (_hasJNIReload) {
            container.add(this);
            return true;
        }
        if (this._sourcePath == null) {
            container.add((Dependency)this._depend);
            return false;
        }
        container.add(this);
        return true;
    }

    public void setSourceLength(long length) {
        this._sourceLength = length;
    }

    public void setSourceLastModified(long lastModified) {
        this._sourceLastModified = lastModified;
    }

    public ClassPackage getClassPackage() {
        return this._classPackage;
    }

    public void setClassPackage(ClassPackage pkg) {
        this._classPackage = pkg;
    }

    public boolean isModified() {
        if (this._depend.isModified()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("class modified: " + this._depend);
            }
            return this.reloadIsModified();
        }
        if (this._sourcePath == null) {
            return false;
        }
        if (this._sourcePath.getLastModified() != this._sourceLastModified) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("source modified time: " + this._sourcePath + " old:" + QDate.formatLocal((long)this._sourceLastModified) + " new:" + QDate.formatLocal((long)this._sourcePath.getLastModified()));
            }
            if (!this.compileIsModified()) {
                return false;
            }
            boolean isModified = this.reloadIsModified();
            return isModified;
        }
        if (this._sourcePath.getLength() != this._sourceLength) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("source modified length: " + this._sourcePath + " old:" + this._sourceLength + " new:" + this._sourcePath.getLength());
            }
            if (!this.compileIsModified()) {
                return false;
            }
            return this.reloadIsModified();
        }
        return false;
    }

    public boolean logModified(Logger log) {
        if (this._depend.logModified(log)) {
            return true;
        }
        if (this._sourcePath == null) {
            return false;
        }
        if (this._sourcePath.getLastModified() != this._sourceLastModified) {
            log.info("source modified time: " + this._sourcePath + " old:" + QDate.formatLocal((long)this._sourceLastModified) + " new:" + QDate.formatLocal((long)this._sourcePath.getLastModified()));
            return true;
        }
        if (this._sourcePath.getLength() != this._sourceLength) {
            log.info("source modified length: " + this._sourcePath + " old:" + this._sourceLength + " new:" + this._sourcePath.getLength());
            return true;
        }
        return false;
    }

    public boolean compileIsModified() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reloadIsModified() {
        if (this._classIsModified) {
            return true;
        }
        if (!_hasJNIReload || !this._classPath.canRead()) {
            return true;
        }
        try {
            Class cl;
            long length = this._classPath.getLength();
            Class clazz = cl = this._clRef != null ? (Class)this._clRef.get() : null;
            if (cl == null) {
                return false;
            }
            if (_hasAnnotations && ClassEntry.requireReload(cl)) {
                return true;
            }
            ReadStream is = this._classPath.openRead();
            byte[] bytecode = new byte[(int)length];
            try {
                is.readAll(bytecode, 0, bytecode.length);
            }
            finally {
                is.close();
            }
            int result = ClassEntry.reloadNative(cl, bytecode, 0, bytecode.length);
            if (result != 0) {
                this._classIsModified = true;
                return true;
            }
            this.setDependPath(this._classPath);
            if (this._sourcePath != null) {
                this._sourceLastModified = this._sourcePath.getLastModified();
                this._sourceLength = this._sourcePath.getLength();
            }
            log.info("Reloading " + cl.getName());
            return false;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            this._classIsModified = true;
            return true;
        }
    }

    public Path getClassPath() {
        return this._classPath;
    }

    public Class getEntryClass() {
        return this._clRef != null ? (Class)this._clRef.get() : null;
    }

    public void setEntryClass(Class cl) {
        this._clRef = new WeakReference<Class>(cl);
    }

    public void preLoad() throws ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ByteBuffer buffer) throws IOException {
        ClassEntry classEntry = this;
        synchronized (classEntry) {
            Path classPath = this.getClassPath();
            buffer.clear();
            long length = classPath.getLength();
            if (length < 0L) {
                throw new IOException("missing class: " + classPath);
            }
            ReadStream is = classPath.openRead();
            try {
                buffer.setLength((int)length);
                if ((long)is.readAll(buffer.getBuffer(), 0, (int)length) != length) {
                    throw new IOException("class file length mismatch");
                }
            }
            finally {
                is.close();
            }
        }
    }

    public boolean postLoad() {
        return false;
    }

    public static boolean hasJNIReload() {
        return _hasJNIReload;
    }

    private static boolean requireReload(Class cl) {
        return cl.isAnnotationPresent(RequireReload.class);
    }

    public String toString() {
        if (this._sourcePath == null) {
            return "ClassEntry[" + this._classPath + "]";
        }
        return "ClassEntry[" + this._classPath + ", src=" + this._sourcePath + "]";
    }

    public static native boolean canReloadNative();

    public static native int reloadNative(Class var0, byte[] var1, int var2, int var3);

    static {
        try {
            System.loadLibrary("resin_os");
            _hasJNIReload = ClassEntry.canReloadNative();
            if (_hasJNIReload) {
                log.config("In-place class redefinition (HotSwap) is available.");
            } else {
                log.config("In-place class redefinition (HotSwap) is not available.  In-place class reloading during development requires a compatible JDK and -Xdebug.");
            }
        }
        catch (Throwable e) {
            log.fine(e.toString());
            log.log(Level.FINEST, e.toString(), e);
        }
        try {
            Class<?> reloadClass = Class.forName("com.caucho.loader.RequireReload");
            Object.class.getAnnotation(reloadClass);
            _hasAnnotations = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class ReloadThread
    implements Runnable {
        private volatile boolean _isDone;

        ReloadThread() {
        }

        public boolean isDone() {
            return this._isDone;
        }

        public void run() {
        }
    }
}

