/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.LibraryLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.TreeLoader;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public class ClassLoaderConfig {
    private static final L10N L = new L10N(ClassLoaderConfig.class);
    private EnvironmentClassLoader _classLoader;
    private EnvironmentBean _owner;
    private Path _source;
    private boolean _servletHack;
    private int _index;
    private ArrayList<String> _priorityPackages;

    public ClassLoaderConfig() throws ConfigException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (!(loader instanceof EnvironmentClassLoader)) {
            throw new ConfigException(L.l("<class-loader> requires an EnvironmentClassLoader."));
        }
        this._classLoader = (EnvironmentClassLoader)loader;
    }

    public void setServletHack(boolean hack) {
        this._classLoader.setServletHack(hack);
    }

    public void addSimpleLoader(SimpleLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addLibraryLoader(LibraryLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addCompilingLoader(CompilingLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addTreeLoader(TreeLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public EnhancerManager createEnhancer() throws ConfigException {
        return EnhancerManager.create();
    }

    public void addPriorityPackage(String priorityPackage) {
        this._classLoader.addPriorityPackage(priorityPackage);
    }

    @PostConstruct
    public void init() throws ConfigException {
        this._classLoader.init();
        this._classLoader.validate();
    }

    public String toString() {
        return "ClassLoaderConfig[]";
    }
}

