/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.loader.CompilingLoader;
import com.caucho.loader.DirectoryLoader;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Loader;
import com.caucho.loader.SimpleLoader;
import com.caucho.vfs.Path;
import javax.annotation.PostConstruct;

public class ClasspathConfig {
    private Path _classDir;
    private Path _source;
    private boolean _compile = true;
    private boolean _isLibraryDir = false;

    public void setId(Path id) {
        this._classDir = id;
    }

    public void setSource(Path source) {
        this._source = source;
    }

    public void setCompile(boolean compile) {
        this._compile = compile;
    }

    public void setLibraryDir(boolean libraryDir) {
        this._isLibraryDir = libraryDir;
    }

    @PostConstruct
    public void init() {
        DynamicClassLoader classLoader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        Loader loader = null;
        loader = this._isLibraryDir ? new DirectoryLoader(this._classDir) : (!this._compile ? new SimpleLoader(this._classDir) : (this._classDir.getPath().endsWith(".jar") || this._classDir.getPath().endsWith(".zip") ? new SimpleLoader(this._classDir) : (this._source != null ? new CompilingLoader(this._classDir, this._source, null, null) : new CompilingLoader(this._classDir))));
        classLoader.addLoader(loader);
        classLoader.init();
    }

    public String toString() {
        return "ClasspathConfig[" + this._classDir + "]";
    }
}

