/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.java.CompileClassNotFound;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.security.CodeSource;
import java.util.logging.Level;
import java.util.logging.Logger;

class CompilingClassEntry
extends ClassEntry {
    private static final L10N L = new L10N(CompilingClassEntry.class);
    private static final Logger log = Log.open(CompilingClassEntry.class);
    private CompilingLoader _loader;
    private boolean _compileIsModified;

    public CompilingClassEntry(CompilingLoader compilingLoader, DynamicClassLoader loader, String name, Path sourcePath, Path classPath, CodeSource codeSource) {
        super(loader, name, sourcePath, classPath, codeSource);
        this._loader = compilingLoader;
    }

    public void preLoad() throws ClassNotFoundException {
        String javaName = this.getName().replace('.', '/') + ".java";
        Path javaFile = this.getSourcePath();
        Path classFile = this.getClassPath();
        if (javaFile.getLastModified() <= classFile.getLastModified()) {
            log.finest(L.l("loading pre-compiled class {0} from {1}", (Object)this.getName(), (Object)classFile));
            return;
        }
        if (!javaFile.canRead()) {
            return;
        }
        try {
            classFile.remove();
        }
        catch (IOException e) {
            // empty catch block
        }
        String sourcePath = this._loader.prefixClassPath(this._loader.getLoader().getSourcePath());
        if (CauchoSystem.isWindows() && !this._loader.checkSource(this._loader.getSource(), javaName)) {
            return;
        }
        this._loader.compileClass(javaFile, classFile, sourcePath, false);
        if (classFile.canRead()) {
            log.fine(L.l("loading compiled class {0} from {1}", (Object)this.getName(), (Object)classFile));
        } else if (javaFile.exists()) {
            throw new CompileClassNotFound(L.l("compiling {0} didn't produce a {1}. class", (Object)javaFile, (Object)this.getName()));
        }
        this.setDependPath(classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compileIsModified() {
        if (this._compileIsModified) {
            return true;
        }
        CompileThread compileThread = new CompileThread();
        ThreadPool.getThreadPool().start((Runnable)compileThread);
        try {
            CompileThread compileThread2 = compileThread;
            synchronized (compileThread2) {
                if (!compileThread.isDone()) {
                    compileThread.wait(5000L);
                }
            }
            if (this._compileIsModified) {
                return true;
            }
            if (compileThread.isDone()) {
                this.setDependPath(this.getClassPath());
                return this.reloadIsModified();
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String toString() {
        return "CompilingClassEntry[" + this.getClassPath() + ", src=" + this.getSourcePath() + "]";
    }

    class CompileThread
    implements Runnable {
        private volatile boolean _isDone;

        CompileThread() {
        }

        public boolean isDone() {
            return this._isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Path sourcePath = CompilingClassEntry.this.getSourcePath();
            long length = sourcePath.getLength();
            long lastModified = sourcePath.getLastModified();
            try {
                CompilingClassEntry.this._loader.compileClass(CompilingClassEntry.this.getSourcePath(), CompilingClassEntry.this.getClassPath(), CompilingClassEntry.this.getSourcePath().getPath(), false);
                CompilingClassEntry.this.setSourceLength(length);
                CompilingClassEntry.this.setSourceLastModified(lastModified);
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
                CompilingClassEntry.this._compileIsModified = true;
            }
            this._isDone = true;
            CompileThread compileThread = this;
            synchronized (compileThread) {
                this.notifyAll();
            }
        }
    }
}

