/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.JarLoader;
import com.caucho.loader.Loader;
import com.caucho.loader.PathLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.TempDynamicClassLoader;
import com.caucho.loader.WeakCloseListener;
import com.caucho.loader.WeakLoaderListener;
import com.caucho.loader.enhancer.EnhancerRuntimeException;
import com.caucho.make.AlwaysModified;
import com.caucho.make.DependencyContainer;
import com.caucho.make.Make;
import com.caucho.make.MakeContainer;
import com.caucho.management.server.DynamicClassLoaderMXBean;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.ByteBuffer;
import com.caucho.util.L10N;
import com.caucho.util.TimedCache;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicClassLoader
extends URLClassLoader
implements Dependency,
Make,
DynamicClassLoaderMXBean {
    private static L10N _L;
    private static Logger _log;
    private static final URL NULL_URL;
    private static final URL[] NULL_URL_ARRAY;
    private static long _globalDependencyCheckInterval;
    private static boolean _isJarCacheEnabled;
    private String _id;
    private final boolean _isVerbose;
    private int _verboseDepth;
    private ArrayList<Loader> _loaders = new ArrayList();
    private JarLoader _jarLoader;
    private PathLoader _pathLoader;
    private ArrayList<Path> _nativePath = new ArrayList();
    private Hashtable<String, ClassEntry> _entryCache;
    private TimedCache<String, URL> _resourceCache;
    private DependencyContainer _dependencies = new DependencyContainer();
    private boolean _isEnableDependencyCheck = false;
    private MakeContainer _makeList;
    private boolean _useServletHack;
    private String[] _parentPriorityPackages;
    private String[] _priorityPackages;
    private ArrayList<ClassLoaderListener> _listeners;
    private SecurityManager _securityManager;
    private ArrayList<Permission> _permissions;
    private CodeSource _codeSource;
    private ArrayList<ClassFileTransformer> _classFileTransformerList;
    private URL[] _urls = NULL_URL_ARRAY;
    private WeakCloseListener _closeListener;
    protected final Lifecycle _lifecycle = new Lifecycle();
    private boolean _hasNewLoader = true;
    private long _lastNullCheck;

    public DynamicClassLoader(ClassLoader parent) {
        this(parent, true);
    }

    public DynamicClassLoader(ClassLoader parent, boolean enableDependencyCheck) {
        super(NULL_URL_ARRAY, DynamicClassLoader.getInitParent(parent));
        this._securityManager = System.getSecurityManager();
        this._isEnableDependencyCheck = enableDependencyCheck;
        this._dependencies.setCheckInterval(_globalDependencyCheckInterval);
        for (parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof DynamicClassLoader)) continue;
            DynamicClassLoader loader = (DynamicClassLoader)parent;
            loader.init();
            this.addPermissions(loader.getPermissions());
            this._dependencies.add(loader);
            this._dependencies.setCheckInterval(loader.getDependencyCheckInterval());
            this._useServletHack = loader._useServletHack;
            break;
        }
        if (System.getProperty("resin.verbose.classpath") != null) {
            this._isVerbose = true;
            int depth = 0;
            while (parent != null) {
                ++depth;
                parent = parent.getParent();
            }
            this._verboseDepth = depth;
        } else {
            this._isVerbose = false;
        }
    }

    private static ClassLoader getInitParent(ClassLoader parent) {
        if (parent != null) {
            return parent;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    public static boolean isJarCacheEnabled() {
        return _isJarCacheEnabled;
    }

    public static void setJarCacheEnabled(boolean isEnabled) {
        _isJarCacheEnabled = isEnabled;
    }

    private void verbose(String name, String msg) {
        if (this._isVerbose) {
            int i = this._verboseDepth;
            while (this._verboseDepth > 0) {
                System.err.print(' ');
                --this._verboseDepth;
            }
            System.err.println(this.toString() + " " + name + " " + msg);
        }
    }

    public static long getGlobalDependencyCheckInterval() {
        return _globalDependencyCheckInterval;
    }

    public static void setGlobalDependencyCheckInterval(long interval) {
        _globalDependencyCheckInterval = interval;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public boolean isDestroyed() {
        return this._lifecycle.isDestroyed();
    }

    public void addLoader(Loader loader) {
        int p = this._loaders.indexOf(loader);
        if (p >= 0) {
            Loader oldLoader = this._loaders.get(p);
            if (oldLoader != loader) {
                this.addLoader(loader, p);
            }
        } else {
            this.addLoader(loader, this._loaders.size());
        }
        this._hasNewLoader = true;
    }

    public void addLoader(Loader loader, int offset) {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException(DynamicClassLoader.L().l("can't add loaders after initialization"));
        }
        if (DynamicClassLoader.log().isLoggable(Level.FINEST)) {
            DynamicClassLoader.log().finest(this + " adding loader " + loader);
        }
        this._loaders.add(offset, loader);
        if (loader.getLoader() == null) {
            loader.setLoader(this);
        }
        if (loader instanceof Dependency) {
            this._dependencies.add((Dependency)loader);
        }
        if (loader instanceof Make) {
            if (this._makeList == null) {
                this._makeList = new MakeContainer();
            }
            this._makeList.add((Make)((Object)loader));
        }
        if (loader instanceof ClassLoaderListener) {
            this.addListener(new WeakLoaderListener((ClassLoaderListener)((Object)loader)));
        }
        this._hasNewLoader = true;
    }

    public ArrayList<Loader> getLoaders() {
        return this._loaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJarManifestClassPath(Path path) throws IOException {
        Path contextPath;
        Path manifestPath;
        if (path.isDirectory()) {
            manifestPath = path.lookup("META-INF/MANIFEST.MF");
            contextPath = path;
        } else {
            JarPath jar = JarPath.create(path);
            manifestPath = jar.lookup("META-INF/MANIFEST.MF");
            contextPath = path.getParent();
        }
        if (manifestPath.canRead()) {
            ReadStream is = manifestPath.openRead();
            try {
                Manifest manifest = new Manifest((InputStream)is);
                Attributes main = manifest.getMainAttributes();
                String classPath = main.getValue("Class-Path");
                this.addManifestClassPath(classPath, contextPath);
            }
            catch (IOException e) {
                DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
                return;
            }
            finally {
                is.close();
            }
        }
    }

    public void addManifestClassPath(String classPath, Path pwd) {
        if (classPath == null) {
            return;
        }
        String[] urls = Pattern.compile("[\\s,]+").split(classPath);
        if (urls == null) {
            return;
        }
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            if (url.equals("")) continue;
            this.addJar(pwd.lookup(url));
        }
    }

    public void addNative(Path path) {
        this._nativePath.add(path);
    }

    public void addJar(Path jar) {
        this.addRoot(jar);
    }

    public void addRoot(Path root) {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException(DynamicClassLoader.L().l("can't add roots after closing"));
        }
        if (root instanceof JarPath || root.getPath().endsWith(".jar") || root.getPath().endsWith(".zip")) {
            if (this._jarLoader == null) {
                this._jarLoader = new JarLoader();
                this.addLoader(this._jarLoader);
            }
            this._jarLoader.addJar(root);
        } else {
            SimpleLoader loader = new SimpleLoader();
            loader.setPath(root);
            if (!this._loaders.contains(loader)) {
                this.addLoader(loader);
            }
        }
        this.addURL(root);
    }

    public void addPathClass(String className, Path path) {
        if (this._pathLoader == null) {
            this._pathLoader = new PathLoader();
            this._loaders.add(0, this._pathLoader);
        }
        this._pathLoader.put(className, path);
    }

    public void addURL(Path path) {
        try {
            if (path.getScheme().equals("memory")) {
                return;
            }
            if (!(path.getScheme().equals("jar") || path.getFullPath().endsWith(".jar") || path.getURL().endsWith("/"))) {
                path = path.lookup("./");
            }
            this.addURL(new URL(path.getURL()));
        }
        catch (MalformedURLException e) {
            DynamicClassLoader.log().warning(e.toString());
        }
        catch (Exception e) {
            DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public void addURL(URL url) {
        this.addURL(this._urls.length, url);
    }

    public void addURL(int index, URL url) {
        int i;
        super.addURL(url);
        for (int i2 = 0; i2 < this._urls.length; ++i2) {
            if (!this._urls[i2].equals(url)) continue;
            return;
        }
        URL[] newURLs = new URL[this._urls.length + 1];
        for (i = 0; i < index; ++i) {
            newURLs[i] = this._urls[i];
        }
        newURLs[index] = url;
        for (i = index + 1; i < newURLs.length; ++i) {
            newURLs[i] = this._urls[i - 1];
        }
        this._urls = newURLs;
    }

    public void appendToClassPathForInstrumentation(String path) {
        this.addRoot(Vfs.lookup(path));
    }

    @Override
    public URL[] getURLs() {
        return this._urls;
    }

    public void setDependencyCheckInterval(long interval) {
        this._dependencies.setCheckInterval(interval);
    }

    public long getDependencyCheckInterval() {
        if (this._dependencies != null) {
            return this._dependencies.getCheckInterval();
        }
        return 0L;
    }

    public void setEnableDependencyCheck(boolean enable) {
        this._isEnableDependencyCheck = enable;
    }

    public void addDependency(Dependency dependency) {
        this._dependencies.add(dependency);
    }

    public void addPermission(String path, String actions) {
        this.addPermission(new FilePermission(path, actions));
    }

    public void addPermission(Permission permission) {
        if (this._permissions == null) {
            this._permissions = new ArrayList();
        }
        this._permissions.add(permission);
    }

    public ArrayList<Permission> getPermissions() {
        return this._permissions;
    }

    public void addPermissions(ArrayList<Permission> perms) {
        if (perms == null) {
            return;
        }
        if (this._permissions == null) {
            this._permissions = new ArrayList();
        }
        this._permissions.addAll(perms);
    }

    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    public void setServletHack(boolean servletHack) {
        this._useServletHack = servletHack;
        if (this._parentPriorityPackages == null) {
            this._parentPriorityPackages = new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(ClassLoaderListener listener) {
        ArrayList<ClassLoaderListener> listeners;
        if (this._lifecycle.isDestroyed()) {
            IllegalStateException e = new IllegalStateException(DynamicClassLoader.L().l("attempted to add listener to a closed classloader {0}", (Object)this));
            DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
            return;
        }
        WeakCloseListener closeListener = null;
        Object object = this;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
                closeListener = new WeakCloseListener(this);
            }
            listeners = this._listeners;
        }
        if (closeListener != null) {
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DynamicClassLoader)) continue;
                ((DynamicClassLoader)parent).addListener(closeListener);
                break;
            }
        }
        object = listeners;
        synchronized (object) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ClassLoaderListener oldListener = listeners.get(i);
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                listeners.remove(i);
            }
            listeners.add(listener);
        }
        if (this._lifecycle.isActive()) {
            listener.classLoaderInit(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(ClassLoaderListener listener) {
        ArrayList<ClassLoaderListener> listeners = this._listeners;
        if (listeners == null) {
            return;
        }
        ArrayList<ClassLoaderListener> arrayList = listeners;
        synchronized (arrayList) {
            for (int i = listeners.size() - 1; i >= 0; --i) {
                ClassLoaderListener oldListener = listeners.get(i);
                if (listener == oldListener) {
                    listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<ClassLoaderListener> getListeners() {
        ArrayList<ClassLoaderListener> listeners = new ArrayList<ClassLoaderListener>();
        ArrayList<ClassLoaderListener> listenerList = this._listeners;
        if (listenerList != null) {
            ArrayList<ClassLoaderListener> arrayList = listenerList;
            synchronized (arrayList) {
                for (int i = 0; i < listenerList.size(); ++i) {
                    ClassLoaderListener listener = listenerList.get(i);
                    if (listener != null) {
                        listeners.add(listener);
                        continue;
                    }
                    listenerList.remove(i);
                    --i;
                }
            }
        }
        return listeners;
    }

    protected final void sendAddLoaderEvent() {
        if (this._hasNewLoader) {
            this._hasNewLoader = false;
            this.scan();
            this.configureEnhancerEvent();
        }
    }

    protected void configureEnhancerEvent() {
    }

    public void addParentPriorityPackages(String[] pkg) {
        for (int i = 0; pkg != null && i < pkg.length; ++i) {
            this.addParentPriorityPackage(pkg[i]);
        }
    }

    public void addParentPriorityPackage(String pkg) {
        if (this._parentPriorityPackages == null) {
            this._parentPriorityPackages = new String[0];
        }
        int oldLength = this._parentPriorityPackages.length;
        String[] newPkgs = new String[oldLength + 1];
        System.arraycopy(this._parentPriorityPackages, 0, newPkgs, 0, oldLength);
        if (!pkg.endsWith(".")) {
            pkg = pkg + '.';
        }
        newPkgs[oldLength] = pkg;
        this._parentPriorityPackages = newPkgs;
    }

    public void addPriorityPackage(String pkg) {
        if (this._priorityPackages == null) {
            this._priorityPackages = new String[0];
        }
        int oldLength = this._priorityPackages.length;
        String[] newPkgs = new String[oldLength + 1];
        System.arraycopy(this._priorityPackages, 0, newPkgs, 0, oldLength);
        if (!pkg.endsWith(".")) {
            pkg = pkg + '.';
        }
        newPkgs[oldLength] = pkg;
        this._priorityPackages = newPkgs;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection perms = super.getPermissions(codeSource);
        ArrayList<Permission> permissions = this._permissions;
        for (int i = 0; permissions != null && i < permissions.size(); ++i) {
            Permission permission = permissions.get(i);
            perms.add(permission);
        }
        return perms;
    }

    protected void addCodeBasePath(String path) {
    }

    public void addTransformer(ClassFileTransformer transformer) {
        if (this._classFileTransformerList == null) {
            this._classFileTransformerList = new ArrayList();
        }
        this._classFileTransformerList.add(transformer);
    }

    protected ArrayList<ClassFileTransformer> getTransformerList() {
        return this._classFileTransformerList;
    }

    public final String getClassPath() {
        StringBuilder head = new StringBuilder();
        this.buildClassPath(head);
        return head.toString();
    }

    protected final void buildClassPath(StringBuilder head) {
        ClassLoader parent = this.getParent();
        if (parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)parent).buildClassPath(head);
        } else {
            head.append(CauchoSystem.getClassPath());
            while (parent != null) {
                if (parent instanceof URLClassLoader) {
                    URLClassLoader urlLoader = (URLClassLoader)parent;
                    for (URL url : urlLoader.getURLs()) {
                        if (head.length() > 0) {
                            head.append(CauchoSystem.getPathSeparatorChar());
                        }
                        head.append(url);
                    }
                }
                parent = parent.getParent();
            }
        }
        ArrayList<Loader> loaders = this.getLoaders();
        if (loaders != null) {
            for (int i = 0; i < loaders.size(); ++i) {
                Loader loader = loaders.get(i);
                loader.buildClassPath(head);
            }
        }
    }

    public final String getLocalClassPath() {
        StringBuilder head = new StringBuilder();
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            this.buildClassPath(head);
        }
        return head.toString();
    }

    public final String getSourcePath() {
        StringBuilder head = new StringBuilder();
        this.buildSourcePath(head);
        return head.toString();
    }

    protected final void buildSourcePath(StringBuilder head) {
        ClassLoader parent = this.getParent();
        if (parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)parent).buildSourcePath(head);
        } else {
            head.append(CauchoSystem.getClassPath());
        }
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            loader.buildSourcePath(head);
        }
    }

    public final String getResourcePathSpecificFirst() {
        ArrayList<String> pathList = new ArrayList<String>();
        this.buildResourcePathSpecificFirst(pathList);
        StringBuilder sb = new StringBuilder();
        char sep = CauchoSystem.getPathSeparatorChar();
        if (pathList.size() == 0) {
            return "";
        }
        sb.append(pathList.get(0));
        for (int i = 1; i < pathList.size(); ++i) {
            sb.append(sep);
            sb.append(pathList.get(i));
        }
        return sb.toString();
    }

    protected final void buildResourcePathSpecificFirst(ArrayList<String> pathList) {
        ClassLoader parent = this.getParent();
        ArrayList<Loader> loaders = this.getLoaders();
        int size = loaders != null ? loaders.size() : 0;
        for (int i = 0; i < size; ++i) {
            Loader loader = loaders.get(i);
            loader.buildSourcePath(pathList);
        }
        if (parent instanceof DynamicClassLoader) {
            ((DynamicClassLoader)parent).buildResourcePathSpecificFirst(pathList);
        } else {
            String tail = CauchoSystem.getClassPath();
            if (tail != null) {
                char sep = CauchoSystem.getPathSeparatorChar();
                String[] values = tail.split("[" + sep + "]");
                for (int i = 0; i < values.length; ++i) {
                    pathList.add(values[i]);
                }
            }
        }
    }

    public final boolean isModified() {
        return this.isModified(this._isEnableDependencyCheck);
    }

    public final boolean isModified(boolean enable) {
        if (this._lifecycle.isDestroyed()) {
            return true;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return true;
        }
        if (enable) {
            boolean isModified = dependencies.isModified();
            return isModified;
        }
        boolean isModified = DynamicClassLoader.isModified(this.getParent());
        return isModified;
    }

    public final boolean isModifiedNow() {
        if (this._lifecycle.isDestroyed()) {
            return true;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return true;
        }
        return dependencies.isModifiedNow();
    }

    public final boolean logModified(Logger log) {
        if (this._lifecycle.isDestroyed()) {
            return true;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies != null) {
            return dependencies.logModified(log);
        }
        return false;
    }

    public final void resetDependencyCheckInterval() {
        if (this._lifecycle.isDestroyed()) {
            return;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return;
        }
        dependencies.resetDependencyCheckInterval();
    }

    public final void clearModified() {
        if (this._lifecycle.isDestroyed()) {
            return;
        }
        DependencyContainer dependencies = this._dependencies;
        if (dependencies == null) {
            return;
        }
        dependencies.clearModified();
    }

    public static boolean isModified(ClassLoader loader) {
        while (loader != null) {
            if (loader instanceof DynamicClassLoader) {
                return ((DynamicClassLoader)loader).isModified();
            }
            loader = loader.getParent();
        }
        return false;
    }

    @Override
    public final void make() throws Exception {
        for (ClassLoader loader = this.getParent(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof Make)) continue;
            ((Make)((Object)loader)).make();
            break;
        }
        if (this._makeList != null) {
            this._makeList.make();
        }
    }

    @Override
    protected Package definePackage(String name, String a1, String a2, String a3, String b1, String b2, String b3, URL url) {
        name = name.replace('/', '.');
        if ((name = name.replace('\\', '.')).endsWith(".")) {
            name = name.substring(0, name.length() - 1);
        }
        return super.definePackage(name, a1, a2, a3, b1, b2, b3, url);
    }

    public void init() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this.sendAddLoaderEvent();
            ArrayList<ClassLoaderListener> listeners = this.getListeners();
            if (listeners != null) {
                for (int i = 0; i < listeners.size(); ++i) {
                    ClassLoaderListener listener = listeners.get(i);
                    listener.classLoaderInit(this);
                }
            }
        }
        catch (Exception e) {
            DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
        }
    }

    public void validate() throws ConfigException {
        ArrayList<Loader> loaders = this.getLoaders();
        if (loaders == null) {
            throw new IllegalStateException(_L.l("Class loader {0} is closed during initialization.", (Object)this));
        }
        for (int i = 0; i < loaders.size(); ++i) {
            loaders.get(i).validate();
        }
    }

    public void scan() {
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class cl = this.loadClassImpl(name, resolve);
        if (cl != null) {
            return cl;
        }
        throw new ClassNotFoundException(name + " in " + this);
    }

    protected Class loadClassImpl(String name, boolean resolve) throws ClassNotFoundException {
        Class cl;
        ClassEntry entry;
        if (this._entryCache != null && (entry = this._entryCache.get(name)) != null && (cl = entry.getEntryClass()) != null) {
            return cl;
        }
        Class<?> cl2 = this.findLoadedClass(name);
        if (cl2 != null) {
            if (resolve) {
                this.resolveClass(cl2);
            }
            return cl2;
        }
        if (this._lifecycle.isDestroyed()) {
            DynamicClassLoader.log().fine(DynamicClassLoader.L().l("Loading class {0} when class loader {1} has been closed.", (Object)name, (Object)this));
            return super.loadClass(name, resolve);
        }
        boolean normalJdkOrder = this.isNormalJdkOrder(name);
        if (this._lifecycle.isBeforeInit()) {
            this.init();
        }
        this.sendAddLoaderEvent();
        if (normalJdkOrder) {
            try {
                ClassLoader parent = this.getParent();
                cl2 = parent instanceof DynamicClassLoader ? ((DynamicClassLoader)parent).loadClassImpl(name, resolve) : (parent != null ? Class.forName(name, false, parent) : this.findSystemClass(name));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (cl2 == null) {
                cl2 = this.findClassImpl(name);
            }
        } else {
            try {
                cl2 = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                ClassLoader parent = this.getParent();
                cl2 = parent != null ? Class.forName(name, false, parent) : this.findSystemClass(name);
            }
        }
        if (resolve && cl2 != null) {
            this.resolveClass(cl2);
        }
        return cl2;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class cl = this.findClassImpl(name);
        if (cl != null) {
            return cl;
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClassImpl(String name) throws ClassNotFoundException {
        if (this._isVerbose) {
            this.verbose(name, "findClass");
        }
        if (this._lifecycle.isDestroyed()) {
            DynamicClassLoader.log().fine("Class loader has been closed.");
            return super.findClass(name);
        }
        if (this._lifecycle.isBeforeInit()) {
            this.init();
        }
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        ClassEntry entry = null;
        ClassEntry classEntry = entry = this._entryCache == null ? null : this._entryCache.get(name);
        if (entry == null) {
            entry = this.getClassEntry(name);
        }
        if (entry == null) {
            return null;
        }
        if (entry != null && this._isVerbose) {
            this.verbose(name, this.isNormalJdkOrder(name) ? "found" : "found (took priority from parent)");
        }
        if (this._isEnableDependencyCheck) {
            entry.addDependencies(this._dependencies);
        }
        DynamicClassLoader dynamicClassLoader = this;
        synchronized (dynamicClassLoader) {
            ClassEntry oldEntry;
            if (this._entryCache == null) {
                this._entryCache = new Hashtable(8);
            }
            if ((oldEntry = this._entryCache.get(name)) != null) {
                entry = oldEntry;
            } else {
                this._entryCache.put(name, entry);
            }
        }
        try {
            return this.loadClass(entry);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            DynamicClassLoader.log().log(Level.FINE, e.toString(), e);
            throw new ClassNotFoundException(name + " [" + e + "]", e);
        }
    }

    protected ClassEntry getClassEntry(String name) throws ClassNotFoundException {
        String pathName = name.replace('.', '/') + ".class";
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            ClassEntry entry = loader.getClassEntry(name, pathName);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(ClassEntry entry) throws IOException, ClassNotFoundException {
        ClassEntry classEntry = entry;
        synchronized (classEntry) {
            Class<?> cl = entry.getEntryClass();
            if (cl != null) {
                return cl;
            }
            entry.preLoad();
            String name = entry.getName();
            int p = name.lastIndexOf(46);
            if (p > 0) {
                String packageName = name.substring(0, p);
                Package pkg = this.getPackage(packageName);
                ClassPackage classPackage = entry.getClassPackage();
                if (pkg == null) {
                    if (classPackage != null) {
                        this.definePackage(packageName, classPackage.getSpecificationTitle(), classPackage.getSpecificationVersion(), classPackage.getSpecificationVendor(), classPackage.getImplementationTitle(), classPackage.getImplementationVersion(), classPackage.getImplementationVendor(), null);
                    } else {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                }
            }
            ByteBuffer buffer = new ByteBuffer();
            entry.load(buffer);
            byte[] bBuf = buffer.getBuffer();
            int bLen = buffer.length();
            if (this._classFileTransformerList != null) {
                Class<?> redefineClass = null;
                String className = name.replace('.', '/');
                if (bBuf.length != bLen) {
                    byte[] tempBuf = new byte[bLen];
                    System.arraycopy(bBuf, 0, tempBuf, 0, bLen);
                    bBuf = tempBuf;
                }
                ProtectionDomain protectionDomain = null;
                for (int i = 0; i < this._classFileTransformerList.size(); ++i) {
                    ClassFileTransformer transformer = this._classFileTransformerList.get(i);
                    try {
                        byte[] enhancedBuffer = transformer.transform(this, className, redefineClass, protectionDomain, bBuf);
                        if (enhancedBuffer == null) continue;
                        bBuf = enhancedBuffer;
                        bLen = enhancedBuffer.length;
                        if (!this._isVerbose) continue;
                        this.verbose(name, String.valueOf(transformer));
                        continue;
                    }
                    catch (EnhancerRuntimeException e) {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            try {
                cl = this.defineClass(entry.getName(), bBuf, 0, bLen, entry.getCodeSource());
            }
            catch (RuntimeException e) {
                DynamicClassLoader.log().log(Level.FINE, entry.getName() + " [" + e.toString() + "]", e);
                throw e;
            }
            catch (Exception e) {
                DynamicClassLoader.log().log(Level.FINE, entry.getName() + " [" + e.toString() + "]", e);
                ClassNotFoundException exn = new ClassNotFoundException(entry.getName() + " [" + e + "]", e);
                throw exn;
            }
            entry.setEntryClass(cl);
            if (entry.postLoad()) {
                this._dependencies.add((Dependency)AlwaysModified.create());
                this._dependencies.setModified(true);
            }
            return cl;
        }
    }

    @Override
    public URL getResource(String name) {
        boolean isNormalJdkOrder;
        URL url;
        if (this._resourceCache == null) {
            long expireInterval = this.getDependencyCheckInterval();
            this._resourceCache = new TimedCache(256, expireInterval);
        }
        if ((url = (URL)this._resourceCache.get((Object)name)) == NULL_URL) {
            return null;
        }
        if (url != null) {
            return url;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((isNormalJdkOrder = this.isNormalJdkOrder(name)) && (url = this.getParentResource(name)) != null) {
            return url;
        }
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; loaders != null && i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            url = loader.getResource(name);
            if (url == null) continue;
            this._resourceCache.put((Object)name, (Object)url);
            return url;
        }
        if (!isNormalJdkOrder && (url = this.getParentResource(name)) != null) {
            return url;
        }
        this._resourceCache.put((Object)name, (Object)NULL_URL);
        return null;
    }

    private URL getParentResource(String name) {
        URL url;
        ClassLoader parent = this.getParent();
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        if (parent != null) {
            URL url2 = parent.getResource(name);
            if (url2 != null) {
                this._resourceCache.put((Object)name, (Object)url2);
                return url2;
            }
        } else if (this != systemLoader && (url = DynamicClassLoader.getSystemResource(name)) != null) {
            this._resourceCache.put((Object)name, (Object)url);
            return url;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        boolean isNormalJdkOrder = this.isNormalJdkOrder(name);
        InputStream is = null;
        if (isNormalJdkOrder && (is = this.getParentResourceAsStream(name)) != null) {
            return is;
        }
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; loaders != null && i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            is = loader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        if (!isNormalJdkOrder) {
            is = this.getParentResourceAsStream(name);
        }
        return is;
    }

    private InputStream getParentResourceAsStream(String name) {
        InputStream is;
        ClassLoader parent = this.getParent();
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        if (parent != null) {
            InputStream is2 = parent.getResourceAsStream(name);
            if (is2 != null) {
                return is2;
            }
        } else if (this != systemLoader && (is = DynamicClassLoader.getSystemResourceAsStream(name)) != null) {
            return is;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        Vector<URL> resources = new Vector<URL>();
        ArrayList<Loader> loaders = this.getLoaders();
        if (loaders != null) {
            for (int i = 0; i < loaders.size(); ++i) {
                Loader loader = loaders.get(i);
                loader.getResources(resources, name);
            }
        }
        return resources.elements();
    }

    @Override
    public String findLibrary(String name) {
        int i;
        String systemName = System.mapLibraryName(name);
        ArrayList<Loader> loaders = this.getLoaders();
        for (i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            Path path = loader.getPath(systemName);
            if (path == null || !path.canRead()) continue;
            return path.getNativePath();
        }
        for (i = 0; i < this._nativePath.size(); ++i) {
            Path path = this._nativePath.get(i);
            if (!path.canRead()) continue;
            return path.getNativePath();
        }
        return super.findLibrary(name);
    }

    public Path findPath(String name) {
        ArrayList<Loader> loaders = this.getLoaders();
        for (int i = 0; i < loaders.size(); ++i) {
            Loader loader = loaders.get(i);
            Path path = loader.getPath(name);
            if (path == null || !path.canRead()) continue;
            return path;
        }
        return null;
    }

    private boolean isNormalJdkOrder(String className) {
        String canonName;
        if (this._priorityPackages != null) {
            canonName = className.replace('/', '.');
            canonName = canonName.replace('\\', '.');
            for (String priorityPackage : this._priorityPackages) {
                if (!canonName.startsWith(priorityPackage)) continue;
                return false;
            }
        }
        if (!this._useServletHack) {
            return true;
        }
        canonName = className.replace('/', '.');
        canonName = canonName.replace('\\', '.');
        String[] pkgs = this._parentPriorityPackages;
        for (int i = 0; pkgs != null && i < pkgs.length; ++i) {
            if (!canonName.startsWith(pkgs[i])) continue;
            return true;
        }
        return false;
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.stop();
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (!this._lifecycle.toDestroying()) {
            return;
        }
        try {
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof DynamicClassLoader)) continue;
                DynamicClassLoader loader = (DynamicClassLoader)parent;
                if (this._closeListener == null) continue;
                loader.removeListener(this._closeListener);
            }
            ArrayList<ClassLoaderListener> listeners = this._listeners;
            this._listeners = null;
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                if (listeners != null) {
                    for (int i = listeners.size() - 1; i >= 0; --i) {
                        ClassLoaderListener listener = listeners.get(i);
                        try {
                            thread.setContextClassLoader(this);
                            listener.classLoaderDestroy(this);
                            continue;
                        }
                        catch (Throwable e) {
                            DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
                        }
                    }
                }
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
            ArrayList<Loader> loaders = this.getLoaders();
            for (int i = loaders.size() - 1; i >= 0; --i) {
                Loader loader = loaders.get(i);
                try {
                    loader.destroy();
                    continue;
                }
                catch (Throwable e) {
                    DynamicClassLoader.log().log(Level.WARNING, e.toString(), e);
                }
            }
        }
        finally {
            this._closeListener = null;
            this._listeners = null;
            this._entryCache = null;
            this._makeList = null;
            this._loaders = null;
            this._jarLoader = null;
            this._dependencies = null;
            this._permissions = null;
            this._securityManager = null;
            this._codeSource = null;
            this._classFileTransformerList = null;
            this._lifecycle.toDestroy();
        }
    }

    public static void setOldLoader(Thread thread, ClassLoader oldLoader) {
        if (!(oldLoader instanceof DynamicClassLoader)) {
            thread.setContextClassLoader(oldLoader);
            return;
        }
        DynamicClassLoader dynLoader = (DynamicClassLoader)oldLoader;
        if (!dynLoader.isDestroyed()) {
            thread.setContextClassLoader(oldLoader);
        } else {
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this;
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.getNewTempClassLoader();
    }

    public ClassLoader getNewTempClassLoader() {
        return new TempDynamicClassLoader(this);
    }

    protected void replace(DynamicClassLoader source) {
        this._id = source._id;
        this._loaders.addAll(source._loaders);
        this._jarLoader = source._jarLoader;
        this._dependencies = source._dependencies;
        this._makeList = source._makeList;
        this._useServletHack = source._useServletHack;
        this._parentPriorityPackages = source._parentPriorityPackages;
        if (source._listeners != null) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            this._listeners.addAll(source._listeners);
            source._listeners.clear();
        }
        this._securityManager = source._securityManager;
        if (source._permissions != null) {
            if (this._permissions == null) {
                this._permissions = new ArrayList();
            }
            this._permissions.addAll(source._permissions);
        }
        this._codeSource = source._codeSource;
        this._lifecycle.copyState(source._lifecycle);
    }

    public String toString() {
        if (this._id != null) {
            return this.getClass().getSimpleName() + "[" + this._id + "]";
        }
        return this.getClass().getSimpleName() + this.getLoaders();
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(DynamicClassLoader.class);
        }
        return _L;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(DynamicClassLoader.class.getName());
        }
        return _log;
    }

    static {
        NULL_URL_ARRAY = new URL[0];
        _globalDependencyCheckInterval = 2000L;
        URL url = null;
        try {
            url = new URL("file:/caucho/null");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NULL_URL = url;
    }
}

