/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.jca.UserTransactionProxy;
import com.caucho.jmx.Jmx;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.AddLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.EnvironmentProperties;
import com.caucho.loader.WeakStopListener;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.loader.enhancer.ScanManager;
import com.caucho.log.EnvironmentStream;
import com.caucho.naming.Jndi;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.ResinThreadPoolExecutor;
import com.caucho.vfs.Vfs;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerFactory;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentClassLoader
extends DynamicClassLoader {
    private static Logger _log;
    private static boolean _isStaticInit;
    private static EnvironmentLocal<ArrayList<EnvironmentListener>> _childListeners;
    private static EnvironmentLocal<ArrayList<AddLoaderListener>> _addLoaderListeners;
    private EnvironmentBean _owner;
    private Hashtable<String, Object> _attributes = new Hashtable(8);
    private ArrayList<ScanListener> _scanListeners;
    private ArrayList<URL> _pendingScanUrls = new ArrayList();
    private ArrayList<EnvironmentListener> _listeners;
    private WeakStopListener _stopListener;
    private volatile Lifecycle _lifecycle = new Lifecycle();
    private boolean _isConfigComplete;
    private Throwable _configException;

    public EnvironmentClassLoader() {
        this(Thread.currentThread().getContextClassLoader(), null);
    }

    public EnvironmentClassLoader(String id) {
        this(Thread.currentThread().getContextClassLoader(), id);
    }

    public EnvironmentClassLoader(ClassLoader parent) {
        this(parent, null);
    }

    public EnvironmentClassLoader(ClassLoader parent, String id) {
        super(parent);
        if (id != null) {
            this.setId(id);
        }
        this.initListeners();
    }

    public EnvironmentBean getOwner() {
        return this._owner;
    }

    public void setOwner(EnvironmentBean owner) {
        this._owner = owner;
    }

    public void setConfigException(Throwable e) {
        if (this._configException == null) {
            this._configException = e;
        }
    }

    public Throwable getConfigException() {
        return this._configException;
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    @Override
    public void init() {
        super.init();
        this.initEnvironment();
    }

    protected void initEnvironment() {
        EnvironmentClassLoader.initializeEnvironment();
    }

    public Object getAttribute(String name) {
        if (this._attributes != null) {
            return this._attributes.get(name);
        }
        return null;
    }

    public Object setAttribute(String name, Object obj) {
        if (obj == null) {
            if (this._attributes == null) {
                return null;
            }
            return this._attributes.remove(name);
        }
        if (this._attributes == null) {
            this._attributes = new Hashtable(8);
        }
        return this._attributes.put(name, obj);
    }

    public Object removeAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EnvironmentListener listener) {
        boolean isInit = false;
        Object object = this;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
                isInit = true;
            }
        }
        if (isInit) {
            this.initListeners();
        }
        object = this._listeners;
        synchronized (object) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                EnvironmentListener oldListener = this._listeners.get(i);
                if (listener == oldListener) {
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
            this._listeners.add(listener);
        }
        if (this._lifecycle.isStarting()) {
            listener.environmentBind(this);
        }
        if (this._lifecycle.isStarting() && this._isConfigComplete) {
            listener.environmentStart(this);
        }
    }

    private void initListeners() {
        for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof EnvironmentClassLoader)) continue;
            EnvironmentClassLoader loader = (EnvironmentClassLoader)parent;
            if (this._stopListener == null) {
                this._stopListener = new WeakStopListener(this);
            }
            loader.addListener(this._stopListener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EnvironmentListener listener) {
        if (this._listeners == null) {
            return;
        }
        ArrayList<EnvironmentListener> arrayList = this._listeners;
        synchronized (arrayList) {
            for (int i = this._listeners.size() - 1; i >= 0; --i) {
                EnvironmentListener oldListener = this._listeners.get(i);
                if (listener == oldListener) {
                    this._listeners.remove(i);
                    return;
                }
                if (oldListener != null) continue;
                this._listeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildListener(EnvironmentListener listener) {
        EnvironmentLocal<ArrayList<EnvironmentListener>> environmentLocal = _childListeners;
        synchronized (environmentLocal) {
            ArrayList<EnvironmentListener> listeners = _childListeners.getLevel(this);
            if (listeners == null) {
                listeners = new ArrayList();
                _childListeners.set(listeners, this);
            }
            listeners.add(listener);
        }
        if (this._lifecycle.isStarting() && this._isConfigComplete) {
            listener.environmentStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildListener(EnvironmentListener listener) {
        EnvironmentLocal<ArrayList<EnvironmentListener>> environmentLocal = _childListeners;
        synchronized (environmentLocal) {
            ArrayList<EnvironmentListener> listeners = _childListeners.getLevel(this);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<EnvironmentListener> getEnvironmentListeners() {
        ArrayList<EnvironmentListener> listeners = new ArrayList<EnvironmentListener>();
        Object object = _childListeners;
        synchronized (object) {
            for (ClassLoader loader = this; loader != null; loader = loader.getParent()) {
                ArrayList<EnvironmentListener> childListeners;
                if (!(loader instanceof EnvironmentClassLoader) || (childListeners = _childListeners.getLevel(loader)) == null) continue;
                listeners.addAll(childListeners);
            }
        }
        if (this._listeners == null) {
            return listeners;
        }
        object = this._listeners;
        synchronized (object) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                EnvironmentListener listener = this._listeners.get(i);
                if (listener != null) {
                    listeners.add(listener);
                    continue;
                }
                this._listeners.remove(i);
                --i;
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoaderListener(AddLoaderListener listener) {
        EnvironmentLocal<ArrayList<AddLoaderListener>> environmentLocal = _addLoaderListeners;
        synchronized (environmentLocal) {
            ArrayList<AddLoaderListener> listeners = _addLoaderListeners.getLevel(this);
            if (listeners == null) {
                listeners = new ArrayList();
                _addLoaderListeners.set(listeners, this);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
        listener.addLoader(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<AddLoaderListener> getLoaderListeners() {
        ArrayList<AddLoaderListener> listeners = new ArrayList<AddLoaderListener>();
        EnvironmentLocal<ArrayList<AddLoaderListener>> environmentLocal = _addLoaderListeners;
        synchronized (environmentLocal) {
            for (ClassLoader loader = this; loader != null; loader = loader.getParent()) {
                ArrayList<AddLoaderListener> childListeners;
                if (!(loader instanceof EnvironmentClassLoader) || (childListeners = _addLoaderListeners.getLevel(loader)) == null) continue;
                listeners.addAll(childListeners);
            }
        }
        return listeners;
    }

    @Override
    protected void configureEnhancerEvent() {
        ArrayList<AddLoaderListener> listeners = this.getLoaderListeners();
        for (int i = 0; listeners != null && i < listeners.size(); ++i) {
            listeners.get(i).addLoader(this);
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this._pendingScanUrls.add(url);
    }

    public void addScanListener(ScanListener listener) {
        if (this._scanListeners == null) {
            this._scanListeners = new ArrayList();
        }
        this._scanListeners.add(listener);
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (URL url : this.getURLs()) {
            if (this._pendingScanUrls.contains(url)) continue;
            urlList.add(url);
        }
        if (urlList.size() > 0) {
            block6: {
                try {
                    this.make();
                }
                catch (Exception e) {
                    EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                    if (this._configException != null) break block6;
                    this._configException = e;
                }
            }
            ArrayList<ScanListener> selfList = new ArrayList<ScanListener>();
            selfList.add(listener);
            ScanManager scanManager = new ScanManager(selfList);
            for (URL url : urlList) {
                scanManager.scan(this, url);
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public void scan() {
        block7: {
            ArrayList<URL> urlList = new ArrayList<URL>(this._pendingScanUrls);
            this._pendingScanUrls.clear();
            try {
                if (this._scanListeners != null && urlList.size() > 0) {
                    block6: {
                        try {
                            this.make();
                        }
                        catch (Exception e) {
                            EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                            if (this._configException != null) break block6;
                            this._configException = e;
                        }
                    }
                    ScanManager scanManager = new ScanManager(this._scanListeners);
                    for (URL url : urlList) {
                        scanManager.scan(this, url);
                    }
                }
                this.configureEnhancerEvent();
            }
            catch (Exception e) {
                EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                if (this._configException != null) break block7;
                this._configException = e;
            }
        }
    }

    private void config() {
        this.sendAddLoaderEvent();
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        int size = listeners.size();
        for (int i = 0; listeners != null && i < size; ++i) {
            EnvironmentListener listener = listeners.get(i);
            listener.environmentBind(this);
        }
        this._isConfigComplete = true;
    }

    public void start() {
        if (!this._lifecycle.toStarting()) {
            return;
        }
        this.sendAddLoaderEvent();
        this.config();
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        int size = listeners.size();
        for (int i = 0; listeners != null && i < size; ++i) {
            EnvironmentListener listener = listeners.get(i);
            listener.environmentStart(this);
        }
        this._lifecycle.toActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        ArrayList<EnvironmentListener> listeners = this.getEnvironmentListeners();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this);
        try {
            if (listeners != null) {
                for (int i = listeners.size() - 1; i >= 0; --i) {
                    EnvironmentListener listener = listeners.get(i);
                    try {
                        listener.environmentStop(this);
                        continue;
                    }
                    catch (Throwable e) {
                        EnvironmentClassLoader.log().log(Level.WARNING, e.toString(), e);
                    }
                }
            }
            Object var8_7 = null;
            thread.setContextClassLoader(oldLoader);
            ResinThreadPoolExecutor.getThreadPool().stopEnvironment(this);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            thread.setContextClassLoader(oldLoader);
            ResinThreadPoolExecutor.getThreadPool().stopEnvironment(this);
            throw throwable;
        }
    }

    protected void replace(EnvironmentClassLoader source) {
        super.replace(source);
        this._owner = source._owner;
        this._attributes = source._attributes;
        if (source._listeners != null) {
            if (this._listeners == null) {
                this._listeners = new ArrayList();
            }
            this._listeners.addAll(source._listeners);
            source._listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            WeakStopListener stopListener = this._stopListener;
            this._stopListener = null;
            this.stop();
            super.destroy();
            for (ClassLoader parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof EnvironmentClassLoader)) continue;
                EnvironmentClassLoader loader = (EnvironmentClassLoader)parent;
                loader.removeListener(stopListener);
            }
            Object var5_4 = null;
            this._owner = null;
            this._attributes = null;
            this._listeners = null;
            this._scanListeners = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._owner = null;
            this._attributes = null;
            this._listeners = null;
            this._scanListeners = null;
            throw throwable;
        }
    }

    @Override
    public String toString() {
        if (this.getId() != null) {
            return this.getClass().getSimpleName() + "[" + this.getId() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initializeEnvironment() {
        block14: {
            if (_isStaticInit) {
                return;
            }
            _isStaticInit = true;
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                try {
                    thread.setContextClassLoader(systemLoader);
                    EnvironmentStream.setStdout(System.out);
                    EnvironmentStream.setStderr(System.err);
                    try {
                        Vfs.initJNI();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    Properties props = System.getProperties();
                    ClassLoader envClassLoader = EnvironmentClassLoader.class.getClassLoader();
                    boolean isGlobalLoadable = false;
                    try {
                        Class<?> cl = Class.forName("com.caucho.naming.InitialContextFactoryImpl", false, systemLoader);
                        isGlobalLoadable = cl != null;
                    }
                    catch (Exception e) {
                        EnvironmentClassLoader.log().log(Level.FINER, e.toString(), e);
                    }
                    if (isGlobalLoadable) {
                        if (props.get("java.naming.factory.initial") == null) {
                            props.put("java.naming.factory.initial", "com.caucho.naming.InitialContextFactoryImpl");
                        }
                        props.put("java.naming.factory.url.pkgs", "com.caucho.naming");
                        EnvironmentProperties.enableEnvironmentSystemProperties(true);
                        String oldBuilder = props.getProperty("javax.management.builder.initial");
                        if (oldBuilder == null) {
                            oldBuilder = "com.caucho.jmx.MBeanServerBuilderImpl";
                            props.put("javax.management.builder.initial", oldBuilder);
                        }
                        if (MBeanServerFactory.findMBeanServer(null).size() == 0) {
                            MBeanServerFactory.createMBeanServer("Resin");
                        }
                        ManagementFactory.getPlatformMBeanServer();
                    }
                    TransactionManagerImpl tm = TransactionManagerImpl.getInstance();
                    UserTransactionProxy ut = UserTransactionProxy.getInstance();
                    Jndi.bindDeep("java:comp/env/jmx/MBeanServer", Jmx.getGlobalMBeanServer());
                    Jndi.bindDeep("java:comp/env/jmx/GlobalMBeanServer", Jmx.getGlobalMBeanServer());
                    Jndi.bindDeep("java:comp/UserTransaction", ut);
                    Jndi.bindDeep("java:comp/TransactionManager", tm);
                    Jndi.bindDeep("java:/TransactionManager", tm);
                    Jndi.bindDeep("java:comp/ThreadPool", ResinThreadPoolExecutor.getThreadPool());
                }
                catch (NamingException e) {
                    EnvironmentClassLoader.log().log(Level.FINE, e.toString(), e);
                    Object var9_13 = null;
                    thread.setContextClassLoader(oldLoader);
                    break block14;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Object var9_14 = null;
                    thread.setContextClassLoader(oldLoader);
                }
                Object var9_12 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
    }

    private static final Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(EnvironmentClassLoader.class.getName());
        }
        return _log;
    }

    static {
        _childListeners = new EnvironmentLocal();
        _addLoaderListeners = new EnvironmentLocal();
    }
}

