/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.ClassPackage;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.Loader;
import com.caucho.make.DependencyContainer;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ZipScanner;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JarListLoader
extends Loader
implements Dependency {
    private static final Logger log = Logger.getLogger(JarListLoader.class.getName());
    protected ArrayList<JarEntry> _jarList;
    private DependencyContainer _dependencyList = new DependencyContainer();
    private HashMap<String, ArrayList<JarEntry>> _pathMap;

    public JarListLoader() {
        this._jarList = new ArrayList();
        this._dependencyList = new DependencyContainer();
    }

    protected void init() {
    }

    @Override
    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        for (int i = 0; i < this._jarList.size(); ++i) {
            loader.addURL((Path)this._jarList.get(i).getJarPath());
        }
    }

    public boolean isModified() {
        return this._dependencyList.isModified();
    }

    public boolean logModified(Logger log) {
        return this._dependencyList.logModified(log);
    }

    @Override
    public void validate() throws ConfigException {
        for (int i = 0; i < this._jarList.size(); ++i) {
            this._jarList.get(i).validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addJar(Path jar) {
        JarPath jarPath = JarPath.create(jar);
        JarEntry jarEntry = new JarEntry(jarPath);
        this._jarList.add(jarEntry);
        this._dependencyList.add((Dependency)new Depend((Path)jarPath));
        if (this.getLoader() != null) {
            this.getLoader().addURL((Path)jarPath);
        }
        if (this._pathMap == null && DynamicClassLoader.isJarCacheEnabled()) {
            this._pathMap = new HashMap();
        }
        if (this._pathMap != null) {
            ZipScanner scan = null;
            try {
                HashMap<String, ArrayList<JarEntry>> pathMap = this._pathMap;
                boolean isScan = true;
                boolean isValidScan = false;
                try {
                    if (isScan && jar.canRead()) {
                        scan = new ZipScanner(jar);
                    }
                    if (scan != null && scan.open()) {
                        while (scan.next()) {
                            String name = scan.getName();
                            ArrayList<JarEntry> entryList = pathMap.get(name);
                            if (entryList == null) {
                                entryList = new ArrayList();
                                pathMap.put(name, entryList);
                                if (name.endsWith("/")) {
                                    String subName = name.substring(0, name.length() - 1);
                                    pathMap.put(subName, entryList);
                                }
                            }
                            entryList.add(jarEntry);
                        }
                        isValidScan = true;
                    }
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    isScan = false;
                }
                if (!isValidScan && jar.canRead()) {
                    ZipFile file = new ZipFile(jar.getNativePath());
                    Enumeration<? extends ZipEntry> e = file.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String name = entry.getName();
                        ArrayList<JarEntry> entryList = pathMap.get(name);
                        if (entryList == null) {
                            entryList = new ArrayList();
                            pathMap.put(name, entryList);
                        }
                        entryList.add(jarEntry);
                    }
                    file.close();
                }
            }
            catch (IOException e) {
                if (jar.canRead()) {
                    log.log(Level.WARNING, e.toString(), e);
                } else {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            finally {
                if (scan != null) {
                    scan.close();
                }
            }
        }
    }

    @Override
    protected void buildClassPath(ArrayList<String> pathList) {
        for (int i = 0; i < this._jarList.size(); ++i) {
            JarEntry jarEntry = this._jarList.get(i);
            JarPath jar = jarEntry.getJarPath();
            String path = jar.getContainer().getNativePath();
            if (pathList.contains(path)) continue;
            pathList.add(path);
        }
    }

    @Override
    protected ClassEntry getClassEntry(String name, String pathName) throws ClassNotFoundException {
        if (this._pathMap != null) {
            ArrayList<JarEntry> jarEntryList = this._pathMap.get(pathName);
            if (jarEntryList != null) {
                JarEntry jarEntry = jarEntryList.get(0);
                Path filePath = jarEntry.getJarPath().lookup(pathName);
                return this.createEntry(name, pathName, jarEntry, filePath);
            }
        } else {
            for (int i = 0; i < this._jarList.size(); ++i) {
                JarEntry jarEntry = this._jarList.get(i);
                JarPath path = jarEntry.getJarPath();
                Path filePath = path.lookup(pathName);
                if (!filePath.canRead() || filePath.getLength() <= 0L) continue;
                return this.createEntry(name, pathName, jarEntry, filePath);
            }
        }
        return null;
    }

    private ClassEntry createEntry(String name, String pathName, JarEntry jarEntry, Path filePath) {
        String pkg = "";
        int p = pathName.lastIndexOf(47);
        if (p > 0) {
            pkg = pathName.substring(0, p + 1);
        }
        ClassEntry entry = new ClassEntry(this.getLoader(), name, filePath, filePath, jarEntry.getCodeSource(pathName));
        ClassPackage classPackage = jarEntry.getPackage(pkg);
        entry.setClassPackage(classPackage);
        return entry;
    }

    @Override
    public void getResources(Vector<URL> vector, String name) {
        if (this._pathMap != null) {
            ArrayList<JarEntry> jarEntryList = this._pathMap.get(name);
            for (int i = 0; jarEntryList != null && i < jarEntryList.size(); ++i) {
                JarEntry jarEntry = jarEntryList.get(i);
                JarPath path = jarEntry.getJarPath();
                path = path.lookup(name);
                try {
                    URL url = new URL(path.getURL());
                    if (vector.contains(url)) continue;
                    vector.add(url);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        } else {
            for (int i = 0; i < this._jarList.size(); ++i) {
                JarEntry jarEntry = this._jarList.get(i);
                JarPath path = jarEntry.getJarPath();
                if (!(path = path.lookup(name)).exists()) continue;
                try {
                    URL url = new URL(path.getURL());
                    if (vector.contains(url)) continue;
                    vector.add(url);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    @Override
    public Path getPath(String pathName) {
        if (this._pathMap != null) {
            ArrayList<JarEntry> jarEntryList = this._pathMap.get(pathName);
            if (jarEntryList != null) {
                return jarEntryList.get(0).getJarPath().lookup(pathName);
            }
        } else {
            for (int i = 0; i < this._jarList.size(); ++i) {
                JarEntry jarEntry = this._jarList.get(i);
                JarPath path = jarEntry.getJarPath();
                Path filePath = path.lookup(pathName);
                if (!filePath.exists()) continue;
                return filePath;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearJars() {
        JarListLoader jarListLoader = this;
        synchronized (jarListLoader) {
            ArrayList<JarEntry> jars = new ArrayList<JarEntry>(this._jarList);
            this._jarList.clear();
            if (this._pathMap != null) {
                this._pathMap.clear();
            }
            for (int i = 0; i < jars.size(); ++i) {
                JarEntry jarEntry = jars.get(i);
                JarPath jarPath = jarEntry.getJarPath();
                jarPath.closeJar();
            }
        }
    }
}

