/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.ClassEntry;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.server.util.CauchoSystem;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Loader {
    protected static final Logger log = Log.open(Loader.class);
    private DynamicClassLoader _loader;

    public void setLoader(DynamicClassLoader loader) {
        this._loader = loader;
    }

    public DynamicClassLoader getLoader() {
        return this._loader;
    }

    public void validate() throws ConfigException {
    }

    protected ClassEntry getClassEntry(String name, String pathName) throws ClassNotFoundException {
        Path path = this.getPath(pathName);
        if (path != null && path.getLength() > 0L) {
            return new ClassEntry(this._loader, name, path, path, this.getCodeSource(path));
        }
        return null;
    }

    public URL getResource(String name) {
        Path path = this.getPath(name);
        if (path != null && path.exists()) {
            try {
                return new URL(path.getURL());
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return null;
    }

    public void getResources(Vector<URL> resources, String name) {
        Path path = this.getPath(name);
        if (path != null && path.canRead()) {
            try {
                resources.add(new URL(path.getURL()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public InputStream getResourceAsStream(String name) {
        Path path = this.getPath(name);
        if (path != null && path.canRead()) {
            try {
                return path.openRead();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Path getPath(String name) {
        return null;
    }

    protected CodeSource getCodeSource(Path path) {
        try {
            return new CodeSource(new URL(path.getURL()), path.getCertificates());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            return null;
        }
    }

    protected final void buildClassPath(StringBuilder head) {
        ArrayList<String> pathList = new ArrayList<String>();
        this.buildClassPath(pathList);
        for (int i = 0; i < pathList.size(); ++i) {
            if (head.length() > 0) {
                head.append(CauchoSystem.getPathSeparatorChar());
            }
            head.append(pathList.get(i));
        }
    }

    protected void buildClassPath(ArrayList<String> pathList) {
    }

    protected void buildSourcePath(StringBuilder head) {
        this.buildClassPath(head);
    }

    protected void buildSourcePath(ArrayList<String> pathList) {
        this.buildClassPath(pathList);
    }

    protected void destroy() {
    }
}

