/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.JarEntry;
import com.caucho.loader.JarListLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Dependency;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class TreeLoader
extends JarListLoader
implements Dependency {
    private static final L10N L = new L10N(TreeLoader.class);
    private static final Logger log = Logger.getLogger(TreeLoader.class.getName());
    private Path _dir;
    private long _lastModified;
    private String[] _fileNames;
    private HashSet<Path> _files = new HashSet();
    private HashSet<Path> _tempFiles = new HashSet();

    public TreeLoader() {
    }

    public TreeLoader(Path dir) {
        this._dir = dir;
        this.init();
    }

    public void setPath(Path path) {
        this._dir = path;
    }

    public Path getPath() {
        return this._dir;
    }

    public static DynamicClassLoader create(ClassLoader parent, Path dir) {
        DynamicClassLoader loader = new DynamicClassLoader(parent);
        TreeLoader treeLoader = new TreeLoader(dir);
        loader.addLoader(treeLoader);
        loader.init();
        return loader;
    }

    @PostConstruct
    public void init() {
        super.init();
        if (this._dir == null) {
            throw new ConfigException(L.l("<tree-loader> requires a 'path' attribute"));
        }
        this._lastModified = this._dir.getLastModified();
        try {
            this._fileNames = this._dir.list();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fillJars();
    }

    public boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this._dir.getNativePath() + " has modified jar files");
            return true;
        }
        return false;
    }

    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        for (int i = 0; i < this._jarList.size(); ++i) {
            loader.addURL((Path)((JarEntry)this._jarList.get(i)).getJarPath());
        }
    }

    private void fillJars() {
        this.clearJars();
        this.fillJars(this._dir);
    }

    private void fillJars(Path dir) {
        try {
            String[] list = dir.list();
            for (int j = 0; list != null && j < list.length; ++j) {
                Path path = dir.lookup(list[j]);
                if (list[j].endsWith(".jar") || list[j].endsWith(".zip")) {
                    this.addJar(path);
                    continue;
                }
                if (!path.isDirectory()) continue;
                this.fillJars(path);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Path getCodePath() {
        return this._dir;
    }

    protected void destroy() {
        this.clearJars();
    }

    public String toString() {
        return "TreeLoader[" + this._dir + "]";
    }
}

