/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.ByteCodeParser;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeEnhancer;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JavaClass;
import com.caucho.bytecode.JavaClassLoader;
import com.caucho.bytecode.JavaField;
import com.caucho.bytecode.JavaMethod;
import com.caucho.bytecode.MethodRefConstant;
import com.caucho.bytecode.Utf8Constant;
import com.caucho.java.WorkDir;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.enhancer.ClassEnhancer;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;

public class EnhancerFixup {
    private static final L10N L = new L10N(EnhancerFixup.class);
    private static final Logger log = Logger.getLogger(EnhancerFixup.class.getName());
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private JavaClassGenerator _javaGen = new JavaClassGenerator();
    private JavaClassLoader _jClassLoader;
    private DynamicClassLoader _loader;
    private Path _workPath;
    private String _baseSuffix = "";
    private String _extSuffix = "__ResinExt";
    private ArrayList<ClassEnhancer> _enhancerList = new ArrayList();
    private boolean _isParentStarted;

    public void setClassLoader(DynamicClassLoader loader) {
        this._loader = loader;
    }

    public void setJavaClassLoader(JavaClassLoader jClassLoader) {
        this._jClassLoader = jClassLoader;
    }

    public JavaClassLoader getJavaClassLoader() {
        return this._jClassLoader;
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return WorkDir.getLocalWorkDir();
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public final Path getPreWorkPath() {
        return this.getWorkPath().lookup("pre-enhance");
    }

    public final Path getPostWorkPath() {
        return this.getWorkPath().lookup("post-enhance");
    }

    public void addEnhancer(ClassEnhancer enhancer) {
        this._enhancerList.add(enhancer);
    }

    protected void fixup(String className, String extClassName) throws Exception {
        String classSuffix;
        Path targetDir;
        Path preTargetDir;
        Path prePath = this.getPreWorkPath();
        Path postPath = this.getPostWorkPath();
        Path source = this.getSource(className);
        if (source == null || !source.canRead()) {
            return;
        }
        Path ext = prePath.lookup(extClassName.replace('.', '/') + ".class");
        Path target = postPath.lookup(className.replace('.', '/') + ".class");
        try {
            target.getParent().mkdirs();
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (source != null) {
            this.mergeClasses(className, target, source, ext);
        } else {
            this.mergeClasses(className, target, ext);
        }
        int p = className.lastIndexOf(46);
        String prefix = "";
        if (p > 0) {
            prefix = className.substring(0, p).replace('.', '/');
            preTargetDir = prePath.lookup(prefix);
            targetDir = postPath.lookup(prefix);
            classSuffix = className.substring(p + 1);
        } else {
            preTargetDir = prePath;
            targetDir = postPath;
            classSuffix = className;
        }
        prefix = prefix.replace('/', '.');
        if (!prefix.equals("")) {
            prefix = prefix + ".";
        }
        String extSuffix = (p = extClassName.lastIndexOf(46)) > 0 ? extClassName.substring(p + 1) : extClassName;
        this.fixupPreSubClasses(preTargetDir, targetDir, extSuffix, classSuffix);
        this.fixupPostSubClasses(targetDir, prefix, classSuffix);
    }

    private void fixupPreSubClasses(Path preTargetDir, Path targetDir, String extSuffix, String classSuffix) throws Exception {
        String[] list = preTargetDir.list();
        for (int i = 0; i < list.length; ++i) {
            Path extPath;
            Path subTarget;
            String targetClass;
            int p;
            String name = list[i];
            if (name.startsWith(extSuffix + '$') && name.endsWith(".class")) {
                p = name.indexOf(36);
                targetClass = classSuffix + '$' + name.substring(p + 1, name.length() - 6);
                subTarget = targetDir.lookup(targetClass + ".class");
                extPath = preTargetDir.lookup(name);
                this.renameSubClass(classSuffix, subTarget, extPath);
                continue;
            }
            if (!name.startsWith(extSuffix + '-') || !name.endsWith(".class")) continue;
            p = name.indexOf(45);
            targetClass = classSuffix + '-' + name.substring(p + 1, name.length() - 6);
            subTarget = targetDir.lookup(targetClass + ".class");
            extPath = preTargetDir.lookup(name);
            this.renameSubClass(classSuffix, subTarget, extPath);
        }
    }

    private void fixupPostSubClasses(Path targetDir, String prefix, String classSuffix) throws Exception {
        String[] list = targetDir.list();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".class")) continue;
            String className = name.substring(0, name.length() - ".class".length());
            if (name.startsWith(classSuffix + '$')) {
                if (this._loader == null) continue;
                this._loader.addPathClass(prefix + className, targetDir.lookup(name));
                continue;
            }
            if (name.startsWith(classSuffix + '-')) {
                if (this._loader == null) continue;
                this._loader.addPathClass(prefix + className, targetDir.lookup(name));
                continue;
            }
            if (!name.startsWith(classSuffix + '+') || this._loader == null) continue;
            this._loader.addPathClass(prefix + className, targetDir.lookup(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void renameSubClass(String className, Path targetPath, Path extPath) throws Exception {
        JavaClass extClass;
        block4: {
            extClass = null;
            ByteCodeParser parser = new ByteCodeParser();
            parser = new ByteCodeParser();
            parser.setClassLoader(new JavaClassLoader());
            ReadStream is = extPath.openRead();
            try {
                extClass = parser.parse((InputStream)is);
                Object var8_7 = null;
                if (is == null) break block4;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
        }
        this.cleanExtConstantPool(className, extClass);
        WriteStream os = targetPath.openWrite();
        try {
            extClass.write(os);
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    protected void renameExtSuperMethods(String className, JavaClass baseClass, JavaClass extClass) throws Exception {
        ArrayList<ConstantPoolEntry> entries = extClass.getConstantPool().getEntries();
        className = className.replace('.', '/');
        String baseName = className + this._baseSuffix;
        String extName = className + "__ResinExt";
        for (int i = 0; i < entries.size(); ++i) {
            String type;
            String methodName;
            MethodRefConstant methodRef;
            ConstantPoolEntry entry = entries.get(i);
            if (!(entry instanceof MethodRefConstant) || !(methodRef = (MethodRefConstant)entry).getClassName().equals(baseName) || EnhancerFixup.findMethod(baseClass, methodName = methodRef.getName(), type = methodRef.getType()) == null || EnhancerFixup.findMethod(extClass, methodName, type) == null || !methodName.equals("<init>")) continue;
            methodName = "__init__super";
        }
    }

    private void moveSuperMethods(String className, JavaClass baseClass, JavaClass extClass) {
        className = className.replace('.', '/');
        ArrayList<JavaMethod> methods = baseClass.getMethodList();
        ArrayList<JavaMethod> extMethods = extClass.getMethodList();
        block0: for (int i = 0; i < extMethods.size(); ++i) {
            JavaMethod extMethod = extMethods.get(i);
            this.fixupExtMethod(baseClass, extClass, extMethod);
            String baseName = extMethod.getName();
            if (baseName.endsWith("__super")) continue;
            String superName = baseName + "__super";
            for (int j = 0; j < methods.size(); ++j) {
                JavaMethod method = methods.get(j);
                String type = method.getDescriptor();
                if (!method.getName().equals(baseName) || !method.getDescriptor().equals(extMethod.getDescriptor())) continue;
                if (baseName.equals("<init>")) {
                    baseClass.getConstantPool().addUTF8("__init__super");
                    this.mergeInitMethods(baseClass, method, extClass, extMethod);
                    continue block0;
                }
                if (baseName.equals("<clinit>")) {
                    this.concatenateMethods(baseClass, method, extClass, extMethod);
                    continue block0;
                }
                baseClass.getConstantPool().addUTF8(superName);
                method.setName(superName);
                baseClass.getConstantPool().addUTF8(type);
                method.setDescriptor(type);
                int flags = method.getAccessFlags();
                flags = flags & 0xFFFFFFFE & 0xFFFFFFFB | 2;
                method.setAccessFlags(flags);
                continue block0;
            }
        }
    }

    private void concatenateMethods(JavaClass baseClass, JavaMethod baseMethod, JavaClass extClass, JavaMethod extMethod) {
        extMethod = extMethod.export(extClass, baseClass);
        baseMethod.concatenate(extMethod);
    }

    private void mergeInitMethods(JavaClass baseClass, JavaMethod baseMethod, JavaClass extClass, JavaMethod extMethod) {
        extMethod = extMethod.export(extClass, baseClass);
        baseMethod.setName("__init__super");
        baseClass.getMethodList().add(extMethod);
        try {
            InitAnalyzer initAnalyzer = new InitAnalyzer();
            CodeEnhancer baseEnhancer = new CodeEnhancer(baseClass, baseMethod.getCode());
            baseEnhancer.analyze(initAnalyzer);
            int offset = initAnalyzer.getOffset();
            byte[] code = new byte[offset];
            byte[] oldCode = baseEnhancer.getCode();
            System.arraycopy(oldCode, 0, code, 0, offset);
            baseEnhancer.remove(0, offset);
            baseEnhancer.update();
            CodeEnhancer extEnhancer = new CodeEnhancer(baseClass, extMethod.getCode());
            extEnhancer.add(0, code, 0, code.length);
            ExtMethodAnalyzer extMethodAnalyzer = new ExtMethodAnalyzer(baseClass, extMethod, offset);
            extEnhancer.analyze(extMethodAnalyzer);
            extEnhancer.update();
            CodeAttribute baseCode = baseMethod.getCode();
            CodeAttribute extCode = extMethod.getCode();
            if (extCode.getMaxStack() < baseCode.getMaxStack()) {
                extCode.setMaxStack(baseCode.getMaxStack());
            }
            extCode.removeAttribute("LocalVariableTable");
            extCode.removeAttribute("LineNumberTable");
            baseCode.removeAttribute("LocalVariableTable");
            baseCode.removeAttribute("LineNumberTable");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void fixupExtMethod(JavaClass baseClass, JavaClass extClass, JavaMethod extMethod) {
        try {
            if (extMethod.getName().endsWith("__super")) {
                return;
            }
            CodeEnhancer extEnhancer = new CodeEnhancer(extClass, extMethod.getCode());
            ExtMethodAnalyzer extMethodAnalyzer = new ExtMethodAnalyzer(baseClass, extMethod, 0);
            extEnhancer.analyze(extMethodAnalyzer);
            extEnhancer.update();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addExtInterfaces(JavaClass baseClass, JavaClass extClass) {
        for (String name : extClass.getInterfaceNames()) {
            baseClass.getConstantPool().addClass(name);
            baseClass.addInterface(name);
        }
    }

    private void addExtMethods(JavaClass baseClass, JavaClass extClass) {
        ArrayList<JavaMethod> methods = baseClass.getMethodList();
        ArrayList<JavaMethod> extMethods = extClass.getMethodList();
        for (int i = 0; i < extMethods.size(); ++i) {
            JavaMethod extMethod = extMethods.get(i);
            if (extMethod.getName().equals("<clinit>") && EnhancerFixup.findMethod(baseClass, "<clinit>", extMethod.getDescriptor()) != null || extMethod.getName().equals("<init>") || extMethod.getName().endsWith("__super")) continue;
            log.finest("adding extension method: " + extClass.getThisClass() + ":" + extMethod.getName());
            JavaMethod method = extMethod.export(extClass, baseClass);
            methods.add(method);
        }
    }

    private void addExtClasses(JavaClass baseClass, JavaClass extClass) {
    }

    private static JavaMethod findMethod(JavaClass cl, String name, String descriptor) {
        ArrayList<JavaMethod> methods = cl.getMethodList();
        for (int j = 0; j < methods.size(); ++j) {
            JavaMethod method = methods.get(j);
            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    private void moveSuperFields(JavaClass baseClass, JavaClass extClass) {
        ArrayList<JavaField> fields = baseClass.getFieldList();
        ArrayList<JavaField> extFields = extClass.getFieldList();
        for (int i = 0; i < extFields.size(); ++i) {
        }
    }

    private Path getSource(String className) {
        URL url;
        String s;
        int index;
        ClassLoader loader = this._loader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if ((index = (s = (url = ((ClassLoader)loader).getResource(className.replace('.', '/') + ".class")).toString()).indexOf("jar!/")) > 0) {
            s = s.substring(9, index + 3);
            JarPath path = JarPath.create(Vfs.lookup(s));
            path = path.lookup(className.replace('.', '/') + ".class");
            return path;
        }
        return Vfs.lookup(url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeClasses(String className, Path targetPath, Path sourcePath, Path extPath) throws Exception {
        JavaClass extClass;
        JavaClass baseClass;
        block7: {
            ReadStream is;
            ByteCodeParser parser;
            block6: {
                baseClass = null;
                extClass = null;
                parser = new ByteCodeParser();
                parser.setClassLoader(this.getJavaClassLoader());
                is = sourcePath.openRead();
                try {
                    baseClass = parser.parse((InputStream)is);
                    Object var10_9 = null;
                    if (is == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
            parser = new ByteCodeParser();
            parser.setClassLoader(this.getJavaClassLoader());
            is = extPath.openRead();
            try {
                extClass = parser.parse((InputStream)is);
                Object var12_13 = null;
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
        }
        this.fixupLocalVariableTable(extClass);
        this.fixupLocalVariableTable(baseClass);
        this.mergeClasses(className, baseClass, extClass);
        this.postEnhance(baseClass);
        WriteStream os = targetPath.openWrite();
        try {
            baseClass.write(os);
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeClasses(String className, Path targetPath, Path extPath) throws Exception {
        JavaClass extClass;
        JavaClass baseClass;
        block4: {
            baseClass = null;
            extClass = null;
            ByteCodeParser parser = new ByteCodeParser();
            parser.setClassLoader(this.getJavaClassLoader());
            ReadStream is = extPath.openRead();
            try {
                extClass = parser.parse((InputStream)is);
                Object var9_8 = null;
                if (is == null) break block4;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
        }
        this.cleanExtConstantPool(className, extClass);
        this.postEnhance(baseClass);
        WriteStream os = targetPath.openWrite();
        try {
            extClass.write(os);
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            os.close();
            throw throwable;
        }
        os.close();
    }

    protected void postEnhance(JavaClass baseClass) throws Exception {
        for (int i = 0; i < this._enhancerList.size(); ++i) {
            this._enhancerList.get(i).postEnhance(baseClass);
        }
        this.fixupJdk16Methods(baseClass);
    }

    protected void mergeClasses(String className, JavaClass baseClass, JavaClass extClass) throws Exception {
        if (baseClass.getMajor() < extClass.getMajor()) {
            baseClass.setMajor(extClass.getMajor());
            baseClass.setMinor(extClass.getMinor());
        }
        this.cleanExtConstantPool(className, extClass);
        this.renameExtSuperMethods(className, baseClass, extClass);
        this.cleanExtConstantPool(className, baseClass);
        this.addExtInterfaces(baseClass, extClass);
        this.addExtFields(baseClass, extClass);
        this.moveSuperMethods(className, baseClass, extClass);
        this.addExtMethods(baseClass, extClass);
        this.copyExtAnnotations(baseClass);
        this.addExtClasses(baseClass, extClass);
    }

    protected void cleanExtConstantPool(String className, JavaClass extClass) throws Exception {
        extClass.setThisClass(this.replaceString(className, extClass.getThisClass()));
        extClass.setSuperClass(this.replaceString(className, extClass.getSuperClassName()));
        ArrayList<ConstantPoolEntry> entries = extClass.getConstantPool().getEntries();
        int t = className.lastIndexOf(46);
        if (t > 0) {
            className = className.substring(t + 1);
        }
        String baseName = className + this._baseSuffix;
        String extName = className + "__ResinExt";
        for (int i = 0; i < entries.size(); ++i) {
            ConstantPoolEntry entry = entries.get(i);
            if (!(entry instanceof Utf8Constant)) continue;
            Utf8Constant utf8 = (Utf8Constant)entry;
            String string = utf8.getValue();
            string = this.replaceString(className, string);
            utf8.setValue(string);
        }
        ArrayList<JavaField> fields = extClass.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            JavaField field = fields.get(i);
            field.setName(this.replaceString(className, field.getName()));
            field.setDescriptor(this.replaceString(className, field.getDescriptor()));
        }
        ArrayList<JavaMethod> methods = extClass.getMethodList();
        for (int i = 0; i < methods.size(); ++i) {
            JavaMethod method = methods.get(i);
            method.setName(this.replaceString(className, method.getName()));
            method.setDescriptor(this.replaceString(className, method.getDescriptor()));
        }
    }

    private void copyExtAnnotations(JavaClass baseClass) {
        for (JavaMethod method : baseClass.getMethodList()) {
            Attribute ann;
            if (!method.getName().endsWith("__super") || (ann = method.getAttribute("RuntimeVisibleAnnotations")) == null) continue;
            String name = method.getName();
            JavaMethod baseMethod = EnhancerFixup.findMethod(baseClass, name = name.substring(0, name.length() - "__super".length()), method.getDescriptor());
            if (baseMethod == null) continue;
            baseMethod.addAttribute(ann);
        }
    }

    private void addExtFields(JavaClass baseClass, JavaClass extClass) {
        ArrayList<JavaField> fields = baseClass.getFieldList();
        for (JavaField extField : extClass.getFieldList()) {
            JavaField field = extField.export(extClass, baseClass);
            if (fields.contains(field)) continue;
            fields.add(field);
        }
    }

    private void fixupJdk16Methods(JavaClass baseClass) {
        for (JavaMethod method : baseClass.getMethodList()) {
            CodeAttribute code = method.getCode();
            code.removeAttribute("StackMapTable");
        }
    }

    private void fixupLocalVariableTable(JavaClass extClass) {
        for (JavaMethod method : extClass.getMethodList()) {
            CodeAttribute code = method.getCode();
            code.removeAttribute("LocalVariableTable");
            code.removeAttribute("LocalVariableTypeTable");
        }
    }

    private String replaceString(String className, String string) {
        string = this.replaceStringInt(className.replace('.', '/'), string);
        string = this.replaceStringInt(className.replace('.', '$'), string);
        string = this.replaceStringInt(className.replace('.', '-'), string);
        return string;
    }

    private String replaceStringInt(String className, String string) {
        String suffix;
        String prefix;
        int p;
        int t = className.lastIndexOf(46);
        if (t > 0) {
            className = className.substring(t + 1);
        }
        String baseName = className + this._baseSuffix;
        String extName = "__ResinExt";
        if (!baseName.equals(className)) {
            while ((p = string.indexOf(baseName)) >= 0) {
                prefix = string.substring(0, p);
                suffix = string.substring(p + baseName.length());
                string = prefix + className + suffix;
            }
        }
        while ((p = string.indexOf(extName)) >= 0) {
            prefix = string.substring(0, p);
            suffix = string.substring(p + extName.length());
            string = prefix + suffix;
        }
        return string;
    }

    private static class ExtMethodAnalyzer
    extends Analyzer {
        JClass _baseClass;
        JMethod _method;
        int _startOffset;
        boolean _isEnhanced;

        ExtMethodAnalyzer(JClass baseClass, JMethod method, int length) {
            this._baseClass = baseClass;
            this._method = method;
            this._startOffset = length;
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (this._isEnhanced) {
                return;
            }
            if (visitor.getOffset() < this._startOffset) {
                return;
            }
            switch (visitor.getOpcode()) {
                case 183: {
                    JavaMethod method;
                    int index = visitor.getShortArg();
                    JavaClass jClass = visitor.getJavaClass();
                    ConstantPool cp = jClass.getConstantPool();
                    MethodRefConstant ref = cp.getMethodRef(index);
                    if (ref.getName().endsWith("__super")) {
                        return;
                    }
                    if (!(!ref.getName().equals("<init>") || ref.getClassName().equals(jClass.getSuperClassName()) && this._method.getName().equals("<init>"))) {
                        return;
                    }
                    if (!ref.getName().equals("<init>") && (method = EnhancerFixup.findMethod(jClass, ref.getName(), ref.getType())) != null && ((JMethod)method).isPrivate()) {
                        return;
                    }
                    String superName = ref.getName().equals("<init>") ? "__init__super" : ref.getName() + "__super";
                    MethodRefConstant newRef = cp.addMethodRef(ref.getClassName(), superName, ref.getType());
                    visitor.setShortArg(1, newRef.getIndex());
                    this._isEnhanced = true;
                }
            }
        }
    }

    private static class InitAnalyzer
    extends Analyzer {
        int _offset = -1;

        private InitAnalyzer() {
        }

        public int getOffset() {
            return this._offset;
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (this._offset >= 0) {
                return;
            }
            switch (visitor.getOpcode()) {
                case 183: {
                    JavaClass javaClass = visitor.getJavaClass();
                    ConstantPool cp = javaClass.getConstantPool();
                    MethodRefConstant ref = cp.getMethodRef(visitor.getShortArg());
                    if (!ref.getName().equals("<init>") || !ref.getClassName().equals(javaClass.getThisClass()) && !ref.getClassName().equals(javaClass.getSuperClassName())) break;
                    this._offset = visitor.getOffset() + 3;
                }
            }
        }
    }
}

