/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.java.WorkDir;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.enhancer.EnhancerManager;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;

public class EnhancingClassLoader
extends EnvironmentClassLoader {
    private static final L10N L = new L10N(EnhancingClassLoader.class);
    private Path _workPath;

    public EnhancingClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public EnhancingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Path getWorkPath() {
        if (this._workPath != null) {
            return this._workPath;
        }
        return WorkDir.getLocalWorkDir(this);
    }

    public void setWorkPath(Path workPath) {
        this._workPath = workPath;
    }

    public final Path getPreWorkPath() {
        return this.getWorkPath().lookup("pre-enhance");
    }

    public final Path getPostWorkPath() {
        return this.getWorkPath().lookup("post-enhance");
    }

    public void init() {
        super.init();
        if (this.getTransformerList() == null && EnhancerManager.getLocalEnhancer(this) != null) {
            EnhancerManager.create(this);
        }
    }

    public String toString() {
        if (this.getId() != null) {
            return "EnhancingClassLoader[" + this.getId() + "]";
        }
        return "EnhancingClassLoader" + this.getLoaders();
    }
}

