/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader.enhancer;

import com.caucho.bytecode.ByteCodeClassMatcher;
import com.caucho.bytecode.ByteCodeClassScanner;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanManager {
    private static final Logger log = Logger.getLogger(ScanManager.class.getName());
    private final ScanListener[] _listeners;

    public ScanManager(ArrayList<ScanListener> listeners) {
        this._listeners = new ScanListener[listeners.size()];
        listeners.toArray(this._listeners);
    }

    public void scan(EnvironmentClassLoader loader, URL url) {
        this.scan(loader, Vfs.lookup(url.toString()));
    }

    public void scan(EnvironmentClassLoader loader, Path root) {
        ScanListener[] listeners = new ScanListener[this._listeners.length];
        boolean hasListener = false;
        for (int i = 0; i < this._listeners.length; ++i) {
            if (!this._listeners[i].isRootScannable(root)) continue;
            listeners[i] = this._listeners[i];
            hasListener = true;
        }
        if (!hasListener) {
            return;
        }
        if (root instanceof JarPath) {
            JarByteCodeMatcher matcher = new JarByteCodeMatcher(loader, root, listeners);
            this.scanForJarClasses(((JarPath)root).getContainer(), matcher);
        } else {
            PathByteCodeMatcher matcher = new PathByteCodeMatcher(loader, root, listeners);
            this.scanForClasses(root, root, matcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanForClasses(Path root, Path path, PathByteCodeMatcher matcher) {
        try {
            if (path.isDirectory()) {
                for (String name : path.list()) {
                    this.scanForClasses(root, path.lookup(name), matcher);
                }
                return;
            }
            if (!path.getPath().endsWith(".class")) {
                return;
            }
            matcher.init(root, path);
            ReadStream is = path.openRead();
            try {
                ByteCodeClassScanner classScanner = new ByteCodeClassScanner(path.getPath(), (InputStream)is, matcher);
                classScanner.scan();
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                is.close();
                throw throwable;
            }
            is.close();
            {
            }
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void scanForJarClasses(Path path, JarByteCodeMatcher matcher) {
        block14: {
            ZipFile zipFile = null;
            zipFile = new ZipFile(path.getNativePath());
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                Object var10_10;
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class")) continue;
                matcher.init(entryName);
                ReadStream is = Vfs.openRead(zipFile.getInputStream(entry));
                try {
                    ByteCodeClassScanner classScanner = new ByteCodeClassScanner(path.getPath(), (InputStream)is, matcher);
                    classScanner.scan();
                    var10_10 = null;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                {
                }
            }
            Object var12_12 = null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block14;
            }
            catch (Exception e2) {}
            break block14;
            {
                catch (IOException e3) {
                    log.log(Level.FINE, e3.toString(), e3);
                    Object var12_13 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block14;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static abstract class ScanByteCodeMatcher
    implements ByteCodeClassMatcher {
        private final EnvironmentClassLoader _loader;
        private final Path _root;
        private final ScanListener[] _listeners;
        private final ScanListener[] _currentListeners;

        ScanByteCodeMatcher(EnvironmentClassLoader loader, Path root, ScanListener[] listeners) {
            this._loader = loader;
            this._root = root;
            this._listeners = listeners;
            this._currentListeners = new ScanListener[listeners.length];
        }

        void init() {
            for (int i = 0; i < this._listeners.length; ++i) {
                this._currentListeners[i] = this._listeners[i];
            }
        }

        public boolean isMatch(CharBuffer annotationClassName) {
            int activeCount = 0;
            for (int i = this._listeners.length - 1; i >= 0; --i) {
                ScanListener listener = this._currentListeners[i];
                if (listener == null) continue;
                if (listener.isScanMatch(annotationClassName)) {
                    listener.classMatchEvent(this._loader, this._root, this.getClassName());
                    this._currentListeners[i] = null;
                    continue;
                }
                ++activeCount;
            }
            return activeCount == 0;
        }

        abstract String getClassName();
    }

    static class PathByteCodeMatcher
    extends ScanByteCodeMatcher {
        private Path _root;
        private Path _path;

        PathByteCodeMatcher(EnvironmentClassLoader loader, Path root, ScanListener[] listeners) {
            super(loader, root, listeners);
        }

        void init(Path root, Path path) {
            super.init();
            this._root = root;
            this._path = path;
        }

        String getClassName() {
            String rootName = this._root.getFullPath();
            String name = this._path.getFullPath();
            int p = name.lastIndexOf(46);
            String className = name.substring(rootName.length(), p);
            return className.replace('/', '.');
        }
    }

    static class JarByteCodeMatcher
    extends ScanByteCodeMatcher {
        private String _entryName;

        JarByteCodeMatcher(EnvironmentClassLoader loader, Path root, ScanListener[] listeners) {
            super(loader, root, listeners);
        }

        void init(String entryName) {
            super.init();
            this._entryName = entryName;
        }

        String getClassName() {
            int p = this._entryName.lastIndexOf(46);
            String className = this._entryName.substring(0, p);
            return className.replace('/', '.');
        }
    }
}

