/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.log.EnvironmentStream;
import com.caucho.util.Alarm;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.ThreadPool;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;

public class AbstractRolloverLog {
    protected static final L10N L = new L10N(AbstractRolloverLog.class);
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long DEFAULT_ROLLOVER_SIZE = 0x3FFFFFFFFFFFFFFFL;
    private static final long DEFAULT_ROLLOVER_CHECK_PERIOD = 600000L;
    private static final long ROLLOVER_OVERFLOW_MAX = 0x4000000L;
    private String _rolloverPrefix;
    private String _archiveFormat;
    private String _archiveSuffix = "";
    private long _rolloverPeriod = 4611686018427387000L;
    private long _rolloverSize = 0x3FFFFFFFFFFFFFFFL;
    private long _rolloverCheckPeriod = 120000L;
    private int _rolloverCount;
    private QDate _calendar = QDate.createLocal();
    private Path _pwd = Vfs.lookup();
    protected Path _path;
    protected String _pathFormat;
    private String _format;
    private long _nextPeriodEnd = -1L;
    private long _nextRolloverCheckTime = -1L;
    private long _lastTime;
    private boolean _isRollingOver;
    private Path _savedPath;
    private TempStream _tempStream;
    private long _tempStreamSize;
    private ArchiveTask _archiveTask = new ArchiveTask();
    private WriteStream _os;
    private WriteStream _zipOut;

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPwd() {
        return this._pwd;
    }

    public String getPathFormat() {
        return this._pathFormat;
    }

    public void setPathFormat(String pathFormat) throws ConfigException {
        this._pathFormat = pathFormat;
        if (pathFormat.endsWith(".zip")) {
            throw new ConfigException(L.l(".zip extension to path-format is not supported."));
        }
    }

    public void setArchiveFormat(String format) {
        if (format.endsWith(".gz")) {
            this._archiveFormat = format.substring(0, format.length() - ".gz".length());
            this._archiveSuffix = ".gz";
        } else if (format.endsWith(".zip")) {
            this._archiveFormat = format.substring(0, format.length() - ".zip".length());
            this._archiveSuffix = ".zip";
        } else {
            this._archiveFormat = format;
            this._archiveSuffix = "";
        }
    }

    public String getArchiveFormat() {
        if (this._archiveFormat == null) {
            return this._rolloverPrefix + ".%Y%m%d.%H%M";
        }
        return this._archiveFormat;
    }

    public void setRolloverPeriod(Period period) {
        this._rolloverPeriod = period.getPeriod();
        if (this._rolloverPeriod > 0L) {
            this._rolloverPeriod += 3599999L;
            this._rolloverPeriod -= this._rolloverPeriod % 3600000L;
        } else {
            this._rolloverPeriod = 4611686018427387000L;
        }
    }

    public long getRolloverPeriod() {
        return this._rolloverPeriod;
    }

    public void setRolloverSize(Bytes bytes) {
        long size = bytes.getBytes();
        this._rolloverSize = size < 0L ? 0x3FFFFFFFFFFFFFFFL : size;
    }

    public long getRolloverSize() {
        return this._rolloverSize;
    }

    public void setRolloverCheckPeriod(long period) {
        if (period > 1000L) {
            this._rolloverCheckPeriod = period;
        } else if (period > 0L) {
            this._rolloverCheckPeriod = 1000L;
        }
    }

    public long getRolloverCheckPeriod() {
        return this._rolloverCheckPeriod;
    }

    public void setRolloverCount(int count) {
        this._rolloverCount = count;
    }

    public void setLastTime(long lastTime) {
        this._lastTime = lastTime;
    }

    public void init() throws IOException {
        long now = Alarm.getCurrentTime();
        this._nextRolloverCheckTime = now + this._rolloverCheckPeriod;
        Path path = this.getPath();
        if (path != null) {
            path.getParent().mkdirs();
            this._rolloverPrefix = path.getTail();
            long lastModified = path.getLastModified();
            if (lastModified <= 0L) {
                lastModified = now;
            }
            this._calendar.setGMTTime(lastModified);
            this._nextPeriodEnd = Period.periodEnd(lastModified, this.getRolloverPeriod());
        } else {
            this._nextPeriodEnd = Period.periodEnd(now, this.getRolloverPeriod());
        }
        if (this._nextPeriodEnd < this._nextRolloverCheckTime && this._nextPeriodEnd > 0L) {
            this._nextRolloverCheckTime = this._nextPeriodEnd;
        }
        if (this._archiveFormat == null && this.getRolloverPeriod() > 0L) {
            this._archiveFormat = this.getRolloverPeriod() % 86400000L == 0L ? this._rolloverPrefix + ".%Y%m%d" : (this.getRolloverPeriod() % 3600000L == 0L ? this._rolloverPrefix + ".%Y%m%d.%H" : this._rolloverPrefix + ".%Y%m%d.%H%M");
        }
        this.rolloverLog(now);
    }

    public long getNextRolloverCheckTime() {
        if (this._nextPeriodEnd < this._nextRolloverCheckTime) {
            return this._nextPeriodEnd;
        }
        return this._nextRolloverCheckTime;
    }

    public boolean isRollover() {
        long now = Alarm.getCurrentTime();
        return this._nextPeriodEnd <= now || this._nextRolloverCheckTime <= now;
    }

    public boolean rollover() {
        long now = Alarm.getCurrentTime();
        if (this._nextPeriodEnd <= now || this._nextRolloverCheckTime <= now) {
            this.rolloverLog(now);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] buffer, int offset, int length) throws IOException {
        AbstractRolloverLog abstractRolloverLog = this;
        synchronized (abstractRolloverLog) {
            if (this._isRollingOver && 0x4000000L < this._tempStreamSize) {
                try {
                    this.wait();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!this._isRollingOver) {
                if (this._os == null) {
                    this.openLog();
                }
                if (this._os != null) {
                    this._os.write(buffer, offset, length);
                }
            } else {
                if (this._tempStream == null) {
                    this._tempStream = new TempStream();
                    this._tempStreamSize = 0L;
                }
                this._tempStreamSize += (long)length;
                this._tempStream.write(buffer, offset, length, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() throws IOException {
        AbstractRolloverLog abstractRolloverLog = this;
        synchronized (abstractRolloverLog) {
            if (this._os != null) {
                this._os.flush();
            }
            if (this._zipOut != null) {
                this._zipOut.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void rolloverLog(long now) {
        boolean isRollingOver = false;
        try {
            Path savedPath = null;
            AbstractRolloverLog abstractRolloverLog = this;
            // MONITORENTER : abstractRolloverLog
            if (this._isRollingOver || now <= this._nextRolloverCheckTime) {
                // MONITOREXIT : abstractRolloverLog
                Object var13_5 = null;
                AbstractRolloverLog abstractRolloverLog2 = this;
                // MONITORENTER : abstractRolloverLog2
                if (isRollingOver) {
                    this._isRollingOver = false;
                    this.flushTempStream();
                }
                // MONITOREXIT : abstractRolloverLog2
                return;
            }
            isRollingOver = true;
            this._isRollingOver = true;
            this._nextRolloverCheckTime = now + this._rolloverCheckPeriod;
            long lastPeriodEnd = this._nextPeriodEnd;
            this._nextPeriodEnd = Period.periodEnd(now, this.getRolloverPeriod());
            Path path = this.getPath();
            if (lastPeriodEnd < now) {
                this.closeLogStream();
                if (this.getPathFormat() == null) {
                    savedPath = this.getArchivePath(lastPeriodEnd - 1L);
                }
            } else if (path != null && this.getRolloverSize() <= path.getLength()) {
                this.closeLogStream();
                if (this.getPathFormat() == null) {
                    savedPath = this.getArchivePath(now);
                }
            }
            long nextPeriodEnd = this._nextPeriodEnd;
            if (this._nextPeriodEnd < this._nextRolloverCheckTime && this._nextPeriodEnd > 0L) {
                this._nextRolloverCheckTime = this._nextPeriodEnd;
            }
            // MONITOREXIT : abstractRolloverLog
            if (savedPath != null) {
                this._savedPath = savedPath;
                isRollingOver = false;
                ThreadPool.getThreadPool().startPriority((Runnable)this._archiveTask);
                Thread.yield();
            }
            Object var13_6 = null;
            AbstractRolloverLog abstractRolloverLog3 = this;
            // MONITORENTER : abstractRolloverLog3
            if (isRollingOver) {
                this._isRollingOver = false;
                this.flushTempStream();
            }
            // MONITOREXIT : abstractRolloverLog3
            return;
        }
        catch (Throwable throwable) {
            Object var13_7 = null;
            AbstractRolloverLog abstractRolloverLog = this;
            // MONITORENTER : abstractRolloverLog
            if (isRollingOver) {
                this._isRollingOver = false;
                this.flushTempStream();
            }
            // MONITOREXIT : abstractRolloverLog
            throw throwable;
        }
    }

    private void openLog() {
        Exception exn;
        Path path;
        block16: {
            this.closeLogStream();
            try {
                WriteStream os = this._os;
                this._os = null;
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            path = this.getPath();
            if (path == null) {
                path = this.getPath(Alarm.getCurrentTime());
            }
            try {
                if (!path.getParent().isDirectory()) {
                    path.getParent().mkdirs();
                }
            }
            catch (Throwable e) {
                this.logWarning(L.l("Can't create log directory {0}", (Object)path.getParent()), e);
            }
            exn = null;
            for (int i = 0; i < 3 && this._os == null; ++i) {
                try {
                    this._os = path.openAppend();
                    continue;
                }
                catch (IOException e) {
                    exn = e;
                }
            }
            String pathName = path.getPath();
            try {
                if (pathName.endsWith(".gz")) {
                    this._zipOut = this._os;
                    this._os = Vfs.openWrite(new GZIPOutputStream((OutputStream)this._zipOut));
                } else if (pathName.endsWith(".zip")) {
                    throw new ConfigException("Can't support .zip in path-format");
                }
            }
            catch (Exception e) {
                if (exn != null) break block16;
                exn = e;
            }
        }
        if (exn != null) {
            this.logWarning(L.l("Can't create log directory {0}", (Object)path), exn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePathToArchive(Path savedPath) {
        Path path;
        block22: {
            if (savedPath == null) {
                return;
            }
            this.closeLogStream();
            path = this.getPath();
            String savedName = savedPath.getTail();
            try {
                if (!savedPath.getParent().isDirectory()) {
                    savedPath.getParent().mkdirs();
                }
            }
            catch (Throwable e) {
                this.logWarning(L.l("Can't open archive directory {0}", (Object)savedPath.getParent()), e);
            }
            try {
                if (!path.exists()) break block22;
                WriteStream os = savedPath.openWrite();
                DeflaterOutputStream out = savedName.endsWith(".gz") ? new GZIPOutputStream((OutputStream)os) : (savedName.endsWith(".zip") ? new ZipOutputStream((OutputStream)os) : os);
                try {
                    path.writeToStream((OutputStream)out);
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        if (out != os) {
                            os.close();
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    ((OutputStream)out).close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    if (out != os) {
                        os.close();
                    }
                }
                catch (Throwable e) {}
            }
            catch (Throwable e) {
                this.logWarning(L.l("Error rotating logs"), e);
            }
        }
        try {
            try {
                if (!path.truncate()) {
                    path.remove();
                }
            }
            catch (IOException e) {
                path.remove();
                throw e;
            }
        }
        catch (Exception e) {
            this.logWarning(L.l("Error truncating logs"), e);
        }
        if (this._rolloverCount > 0) {
            this.removeOldLogs();
        }
    }

    private void removeOldLogs() {
        try {
            int i;
            Path path = this.getPath();
            Path parent = path.getParent();
            String[] list = parent.list();
            ArrayList<String> matchList = new ArrayList<String>();
            Pattern archiveRegexp = this.getArchiveRegexp();
            for (i = 0; i < list.length; ++i) {
                Matcher matcher = archiveRegexp.matcher(list[i]);
                if (!matcher.matches()) continue;
                matchList.add(list[i]);
            }
            Collections.sort(matchList);
            if (this._rolloverCount <= 0 || matchList.size() < this._rolloverCount) {
                return;
            }
            i = 0;
            while (i + this._rolloverCount < matchList.size()) {
                try {
                    parent.lookup((String)matchList.get(i)).remove();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Pattern getArchiveRegexp() {
        StringBuilder sb = new StringBuilder();
        String archiveFormat = this.getArchiveFormat();
        block4: for (int i = 0; i < archiveFormat.length(); ++i) {
            char ch = archiveFormat.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append("\\");
                    sb.append(ch);
                    continue block4;
                }
                case '%': {
                    sb.append(".+");
                    ++i;
                    continue block4;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return Pattern.compile(sb.toString());
    }

    protected Path getPath(long time) {
        String formatString = this.getPathFormat();
        if (formatString == null) {
            throw new IllegalStateException(L.l("getPath requires a format path"));
        }
        String pathString = this.getFormatName(formatString, time);
        return this.getPwd().lookup(pathString);
    }

    protected Path getArchivePath(long time) {
        Path path = this.getPath();
        String archiveFormat = this.getArchiveFormat();
        String name = this.getFormatName(archiveFormat + this._archiveSuffix, time);
        Path newPath = path.getParent().lookup(name);
        if (newPath.exists()) {
            if (archiveFormat.indexOf("%H") < 0) {
                archiveFormat = archiveFormat + ".%H%M";
            } else if (archiveFormat.indexOf("%M") < 0) {
                archiveFormat = archiveFormat + ".%M";
            }
            for (int i = 0; i < 100; ++i) {
                String suffix = i == 0 ? this._archiveSuffix : "." + i + this._archiveSuffix;
                name = this.getFormatName(archiveFormat + suffix, time);
                newPath = path.getParent().lookup(name);
                if (!newPath.exists()) break;
            }
        }
        return newPath;
    }

    protected String getFormatName(String format, long time) {
        if (time <= 0L) {
            time = Alarm.getCurrentTime();
        }
        if (format != null) {
            return QDate.formatLocal((long)time, (String)format);
        }
        if (this.getRolloverPeriod() % 86400000L == 0L) {
            return this._rolloverPrefix + "." + QDate.formatLocal((long)time, (String)"%Y%m%d");
        }
        return this._rolloverPrefix + "." + QDate.formatLocal((long)time, (String)"%Y%m%d.%H");
    }

    private void logInfo(String msg) {
        EnvironmentStream.logStderr(msg);
    }

    private void logWarning(String msg, Throwable e) {
        EnvironmentStream.logStderr(msg, e);
    }

    public synchronized void close() throws IOException {
        this.closeLogStream();
    }

    private void closeLogStream() {
        try {
            WriteStream os = this._os;
            this._os = null;
            if (os != null) {
                os.close();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            WriteStream zipOut = this._zipOut;
            this._zipOut = null;
            if (zipOut != null) {
                zipOut.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushTempStream() {
        TempStream ts = this._tempStream;
        this._tempStream = null;
        this._tempStreamSize = 0L;
        try {
            if (ts != null) {
                if (this._os == null) {
                    this.openLog();
                }
                try {
                    ReadStream is = ts.openRead();
                    try {
                        is.writeToStream((OutputStream)this._os);
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    {
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Object var6_7 = null;
            this.notifyAll();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.notifyAll();
            throw throwable;
        }
    }

    class ArchiveTask
    implements Runnable {
        private boolean _isArchiving;

        ArchiveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractRolloverLog abstractRolloverLog;
            try {
                ArchiveTask archiveTask = this;
                synchronized (archiveTask) {
                    Path savedPath = AbstractRolloverLog.this._savedPath;
                    if (savedPath != null) {
                        AbstractRolloverLog.this.movePathToArchive(savedPath);
                    }
                    AbstractRolloverLog.this._savedPath = null;
                }
                Object var5_4 = null;
                abstractRolloverLog = AbstractRolloverLog.this;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                AbstractRolloverLog abstractRolloverLog2 = AbstractRolloverLog.this;
                synchronized (abstractRolloverLog2) {
                    AbstractRolloverLog.this._isRollingOver = false;
                    AbstractRolloverLog.this.flushTempStream();
                }
                throw throwable;
            }
            synchronized (abstractRolloverLog) {
                AbstractRolloverLog.this._isRollingOver = false;
                AbstractRolloverLog.this.flushTempStream();
            }
        }
    }
}

