/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.loader.ClassLoaderListener;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class EnvironmentLogger
extends Logger
implements ClassLoaderListener {
    private static final Handler[] EMPTY_HANDLERS = new Handler[0];
    private final EnvironmentLocal<Logger> _localLoggers = new EnvironmentLocal();
    private final EnvironmentLocal<Handler[]> _localHandlers = new EnvironmentLocal();
    private final EnvironmentLocal<HandlerEntry> _ownHandlers = new EnvironmentLocal();
    private final EnvironmentLocal<Boolean> _useParentHandlers = new EnvironmentLocal();
    private boolean _hasLocalLevel;
    private final EnvironmentLocal<Level> _localLevel = new EnvironmentLocal();
    private EnvironmentLogger _parent;
    private Level _assignedLevel = Level.INFO;
    private Level _handlerLevel = Level.OFF;
    private final ArrayList<WeakReference<EnvironmentLogger>> _children = new ArrayList();
    private final ArrayList<WeakReference<ClassLoader>> _loaders = new ArrayList();

    public EnvironmentLogger(String name, String resourceBundleName) {
        super(name, resourceBundleName);
    }

    public void setParent(Logger parent) {
        if (parent.equals(this._parent)) {
            return;
        }
        super.setParent(parent);
        if (parent instanceof EnvironmentLogger) {
            this._parent = (EnvironmentLogger)parent;
            this._assignedLevel = this._parent.getAssignedLevel();
            this._handlerLevel = this._parent.getHandlerLevel();
            this.setEffectiveLevel();
            this._parent.addChild(this);
        }
    }

    private Level getHandlerLevel() {
        return this._handlerLevel;
    }

    void addChild(EnvironmentLogger child) {
        this._children.add(new WeakReference<EnvironmentLogger>(child));
    }

    public synchronized void addHandler(Handler handler) {
        HandlerEntry ownHandlers;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean hasLoader = false;
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = (ClassLoader)ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
            }
            if (refLoader == loader) {
                hasLoader = true;
            }
            if (!this.isParentLoader(loader, refLoader)) continue;
            this.addHandler(handler, refLoader);
        }
        if (!hasLoader) {
            this._loaders.add(new WeakReference<ClassLoader>(loader));
            this.addHandler(handler, loader);
            Environment.addClassLoaderListener(this, loader);
        }
        if ((ownHandlers = this._ownHandlers.get()) == null) {
            ownHandlers = new HandlerEntry(this);
            this._ownHandlers.set(ownHandlers);
        }
        ownHandlers.addHandler(handler);
    }

    private void addHandler(Handler handler, ClassLoader loader) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        handlers.add(handler);
        for (ClassLoader ptr = loader; ptr != null; ptr = ptr.getParent()) {
            Handler[] localHandlers = this._localHandlers.getLevel(ptr);
            if (localHandlers == null) continue;
            for (int i = 0; i < localHandlers.length; ++i) {
                int p = handlers.indexOf(localHandlers[i]);
                if (p < 0) {
                    handlers.add(localHandlers[i]);
                    continue;
                }
                Handler oldHandler = (Handler)handlers.get(p);
                if (localHandlers[i].getLevel().intValue() >= oldHandler.getLevel().intValue()) continue;
                handlers.set(p, localHandlers[i]);
            }
        }
        Handler[] newHandlers = new Handler[handlers.size()];
        handlers.toArray(newHandlers);
        this._localHandlers.set(newHandlers);
        this.setHandlerLevel(handler.getLevel());
    }

    public synchronized void removeHandler(Handler handler) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean hasLoader = false;
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = (ClassLoader)ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
            }
            if (!this.isParentLoader(loader, refLoader)) continue;
            this.removeHandler(handler, refLoader);
        }
        HandlerEntry ownHandlers = this._ownHandlers.get();
        if (ownHandlers != null) {
            ownHandlers.removeHandler(handler);
        }
    }

    private void removeHandler(Handler handler, ClassLoader loader) {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (ClassLoader ptr = loader; ptr != null; ptr = ptr.getParent()) {
            Handler[] localHandlers = this._localHandlers.getLevel(ptr);
            if (localHandlers == null) continue;
            for (int i = 0; i < localHandlers.length; ++i) {
                if (localHandlers[i].equals(handler)) continue;
                int p = handlers.indexOf(localHandlers[i]);
                if (p < 0) {
                    handlers.add(localHandlers[i]);
                    continue;
                }
                Handler oldHandler = (Handler)handlers.get(p);
                if (localHandlers[i].getLevel().intValue() >= oldHandler.getLevel().intValue()) continue;
                handlers.set(p, localHandlers[i]);
            }
        }
        Handler[] newHandlers = new Handler[handlers.size()];
        handlers.toArray(newHandlers);
        this._localHandlers.set(newHandlers);
        this.setHandlerLevel(handler.getLevel());
    }

    private boolean isParentLoader(ClassLoader parent, ClassLoader child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getParent();
        }
        return false;
    }

    boolean addLogger(Logger logger) {
        if (logger.getClass().getName().startsWith("java")) {
            return false;
        }
        Logger oldLogger = this._localLoggers.get();
        if (oldLogger != null) {
            return false;
        }
        this._localLoggers.set(logger);
        return true;
    }

    Logger getLogger() {
        return this._localLoggers.get();
    }

    public void log(LogRecord record) {
        Level level;
        if (record == null) {
            return;
        }
        if (this._hasLocalLevel && (level = this._localLevel.get()) != null && record.getLevel().intValue() < level.intValue()) {
            return;
        }
        for (Logger ptr = this; ptr != null; ptr = ptr.getParent()) {
            Handler[] handlers = ((Logger)ptr).getHandlers();
            if (handlers != null) {
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i].publish(record);
                }
            }
            if (!((Logger)ptr).getUseParentHandlers()) break;
        }
    }

    public Handler[] getHandlers() {
        Handler[] handlers = this._localHandlers.get();
        if (handlers != null) {
            return handlers;
        }
        return EMPTY_HANDLERS;
    }

    public boolean getUseParentHandlers() {
        Boolean value = this._useParentHandlers.get();
        if (value != null) {
            return Boolean.TRUE.equals(value);
        }
        return true;
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this._useParentHandlers.set(new Boolean(useParentHandlers));
    }

    public void classLoaderInit(DynamicClassLoader env) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
        this.removeLoader(loader);
        this._localHandlers.remove(loader);
        HandlerEntry ownHandlers = this._ownHandlers.getLevel(loader);
        if (ownHandlers != null) {
            this._ownHandlers.remove(loader);
        }
        if (ownHandlers != null) {
            ownHandlers.destroy();
        }
        this._localLevel.remove(loader);
        this.updateAssignedLevel();
        this.updateHandlerLevel();
    }

    public void setLevel(Level level) {
        this._localLevel.set(level);
        if (level != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this.addLoader(loader);
        }
        this.updateAssignedLevel();
    }

    private void addLoader(ClassLoader loader) {
        boolean hasLoader = false;
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = (ClassLoader)ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
            }
            if (refLoader != loader) continue;
            return;
        }
        this._loaders.add(new WeakReference<ClassLoader>(loader));
        Environment.addClassLoaderListener(this, loader);
    }

    public Level getLevel() {
        Level level;
        if (this._hasLocalLevel && (level = this._localLevel.get()) != null) {
            return level;
        }
        return null;
    }

    private Level getAssignedLevel() {
        for (Logger log = this; log != null; log = log.getParent()) {
            Level level = ((Logger)log).getLevel();
            if (level == null) continue;
            return level;
        }
        return Level.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandlerLevel(Level level) {
        if (this._handlerLevel.intValue() <= level.intValue()) {
            return;
        }
        this._handlerLevel = level;
        this.setEffectiveLevel();
        EnvironmentLogger environmentLogger = this;
        synchronized (environmentLogger) {
            for (int i = this._children.size() - 1; i >= 0; --i) {
                WeakReference<EnvironmentLogger> ref = this._children.get(i);
                EnvironmentLogger child = (EnvironmentLogger)ref.get();
                if (child != null) {
                    if (this._handlerLevel.intValue() >= child._handlerLevel.intValue()) continue;
                    child.setHandlerLevel(level);
                    continue;
                }
                this._children.remove(i);
            }
        }
    }

    private synchronized void updateAssignedLevel() {
        WeakReference<Object> ref;
        int i;
        Level oldAssignedLevel = this._assignedLevel;
        this._assignedLevel = Level.INFO;
        this._hasLocalLevel = false;
        if (this._parent != null) {
            this._assignedLevel = this._parent.getAssignedLevel();
        }
        for (i = this._loaders.size() - 1; i >= 0; --i) {
            ref = this._loaders.get(i);
            ClassLoader loader = (ClassLoader)ref.get();
            if (loader == null) {
                this._loaders.remove(i);
            }
            while (loader != null) {
                if (loader instanceof EnvironmentClassLoader) {
                    EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                    this.updateClassLoaderLevel(envLoader);
                }
                loader = loader.getParent();
            }
            this.updateClassLoaderLevel(ClassLoader.getSystemClassLoader());
        }
        this.setEffectiveLevel();
        if (oldAssignedLevel.intValue() != this._assignedLevel.intValue()) {
            for (i = this._children.size() - 1; i >= 0; --i) {
                ref = this._children.get(i);
                EnvironmentLogger child = (EnvironmentLogger)ref.get();
                if (child != null) {
                    child.updateAssignedLevel();
                    continue;
                }
                this._children.remove(i);
            }
        }
    }

    private void updateClassLoaderLevel(ClassLoader loader) {
        Level localLevel = this._localLevel.get(loader);
        if (localLevel != null) {
            if (!this._hasLocalLevel) {
                this._assignedLevel = localLevel;
            } else if (localLevel.intValue() < this._assignedLevel.intValue()) {
                this._assignedLevel = localLevel;
            }
            this._hasLocalLevel = true;
        }
    }

    private synchronized void updateHandlerLevel() {
        WeakReference<Object> ref;
        int i;
        Level oldHandlerLevel = this._handlerLevel;
        this._handlerLevel = Level.OFF;
        if (this._parent != null) {
            this._handlerLevel = this._parent.getHandlerLevel();
        }
        for (i = this._loaders.size() - 1; i >= 0; --i) {
            ref = this._loaders.get(i);
            ClassLoader loader = (ClassLoader)ref.get();
            if (loader == null) {
                this._loaders.remove(i);
            }
            while (loader != null) {
                if (loader instanceof EnvironmentClassLoader) {
                    EnvironmentClassLoader envLoader = (EnvironmentClassLoader)loader;
                    Handler[] handlers = this._localHandlers.getLevel(envLoader);
                    for (int j = 0; handlers != null && j < handlers.length; ++j) {
                        Level subLevel;
                        if (handlers[j].getLevel() == null || (subLevel = handlers[j].getLevel()).intValue() >= this._handlerLevel.intValue()) continue;
                        this._handlerLevel = subLevel;
                    }
                }
                loader = loader.getParent();
            }
        }
        this.setEffectiveLevel();
        if (oldHandlerLevel.intValue() < this._handlerLevel.intValue()) {
            for (i = this._children.size() - 1; i >= 0; --i) {
                ref = this._children.get(i);
                EnvironmentLogger child = (EnvironmentLogger)ref.get();
                if (child != null) {
                    child.updateHandlerLevel();
                    continue;
                }
                this._children.remove(i);
            }
        }
    }

    private void setEffectiveLevel() {
        if (this._handlerLevel.intValue() < this._assignedLevel.intValue()) {
            super.setLevel(this._assignedLevel);
        } else {
            super.setLevel(this._handlerLevel);
        }
    }

    private synchronized void removeLoader(ClassLoader loader) {
        for (int i = this._loaders.size() - 1; i >= 0; --i) {
            WeakReference<ClassLoader> ref = this._loaders.get(i);
            ClassLoader refLoader = (ClassLoader)ref.get();
            if (refLoader == null) {
                this._loaders.remove(i);
                continue;
            }
            if (refLoader != loader) continue;
            this._loaders.remove(i);
        }
    }

    public String toString() {
        return "EnvironmentLogger[" + this.getName() + "]";
    }

    static class HandlerEntry {
        private final EnvironmentLogger _logger;
        private ArrayList<Handler> _handlers = new ArrayList();

        HandlerEntry(EnvironmentLogger logger) {
            this._logger = logger;
        }

        void addHandler(Handler handler) {
            this._handlers.add(handler);
        }

        void removeHandler(Handler handler) {
            this._handlers.remove(handler);
        }

        void destroy() {
            ArrayList<Handler> handlers = this._handlers;
            this._handlers = null;
            for (int i = 0; handlers != null && i < handlers.size(); ++i) {
                Handler handler = handlers.get(i);
                try {
                    handler.close();
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

