/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LevelHandler
extends Handler {
    private final int _level;
    private final Handler[] _handlers;

    public LevelHandler(Level level, Handler[] handlers) {
        this._level = level.intValue();
        this._handlers = handlers;
    }

    public void publish(LogRecord record) {
        int recordLevel = record.getLevel().intValue();
        if (recordLevel < this._level) {
            return;
        }
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            if (this._level > handler.getLevel().intValue()) continue;
            handler.publish(record);
        }
    }

    public void flush() {
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            if (this._level > handler.getLevel().intValue()) continue;
            handler.flush();
        }
    }

    public void close() {
    }
}

