/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.LoggerMXBean;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerAdmin
extends AbstractManagedObject
implements LoggerMXBean {
    private static final L10N L = new L10N(LoggerAdmin.class);
    private final Logger _logger;
    private final ClassLoader _loader;
    private Level _level;

    LoggerAdmin(Logger logger) {
        this._logger = logger;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public String getName() {
        return this._logger.getName();
    }

    public void setLevel(String levelName) {
        if (levelName.equals("off")) {
            Level level = Level.OFF;
        } else if (levelName.equals("severe")) {
            Level level = Level.SEVERE;
        } else if (levelName.equals("warning")) {
            Level level = Level.WARNING;
        } else if (levelName.equals("info")) {
            Level level = Level.INFO;
        } else if (levelName.equals("config")) {
            Level level = Level.CONFIG;
        } else if (levelName.equals("fine")) {
            Level level = Level.FINE;
        } else if (levelName.equals("finer")) {
            Level level = Level.FINER;
        } else if (levelName.equals("finest")) {
            Level level = Level.FINEST;
        } else if (levelName.equals("all")) {
            Level level = Level.ALL;
        } else {
            throw new IllegalArgumentException(L.l("`{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging", (Object)levelName));
        }
    }

    public String getLevel() {
        return null;
    }
}

