/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.vfs.Syslog;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class SyslogHandler
extends Handler {
    private static L10N L = new L10N(SyslogHandler.class);
    private int _facility = 3;
    private int _severity = 6;

    public void setFacility(String facility) throws ConfigException {
        if ("user".equals(facility)) {
            this._facility = 1;
        } else if ("mail".equals(facility)) {
            this._facility = 2;
        } else if ("daemon".equals(facility)) {
            this._facility = 3;
        } else if ("auth".equals(facility)) {
            this._facility = 4;
        } else if ("lpr".equals(facility)) {
            this._facility = 6;
        } else if ("news".equals(facility)) {
            this._facility = 7;
        } else if ("uucp".equals(facility)) {
            this._facility = 8;
        } else if ("cron".equals(facility)) {
            this._facility = 9;
        } else if ("authpriv".equals(facility)) {
            this._facility = 10;
        } else if ("ftp".equals(facility)) {
            this._facility = 11;
        } else if ("local0".equals(facility)) {
            this._facility = 16;
        } else if ("local1".equals(facility)) {
            this._facility = 17;
        } else if ("local2".equals(facility)) {
            this._facility = 18;
        } else if ("local3".equals(facility)) {
            this._facility = 19;
        } else if ("local4".equals(facility)) {
            this._facility = 20;
        } else if ("local5".equals(facility)) {
            this._facility = 21;
        } else if ("local6".equals(facility)) {
            this._facility = 22;
        } else if ("local7".equals(facility)) {
            this._facility = 23;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown syslog facility.", (Object)facility));
        }
    }

    public void setSeverity(String severity) throws ConfigException {
        if ("emerg".equals(severity)) {
            this._facility = 0;
        } else if ("alert".equals(severity)) {
            this._facility = 1;
        } else if ("crit".equals(severity)) {
            this._facility = 2;
        } else if ("err".equals(severity)) {
            this._facility = 3;
        } else if ("warning".equals(severity)) {
            this._facility = 4;
        } else if ("notice".equals(severity)) {
            this._facility = 5;
        } else if ("info".equals(severity)) {
            this._facility = 6;
        } else if ("debug".equals(severity)) {
            this._facility = 7;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown syslog severity.", (Object)severity));
        }
    }

    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        Syslog.syslog((int)this._facility, (int)this._severity, (String)record.getMessage());
    }

    public void flush() {
    }

    public void close() {
    }
}

