/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.loader.Environment;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;

public class TimestampFilter
extends StreamImpl {
    static final String[] DAY_NAMES = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] SHORT_WEEKDAY = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] LONG_WEEKDAY = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] SHORT_MONTH = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] LONG_MONTH = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private WriteStream _stream;
    private String _timestampString;
    private TimestampBase[] _timestamp;
    private QDate _calendar = new QDate(true);
    private boolean _isLineBegin = true;

    public TimestampFilter() {
    }

    public TimestampFilter(WriteStream out, String timestamp) {
        this._stream = out;
        this.setTimestamp(timestamp);
    }

    public void setTimestamp(String timestamp) {
        this._timestampString = timestamp;
        ArrayList<TimestampBase> timestampList = new ArrayList<TimestampBase>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < timestamp.length(); ++i) {
            char ch = timestamp.charAt(i);
            if (ch == '%') {
                ch = timestamp.charAt(i + 1);
                switch (ch) {
                    case 'A': 
                    case 'B': 
                    case 'H': 
                    case 'I': 
                    case 'M': 
                    case 'S': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'j': 
                    case 'm': 
                    case 'p': 
                    case 's': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        if (sb.length() > 0) {
                            timestampList.add(new Text(sb.toString()));
                        }
                        sb.setLength(0);
                        timestampList.add(new Code(ch));
                        ++i;
                        break;
                    }
                    case '{': {
                        if (sb.length() > 0) {
                            timestampList.add(new Text(sb.toString()));
                        }
                        sb.setLength(0);
                        i += 2;
                        while (i < timestamp.length() && timestamp.charAt(i) != '}') {
                            sb.append(timestamp.charAt(i));
                            ++i;
                        }
                        String type = sb.toString();
                        sb.setLength(0);
                        if ("thread".equals(type)) {
                            timestampList.add(new ThreadTimestamp());
                            break;
                        }
                        if ("env".equals(type)) {
                            timestampList.add(new EnvTimestamp());
                            break;
                        }
                        sb.append("%{" + type + "}");
                        break;
                    }
                    default: {
                        sb.append('%');
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            timestampList.add(new Text(sb.toString()));
        }
        this._timestamp = new TimestampBase[timestampList.size()];
        timestampList.toArray(this._timestamp);
    }

    public void setStream(WriteStream stream) {
        this._stream = stream;
    }

    public Path getPath() {
        if (this._stream != null) {
            return this._stream.getPath();
        }
        return super.getPath();
    }

    public boolean canWrite() {
        return this._stream != null && this._stream.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
        if (this._stream == null) {
            return;
        }
        if (this._timestamp == null) {
            this._stream.write(buffer, offset, length);
            return;
        }
        long now = CauchoSystem.isTesting() ? Alarm.getCurrentTime() : System.currentTimeMillis();
        for (int i = 0; i < length; ++i) {
            if (this._isLineBegin) {
                QDate qDate = this._calendar;
                synchronized (qDate) {
                    this._calendar.setGMTTime(now);
                    int len = this._timestamp.length;
                    for (int j = 0; j < len; ++j) {
                        this._timestamp[j].print(this._stream, this._calendar);
                    }
                }
                this._isLineBegin = false;
            }
            byte ch = buffer[offset + i];
            this._stream.write((int)ch);
            if (ch != 10 && (ch != 13 || i + 1 >= length || buffer[offset + i + 1] == 10)) continue;
            this._isLineBegin = true;
        }
    }

    public void flush() throws IOException {
        if (this._stream != null) {
            this._stream.flush();
        }
    }

    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
    }

    static class EnvTimestamp
    extends TimestampBase {
        EnvTimestamp() {
        }

        public void print(WriteStream out, QDate cal) throws IOException {
            out.print(Environment.getEnvironmentName());
        }
    }

    static class ThreadTimestamp
    extends TimestampBase {
        ThreadTimestamp() {
        }

        public void print(WriteStream out, QDate cal) throws IOException {
            out.print(Thread.currentThread().getName());
        }
    }

    static class Code
    extends TimestampBase {
        private final char _code;

        Code(char code) {
            this._code = code;
        }

        public void print(WriteStream out, QDate cal) throws IOException {
            switch (this._code) {
                case 'a': {
                    out.print(SHORT_WEEKDAY[cal.getDayOfWeek() - 1]);
                    break;
                }
                case 'A': {
                    out.print(LONG_WEEKDAY[cal.getDayOfWeek() - 1]);
                    break;
                }
                case 'b': {
                    out.print(SHORT_MONTH[cal.getMonth()]);
                    break;
                }
                case 'B': {
                    out.print(LONG_MONTH[cal.getMonth()]);
                    break;
                }
                case 'c': {
                    out.print(cal.printLocaleDate());
                    break;
                }
                case 'd': {
                    out.print(cal.getDayOfMonth() / 10);
                    out.print(cal.getDayOfMonth() % 10);
                    break;
                }
                case 'H': {
                    int hour = (int)(cal.getTimeOfDay() / 3600000L) % 24;
                    out.print(hour / 10);
                    out.print(hour % 10);
                    break;
                }
                case 'I': {
                    int hour = (int)(cal.getTimeOfDay() / 3600000L) % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    out.print(hour / 10);
                    out.print(hour % 10);
                    break;
                }
                case 'j': {
                    out.print((cal.getDayOfYear() + 1) / 100);
                    out.print((cal.getDayOfYear() + 1) / 10 % 10);
                    out.print((cal.getDayOfYear() + 1) % 10);
                    break;
                }
                case 'm': {
                    out.print((cal.getMonth() + 1) / 10);
                    out.print((cal.getMonth() + 1) % 10);
                    break;
                }
                case 'M': {
                    out.print(cal.getTimeOfDay() / 600000L % 6L);
                    out.print(cal.getTimeOfDay() / 60000L % 10L);
                    break;
                }
                case 'p': {
                    int hour = (int)(cal.getTimeOfDay() / 3600000L) % 24;
                    if (hour < 12) {
                        out.print("am");
                        break;
                    }
                    out.print("pm");
                    break;
                }
                case 'S': {
                    out.print(cal.getTimeOfDay() / 10000L % 6L);
                    out.print(cal.getTimeOfDay() / 1000L % 10L);
                    break;
                }
                case 's': {
                    out.print(cal.getTimeOfDay() / 100L % 10L);
                    out.print(cal.getTimeOfDay() / 10L % 10L);
                    out.print(cal.getTimeOfDay() % 10L);
                    break;
                }
                case 'W': {
                    int week = cal.getWeek();
                    out.print((week + 1) / 10);
                    out.print((week + 1) % 10);
                    break;
                }
                case 'w': {
                    out.print(cal.getDayOfWeek() - 1);
                    break;
                }
                case 'x': {
                    out.print(cal.printShortLocaleDate());
                    break;
                }
                case 'X': {
                    out.print(cal.printShortLocaleTime());
                    break;
                }
                case 'y': {
                    int year = cal.getYear();
                    out.print(year / 10 % 10);
                    out.print(year % 10);
                    break;
                }
                case 'Y': {
                    int year = cal.getYear();
                    out.print(year / 1000 % 10);
                    out.print(year / 100 % 10);
                    out.print(year / 10 % 10);
                    out.print(year % 10);
                    break;
                }
                case 'Z': {
                    if (cal.getZoneName() == null) {
                        out.print("GMT");
                        break;
                    }
                    out.print(cal.getZoneName());
                    break;
                }
                case 'z': {
                    long offset = cal.getZoneOffset();
                    if (offset < 0L) {
                        out.print("-");
                        offset = -offset;
                    } else {
                        out.print("+");
                    }
                    out.print(offset / 36000000L % 10L);
                    out.print(offset / 3600000L % 10L);
                    out.print(offset / 600000L % 6L);
                    out.print(offset / 60000L % 10L);
                }
            }
        }
    }

    static class Text
    extends TimestampBase {
        private final char[] _text;

        Text(String text) {
            this._text = text.toCharArray();
        }

        public void print(WriteStream out, QDate cal) throws IOException {
            out.print(this._text, 0, this._text.length);
        }
    }

    static class TimestampBase {
        TimestampBase() {
        }

        public void print(WriteStream out, QDate cal) throws IOException {
        }
    }
}

