/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log.formatter;

import com.caucho.loader.Environment;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.Alarm;
import com.caucho.util.QDate;
import java.util.ArrayList;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TimestampFormatter
extends Formatter {
    static final String[] DAY_NAMES = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] SHORT_WEEKDAY = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] LONG_WEEKDAY = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] SHORT_MONTH = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] LONG_MONTH = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private String _timestampString;
    private TimestampBase[] _timestamp;
    private QDate _calendar = new QDate(true);

    public TimestampFormatter() {
        this.setTimestamp("[%Y-%m-%d %H:%M:%S] %{level} {%{thread}} ");
    }

    public void setValue(String timestamp) {
        this.setTimestamp(timestamp);
    }

    public void setTimestamp(String timestamp) {
        this._timestampString = timestamp;
        ArrayList<TimestampBase> timestampList = new ArrayList<TimestampBase>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < timestamp.length(); ++i) {
            char ch = timestamp.charAt(i);
            if (ch == '%') {
                ch = timestamp.charAt(i + 1);
                switch (ch) {
                    case 'A': 
                    case 'B': 
                    case 'H': 
                    case 'I': 
                    case 'M': 
                    case 'S': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'j': 
                    case 'm': 
                    case 'p': 
                    case 's': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        if (sb.length() > 0) {
                            timestampList.add(new Text(sb.toString()));
                        }
                        sb.setLength(0);
                        timestampList.add(new Code(ch));
                        ++i;
                        break;
                    }
                    case '{': {
                        if (sb.length() > 0) {
                            timestampList.add(new Text(sb.toString()));
                        }
                        sb.setLength(0);
                        i += 2;
                        while (i < timestamp.length() && timestamp.charAt(i) != '}') {
                            sb.append(timestamp.charAt(i));
                            ++i;
                        }
                        String type = sb.toString();
                        sb.setLength(0);
                        if ("thread".equals(type)) {
                            timestampList.add(new ThreadTimestamp());
                            break;
                        }
                        if ("level".equals(type)) {
                            timestampList.add(new LevelTimestamp());
                            break;
                        }
                        if ("env".equals(type)) {
                            timestampList.add(new EnvTimestamp());
                            break;
                        }
                        sb.append("%{" + type + "}");
                        break;
                    }
                    default: {
                        sb.append('%');
                        break;
                    }
                }
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            timestampList.add(new Text(sb.toString()));
        }
        this._timestamp = new TimestampBase[timestampList.size()];
        timestampList.toArray(this._timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord log) {
        if (this._timestamp == null) {
            return log.getMessage();
        }
        long now = CauchoSystem.isTesting() ? Alarm.getCurrentTime() : System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        QDate qDate = this._calendar;
        synchronized (qDate) {
            this._calendar.setGMTTime(now);
            int len = this._timestamp.length;
            for (int j = 0; j < len; ++j) {
                this._timestamp[j].format(sb, this._calendar, log);
            }
        }
        sb.append(log.getMessage());
        return sb.toString();
    }

    static class EnvTimestamp
    extends TimestampBase {
        EnvTimestamp() {
        }

        public void format(StringBuilder sb, QDate cal, LogRecord log) {
            sb.append(Environment.getEnvironmentName());
        }
    }

    static class LevelTimestamp
    extends TimestampBase {
        LevelTimestamp() {
        }

        public void format(StringBuilder sb, QDate cal, LogRecord log) {
            sb.append(log.getLevel());
        }
    }

    static class ThreadTimestamp
    extends TimestampBase {
        ThreadTimestamp() {
        }

        public void format(StringBuilder sb, QDate cal, LogRecord log) {
            sb.append(Thread.currentThread().getName());
        }
    }

    static class Code
    extends TimestampBase {
        private final char _code;

        Code(char code) {
            this._code = code;
        }

        public void format(StringBuilder sb, QDate cal, LogRecord log) {
            switch (this._code) {
                case 'a': {
                    sb.append(SHORT_WEEKDAY[cal.getDayOfWeek() - 1]);
                    break;
                }
                case 'A': {
                    sb.append(LONG_WEEKDAY[cal.getDayOfWeek() - 1]);
                    break;
                }
                case 'b': {
                    sb.append(SHORT_MONTH[cal.getMonth()]);
                    break;
                }
                case 'B': {
                    sb.append(LONG_MONTH[cal.getMonth()]);
                    break;
                }
                case 'c': {
                    sb.append(cal.printLocaleDate());
                    break;
                }
                case 'd': {
                    sb.append(cal.getDayOfMonth() / 10);
                    sb.append(cal.getDayOfMonth() % 10);
                    break;
                }
                case 'H': {
                    int hour = (int)(cal.getTimeOfDay() / 3600000L) % 24;
                    sb.append(hour / 10);
                    sb.append(hour % 10);
                    break;
                }
                case 'I': {
                    int hour = (int)(cal.getTimeOfDay() / 3600000L) % 12;
                    if (hour == 0) {
                        hour = 12;
                    }
                    sb.append(hour / 10);
                    sb.append(hour % 10);
                    break;
                }
                case 'j': {
                    sb.append((cal.getDayOfYear() + 1) / 100);
                    sb.append((cal.getDayOfYear() + 1) / 10 % 10);
                    sb.append((cal.getDayOfYear() + 1) % 10);
                    break;
                }
                case 'm': {
                    sb.append((cal.getMonth() + 1) / 10);
                    sb.append((cal.getMonth() + 1) % 10);
                    break;
                }
                case 'M': {
                    sb.append(cal.getTimeOfDay() / 600000L % 6L);
                    sb.append(cal.getTimeOfDay() / 60000L % 10L);
                    break;
                }
                case 'p': {
                    int hour = (int)(cal.getTimeOfDay() / 3600000L) % 24;
                    if (hour < 12) {
                        sb.append("am");
                        break;
                    }
                    sb.append("pm");
                    break;
                }
                case 'S': {
                    sb.append(cal.getTimeOfDay() / 10000L % 6L);
                    sb.append(cal.getTimeOfDay() / 1000L % 10L);
                    break;
                }
                case 's': {
                    sb.append(cal.getTimeOfDay() / 100L % 10L);
                    sb.append(cal.getTimeOfDay() / 10L % 10L);
                    sb.append(cal.getTimeOfDay() % 10L);
                    break;
                }
                case 'W': {
                    int week = cal.getWeek();
                    sb.append((week + 1) / 10);
                    sb.append((week + 1) % 10);
                    break;
                }
                case 'w': {
                    sb.append(cal.getDayOfWeek() - 1);
                    break;
                }
                case 'x': {
                    sb.append(cal.printShortLocaleDate());
                    break;
                }
                case 'X': {
                    sb.append(cal.printShortLocaleTime());
                    break;
                }
                case 'y': {
                    int year = cal.getYear();
                    sb.append(year / 10 % 10);
                    sb.append(year % 10);
                    break;
                }
                case 'Y': {
                    int year = cal.getYear();
                    sb.append(year / 1000 % 10);
                    sb.append(year / 100 % 10);
                    sb.append(year / 10 % 10);
                    sb.append(year % 10);
                    break;
                }
                case 'Z': {
                    if (cal.getZoneName() == null) {
                        sb.append("GMT");
                        break;
                    }
                    sb.append(cal.getZoneName());
                    break;
                }
                case 'z': {
                    long offset = cal.getZoneOffset();
                    if (offset < 0L) {
                        sb.append("-");
                        offset = -offset;
                    } else {
                        sb.append("+");
                    }
                    sb.append(offset / 36000000L % 10L);
                    sb.append(offset / 3600000L % 10L);
                    sb.append(offset / 600000L % 6L);
                    sb.append(offset / 60000L % 10L);
                }
            }
        }
    }

    static class Text
    extends TimestampBase {
        private final char[] _text;

        Text(String text) {
            this._text = text.toCharArray();
        }

        public void format(StringBuilder sb, QDate cal, LogRecord log) {
            sb.append(this._text, 0, this._text.length);
        }
    }

    static class TimestampBase {
        TimestampBase() {
        }

        public void format(StringBuilder sb, QDate cal, LogRecord log) {
        }
    }
}

