/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log.handler;

import com.caucho.config.ConfigException;
import com.caucho.hmtp.HmtpConnection;
import com.caucho.hmtp.HmtpConnectionFactory;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.webbeans.In;

public class HmtpHandler
extends Handler {
    private static final Logger log = Logger.getLogger(HmtpHandler.class.getName());
    private static final L10N L = new L10N(HmtpHandler.class);
    @In
    private HmtpConnectionFactory _factory;
    private HmtpConnection _conn;
    private String _to;

    public void setTo(String to) {
        this._to = to;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._to == null) {
            throw new ConfigException(L.l("HmppHandler needs a 'to' attribute"));
        }
        this._conn = this._factory.getConnection("log@localhost", null);
    }

    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.getLevel().intValue()) {
            return;
        }
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        try {
            Formatter formatter = this.getFormatter();
            String value = formatter != null ? formatter.format(record) : record.getMessage();
            this._conn.sendMessage(this._to, (Serializable)((Object)value));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._to + "]";
    }
}

