/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.util.Crc64;
import com.caucho.vfs.PersistentDependency;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassDependency
implements PersistentDependency {
    private static final Logger log = Logger.getLogger(ClassDependency.class.getName());
    private Class _cl;
    private boolean _checkFields = true;
    private boolean _checkStatic = true;
    private boolean _checkProtected = true;
    private boolean _checkPrivate = true;
    private boolean _isDigestModified;
    private long _newDigest;

    public ClassDependency(Class cl) {
        this._cl = cl;
    }

    public ClassDependency(Class cl, long digest) {
        this._cl = cl;
        long newDigest = this.getDigest();
        if (newDigest != digest) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._cl.getName() + " digest is modified (old=" + digest + ",new=" + newDigest + ")");
            }
            this._isDigestModified = true;
        }
    }

    public boolean isModified() {
        return this._isDigestModified;
    }

    public boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this._cl.getName() + " digest is modified");
            return true;
        }
        return false;
    }

    public long getDigest() {
        try {
            if (this._newDigest != 0L) {
                return this._newDigest;
            }
            if (this._cl == null) {
                return -1L;
            }
            long digest = 37L;
            this._newDigest = digest = this.addDigest(digest, this._cl);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
            this._newDigest = -1L;
        }
        return this._newDigest;
    }

    private long addDigest(long digest, Class cl) throws Exception {
        int i;
        if (this._cl == null) {
            return digest;
        }
        digest = ClassDependency.addDigest(digest, cl.getName());
        digest = ClassDependency.addDigest(digest, cl.getModifiers());
        Class superClass = cl.getSuperclass();
        if (superClass != null && superClass.getName().startsWith("java.") && !superClass.getName().startsWith("javax.")) {
            digest = this.addDigest(digest, superClass);
        }
        Class<?>[] interfaces = cl.getInterfaces();
        Arrays.sort(interfaces, ClassComparator.CMP);
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            digest = ClassDependency.addDigest(digest, interfaces[i2].getName());
        }
        if (this._checkFields) {
            Field[] fields = cl.getDeclaredFields();
            Arrays.sort(fields, FieldComparator.CMP);
            for (i = 0; i < fields.length; ++i) {
                int modifiers = fields[i].getModifiers();
                if (Modifier.isPrivate(modifiers) && !this._checkPrivate || Modifier.isProtected(modifiers) && !this._checkProtected) continue;
                digest = ClassDependency.addDigest(digest, fields[i].getName());
                digest = ClassDependency.addDigest(digest, fields[i].getModifiers());
                digest = ClassDependency.addDigest(digest, fields[i].getType().getName());
            }
        }
        Method[] methods = cl.getDeclaredMethods();
        Arrays.sort(methods, MethodComparator.CMP);
        for (i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) && !this._checkPrivate || Modifier.isProtected(modifiers) && !this._checkProtected || Modifier.isStatic(modifiers) && !this._checkStatic) continue;
            digest = ClassDependency.addDigest(digest, method.getName());
            digest = ClassDependency.addDigest(digest, method.getModifiers());
            digest = ClassDependency.addDigest(digest, method.getName());
            Class<?>[] param = method.getParameterTypes();
            for (int j = 0; j < param.length; ++j) {
                digest = ClassDependency.addDigest(digest, param[j].getName());
            }
            digest = ClassDependency.addDigest(digest, method.getReturnType().getName());
            Class<?>[] exn = method.getExceptionTypes();
            Arrays.sort(exn, ClassComparator.CMP);
            for (int j = 0; j < exn.length; ++j) {
                digest = ClassDependency.addDigest(digest, exn[j].getName());
            }
        }
        return digest;
    }

    public String getJavaCreateString() {
        return "new com.caucho.make.ClassDependency(" + this._cl.getName().replace('$', '.') + ".class, " + this.getDigest() + "L)";
    }

    private static long addDigest(long digest, long v) {
        digest = Crc64.generate((long)digest, (byte)((byte)(v >> 24)));
        digest = Crc64.generate((long)digest, (byte)((byte)(v >> 16)));
        digest = Crc64.generate((long)digest, (byte)((byte)(v >> 8)));
        digest = Crc64.generate((long)digest, (byte)((byte)v));
        return digest;
    }

    private static long addDigest(long digest, String string) {
        return Crc64.generate((long)digest, (String)string);
    }

    public int hashCode() {
        return this._cl.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDependency)) {
            return false;
        }
        ClassDependency depend = (ClassDependency)o;
        return this._cl.equals(depend._cl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodComparator
    implements Comparator<Method> {
        static final MethodComparator CMP = new MethodComparator();

        MethodComparator() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?>[] paramB;
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            Class<?>[] paramA = a.getParameterTypes();
            if (paramA.length < (paramB = b.getParameterTypes()).length) {
                return -1;
            }
            if (paramB.length < paramA.length) {
                return 1;
            }
            for (int i = 0; i < paramA.length; ++i) {
                cmp = paramA[i].getName().compareTo(paramB[i].getName());
                if (cmp == 0) continue;
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getReturnType().getName().compareTo(b.getReturnType().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldComparator
    implements Comparator<Field> {
        static final FieldComparator CMP = new FieldComparator();

        FieldComparator() {
        }

        @Override
        public int compare(Field a, Field b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getType().getName().compareTo(b.getType().getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassComparator
    implements Comparator<Class> {
        static final ClassComparator CMP = new ClassComparator();

        ClassComparator() {
        }

        @Override
        public int compare(Class a, Class b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            return a.getName().compareTo(b.getName());
        }
    }
}

