/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.Alarm;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DependencyContainer
implements Dependency {
    private static Logger _log;
    private ArrayList<Dependency> _dependencyList = new ArrayList();
    private boolean _isModified;
    private boolean _isModifiedLog;
    private long _checkInterval = DynamicClassLoader.getGlobalDependencyCheckInterval();
    private long _lastCheckTime = 0L;
    private volatile boolean _isChecking;

    public DependencyContainer() {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            this._checkInterval = ((DynamicClassLoader)loader).getDependencyCheckInterval();
            break;
        }
    }

    public DependencyContainer add(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't add self as a dependency.");
        }
        if (!this._dependencyList.contains(dependency)) {
            this._dependencyList.add(dependency);
        }
        return this;
    }

    public DependencyContainer remove(Dependency dependency) {
        if (dependency == this) {
            throw new IllegalArgumentException("Can't remove self as a dependency.");
        }
        this._dependencyList.remove(dependency);
        return this;
    }

    public int size() {
        return this._dependencyList.size();
    }

    public void setCheckInterval(long checkInterval) {
        this._checkInterval = checkInterval < 0L || checkInterval > 0x3FFFFFFFFFFFFFFFL ? 0x3FFFFFFFFFFFFFFFL : checkInterval;
        this._lastCheckTime = 0L;
    }

    public long getCheckInterval() {
        return this._checkInterval;
    }

    public void setModified(boolean isModified) {
        this._isModified = isModified;
        this._lastCheckTime = 0L;
        if (!isModified) {
            this._isModifiedLog = false;
        }
    }

    public void resetDependencyCheckInterval() {
        this._lastCheckTime = 0L;
    }

    public void clearModified() {
        this._isModified = false;
        this._lastCheckTime = Alarm.getCurrentTime();
        this._isModifiedLog = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        DependencyContainer dependencyContainer = this;
        synchronized (dependencyContainer) {
            if (this._isChecking || this._isModified) {
                return this._isModified;
            }
            this._isChecking = true;
        }
        try {
            long now = Alarm.getCurrentTime();
            if (now < this._lastCheckTime + this._checkInterval) {
                boolean bl = this._isModified;
                return bl;
            }
            this._lastCheckTime = now;
            for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
                Dependency dependency = this._dependencyList.get(i);
                if (!dependency.isModified()) continue;
                boolean bl = this._isModified = true;
                return bl;
            }
            boolean bl = this._isModified;
            return bl;
        }
        finally {
            this._isChecking = false;
        }
    }

    public boolean logModified(Logger log) {
        if (this._isModifiedLog) {
            return true;
        }
        for (int i = this._dependencyList.size() - 1; i >= 0; --i) {
            Dependency dependency = this._dependencyList.get(i);
            if (!dependency.logModified(log)) continue;
            this._isModifiedLog = true;
            return true;
        }
        return false;
    }

    public boolean isModifiedNow() {
        this._lastCheckTime = 0L;
        return this.isModified();
    }

    private Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(DependencyContainer.class.getName());
        }
        return _log;
    }

    public String toString() {
        return "DependencyContainer" + this._dependencyList;
    }
}

