/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.j2ee;

import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.management.j2ee.EventProvider;
import com.caucho.management.j2ee.J2EEApplication;
import com.caucho.management.j2ee.J2EEServer;
import com.caucho.management.j2ee.StateManageable;
import com.caucho.management.j2ee.StatisticsProvider;
import com.caucho.server.host.Host;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class J2EEManagedObject {
    private static final Logger log = Logger.getLogger(J2EEManagedObject.class.getName());
    private static final String[] CONTEXT_KEYS = new String[]{"J2EEServer", "Host", "J2EEApplication", "WebModule"};
    private final long _startTime = Alarm.getCurrentTime();
    protected ObjectName _objectName;

    public String getObjectName() {
        return this.createObjectName().getCanonicalName();
    }

    ObjectName createObjectName() {
        block5: {
            if (this._objectName == null) {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                try {
                    this._objectName = this.createObjectName(properties);
                }
                catch (MalformedObjectNameException ex) {
                    if (!log.isLoggable(Level.FINE)) break block5;
                    StringBuilder builder = new StringBuilder();
                    builder.append('\'');
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        if (builder.length() > 0) {
                            builder.append(',');
                        }
                        builder.append(entry.getKey());
                        builder.append('=');
                        builder.append(entry.getValue());
                    }
                    builder.append("' ");
                    builder.append(ex.toString());
                    log.log(Level.FINE, builder.toString(), ex);
                }
            }
        }
        return this._objectName;
    }

    protected abstract String getName();

    protected boolean isJ2EEServer() {
        return true;
    }

    protected boolean isJ2EEApplication() {
        return true;
    }

    protected String quote(String value) {
        if (value == null) {
            return "null";
        }
        if (value.length() == 0) {
            return "default";
        }
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': 
                case ',': 
                case ':': 
                case '=': 
                case '?': {
                    return ObjectName.quote(value);
                }
            }
        }
        return value;
    }

    protected ObjectName createObjectName(Hashtable<String, String> properties) throws MalformedObjectNameException {
        J2EEServer j2eeServer;
        WebApp webApp = WebApp.getLocal();
        if (webApp != null) {
            String contextPath = webApp.getContextPath();
            if (contextPath == null || contextPath.length() == 0) {
                contextPath = "/";
            }
            properties.put("WebModule", this.quote(contextPath));
        }
        Host host = Host.getLocal();
        if (this.isJ2EEApplication()) {
            J2EEApplication j2eeApplication = J2EEApplication.getLocal();
            if (j2eeApplication == null) {
                properties.put("J2EEApplication", this.quote("null"));
            } else {
                properties.put("J2EEApplication", this.quote(j2eeApplication.getName()));
            }
        }
        if (host != null) {
            properties.put("Host", this.quote(host.getName()));
        }
        if (this.isJ2EEServer() && (j2eeServer = J2EEServer.getLocal()) != null) {
            properties.put("J2EEServer", this.quote(j2eeServer.getName()));
        }
        String className = this.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        String j2eeType = className.substring(lastDot + 1);
        properties.put("j2eeType", this.quote(j2eeType));
        String name = this.getName();
        if (name == null) {
            name = "null";
        }
        properties.put("name", this.quote(name));
        return new ObjectName("j2ee", properties);
    }

    protected String[] queryObjectNames(String ... pattern) {
        TreeSet<String> objectNames = new TreeSet<String>();
        this.queryObjectNames(objectNames, pattern);
        return objectNames.toArray(new String[objectNames.size()]);
    }

    protected String[] queryObjectNamesSet(String[][] patterns) {
        TreeSet<String> objectNames = new TreeSet<String>();
        for (String[] pattern : patterns) {
            this.queryObjectNames(objectNames, pattern);
        }
        return objectNames.toArray(new String[objectNames.size()]);
    }

    private void queryObjectNames(Collection<String> objectNames, String[] pattern) {
        block6: {
            try {
                StringBuilder patternBuilder = new StringBuilder();
                patternBuilder.append("j2ee:");
                int length = pattern.length;
                for (int i = 0; i < length; ++i) {
                    if (i != 0) {
                        patternBuilder.append(',');
                    }
                    String key = pattern[i];
                    String value = pattern[++i];
                    patternBuilder.append(key);
                    patternBuilder.append('=');
                    patternBuilder.append(this.quote(value));
                }
                for (String contextKey : CONTEXT_KEYS) {
                    String value;
                    if (patternBuilder.indexOf(contextKey) >= 0 || (value = this._objectName.getKeyProperty(contextKey)) == null) continue;
                    patternBuilder.append(',');
                    patternBuilder.append(contextKey);
                    patternBuilder.append('=');
                    patternBuilder.append(this.quote(value));
                }
                patternBuilder.append(",*");
                ObjectName queryObjectName = new ObjectName(patternBuilder.toString());
                Set<ObjectName> matchingObjectNames = Jmx.getGlobalMBeanServer().queryNames(queryObjectName, null);
                for (ObjectName matchingObjectName : matchingObjectNames) {
                    objectNames.add(matchingObjectName.getCanonicalName());
                }
            }
            catch (Exception ex) {
                if (!log.isLoggable(Level.FINE)) break block6;
                log.log(Level.FINE, ex.toString(), ex);
            }
        }
    }

    public boolean isStateManageable() {
        return this instanceof StateManageable;
    }

    public boolean isStatisticsProvider() {
        return this instanceof StatisticsProvider;
    }

    public boolean isEventProvider() {
        return this instanceof EventProvider;
    }

    long getStartTime() {
        return this._startTime;
    }

    public static <T extends J2EEManagedObject> T register(T managedObject) {
        if (managedObject == null) {
            return null;
        }
        ObjectName objectName = null;
        try {
            objectName = managedObject.createObjectName();
            IntrospectionMBean mbean = new IntrospectionMBean(managedObject, managedObject.getClass(), true);
            return managedObject;
        }
        catch (Exception ex) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, managedObject.getClass() + " " + objectName + " " + ex.toString(), ex);
            }
            return null;
        }
    }

    public static void unregister(J2EEManagedObject managedObject) {
        block3: {
            if (managedObject == null) {
                return;
            }
            ObjectName objectName = null;
            try {
                objectName = managedObject.createObjectName();
            }
            catch (Throwable ex) {
                if (!log.isLoggable(Level.FINEST)) break block3;
                log.log(Level.FINEST, managedObject.getClass() + " " + objectName + " " + ex.toString(), ex);
            }
        }
    }
}

