/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.j2ee;

import com.caucho.management.j2ee.J2EEManagedObject;
import com.caucho.util.Alarm;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;

public class StatsSupport
implements Stats {
    private final J2EEManagedObject _j2eeManagedObject;

    public StatsSupport(J2EEManagedObject j2eeManagedObject) {
        this._j2eeManagedObject = j2eeManagedObject;
    }

    public String[] getStatisticNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (Method method : this.getClass().getMethods()) {
            String name;
            if (!Statistic.class.isAssignableFrom(method.getReturnType()) || !(name = method.getName()).startsWith("get")) continue;
            names.add(name.substring(3));
        }
        return names.toArray(new String[names.size()]);
    }

    public Statistic getStatistic(String name) {
        try {
            Method method = this.getClass().getMethod("get" + name, new Class[0]);
            return (Statistic)method.invoke((Object)this, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public Statistic[] getStatistics() {
        ArrayList<Statistic> statistics = new ArrayList<Statistic>();
        for (Method method : this.getClass().getMethods()) {
            if (!Statistic.class.isAssignableFrom(method.getReturnType())) continue;
            try {
                statistics.add((Statistic)method.invoke((Object)this, (Object[])null));
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
        return statistics.toArray(new Statistic[statistics.size()]);
    }

    class UnimplementedBoundedRangeStatistic
    extends BoundedRangeStatisticImpl {
        public UnimplementedBoundedRangeStatistic(String name) {
            super(name, -1L, -1L, -1L, -1L, -1L);
        }
    }

    class UnimplementedCountStatistic
    extends CountStatisticImpl {
        public UnimplementedCountStatistic(String name) {
            super(name, -1L);
        }
    }

    class UnimplementedBoundaryStatistic
    extends BoundaryStatisticImpl {
        public UnimplementedBoundaryStatistic(String name) {
            super(name, -1L, -1L);
        }
    }

    class UnimplementedRangeStatistic
    extends RangeStatisticImpl {
        public UnimplementedRangeStatistic(String name) {
            super(name, -1L, -1L, -1L);
        }
    }

    class UnimplementedTimeStatistic
    extends TimeStatisticImpl {
        public UnimplementedTimeStatistic(String name) {
            super(name, -1L, -1L, -1L, -1L);
        }
    }

    class BoundedRangeStatisticImpl
    extends StatisticSupport
    implements BoundedRangeStatistic {
        private long _upperBound;
        private long _lowerBound;
        private long _highWaterMark;
        private long _lowWaterMark;
        private long _current;

        public BoundedRangeStatisticImpl(String name, long upperBound, long lowerBound, long highWaterMark, long lowWaterMark, long current) {
            super(name);
            this._upperBound = upperBound;
            this._lowerBound = lowerBound;
            this._highWaterMark = highWaterMark;
            this._lowWaterMark = lowWaterMark;
            this._current = current;
        }

        public long getUpperBound() {
            return this._upperBound;
        }

        public long getLowerBound() {
            return this._lowerBound;
        }

        public long getHighWaterMark() {
            return this._highWaterMark;
        }

        public long getLowWaterMark() {
            return this._lowWaterMark;
        }

        public long getCurrent() {
            return this._current;
        }
    }

    class CountStatisticImpl
    extends StatisticSupport
    implements CountStatistic {
        private long _count;

        public CountStatisticImpl(String name, long count) {
            super(name);
            this._count = count;
        }

        public long getCount() {
            return this._count;
        }
    }

    class BoundaryStatisticImpl
    extends StatisticSupport
    implements BoundaryStatistic {
        private long _upperBound;
        private long _lowerBound;

        public BoundaryStatisticImpl(String name, long upperBound, long lowerBound) {
            super(name);
            this._upperBound = upperBound;
            this._lowerBound = lowerBound;
        }

        public long getUpperBound() {
            return this._upperBound;
        }

        public long getLowerBound() {
            return this._lowerBound;
        }
    }

    class RangeStatisticImpl
    extends StatisticSupport
    implements RangeStatistic {
        private long _highWaterMark;
        private long _lowWaterMark;
        private long _current;

        public RangeStatisticImpl(String name, long highWaterMark, long lowWaterMark, long current) {
            super(name);
            this._highWaterMark = highWaterMark;
            this._lowWaterMark = lowWaterMark;
            this._current = current;
        }

        public long getHighWaterMark() {
            return this._highWaterMark;
        }

        public long getLowWaterMark() {
            return this._lowWaterMark;
        }

        public long getCurrent() {
            return this._current;
        }
    }

    class TimeStatisticImpl
    extends StatisticSupport
    implements TimeStatistic {
        private long _count;
        private long _maxTime;
        private long _minTime;
        private long _totalTime;

        public TimeStatisticImpl(String name, long count, long maxTime, long minTime, long totalTime) {
            super(name);
            this._count = count;
            this._maxTime = maxTime;
            this._minTime = minTime;
            this._totalTime = totalTime;
        }

        public String getUnit() {
            return "MILLISECOND";
        }

        public long getCount() {
            return this._count;
        }

        public long getMaxTime() {
            return this._maxTime;
        }

        public long getMinTime() {
            return this._minTime;
        }

        public long getTotalTime() {
            return this._totalTime;
        }
    }

    class StatisticSupport
    implements Statistic {
        public final String _name;

        public StatisticSupport(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public String getUnit() {
            return "UNKNOWN";
        }

        public String getDescription() {
            return "";
        }

        public long getStartTime() {
            return StatsSupport.this._j2eeManagedObject.getStartTime();
        }

        public long getLastSampleTime() {
            return Alarm.getCurrentTime();
        }
    }
}

