/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.Units;
import com.caucho.management.server.ManagedObjectMXBean;

@Description(value="The protocol listening to an IP address.")
public interface PortMXBean
extends ManagedObjectMXBean {
    @Description(value="The configured ip address or host name used to bind the port")
    public String getAddress();

    @Description(value="The configured protocol for the port")
    public String getProtocolName();

    @Description(value="The configured port number used to bind the port")
    public int getPort();

    @Description(value="True if the port is using SSL encryption")
    public boolean isSSL();

    @Description(value="The minimum number of accept threads")
    public int getAcceptThreadMin();

    @Description(value="The maximum number of accept threads")
    public int getAcceptThreadMax();

    @Description(value="The operating system listen backlog")
    public int getAcceptListenBacklog();

    @Description(value="The configured maximum number of current connections")
    public int getConnectionMax();

    @Description(value="The configured maximum number of keepalive connections")
    public int getKeepaliveMax();

    @Description(value="The configured maximum number of select keepalive connections")
    public int getKeepaliveSelectMax();

    @Description(value="The maximum total time for keepalive connections")
    public long getKeepaliveConnectionTimeMax();

    @Description(value="The configured timeout for keepalive connections")
    public long getKeepaliveTimeout();

    @Description(value="The configured timeout for socket reads when waiting for data from a client")
    @Units(value="milliseconds")
    public long getSocketTimeout();

    @Description(value="The maximum suspend/comet time")
    @Units(value="milliseconds")
    public long getSuspendTimeMax();

    @Description(value="The current lifecycle state")
    public String getState();

    @Description(value="The current number of threads used by the port")
    public int getThreadCount();

    @Description(value="The current number of threads that are servicing requests")
    public int getThreadActiveCount();

    @Description(value="The current number of threads that are idle and waiting to service requests")
    public int getThreadIdleCount();

    @Description(value="The current number of connections that are in the keepalive state")
    public int getKeepaliveCount();

    @Description(value="The current number of connections that are in the keepalive state and are using a thread to maintain the connection")
    public int getKeepaliveThreadCount();

    @Description(value="The current number of connections that are in the keepalive state and are using select to maintain the connection")
    public int getKeepaliveSelectCount();

    @Description(value="The current number of comet sockets that are idle and waiting to service requests")
    public int getCometIdleCount();

    @Description(value="The total number of requests serviced by the server since it started")
    public long getRequestCountTotal();

    @Description(value="The total number of requests that have ended up in the keepalive state")
    public long getKeepaliveCountTotal();

    @Description(value="The total number of connections that have terminated with a client disconnect")
    public long getClientDisconnectCountTotal();

    @Description(value="The total duration in milliseconds that requests serviced by this service have taken")
    @Units(value="milliseconds")
    public long getRequestTimeTotal();

    @Description(value="The total number of bytes that requests serviced by this port have read")
    @Units(value="milliseconds")
    public long getReadBytesTotal();

    @Description(value="The total number of bytes that requests serviced by this port have written")
    @Units(value="milliseconds")
    public long getWriteBytesTotal();

    public void start();

    public void stop();
}

