/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.management.server;

import com.caucho.jmx.Description;
import com.caucho.jmx.Units;
import com.caucho.management.server.DeployControllerMXBean;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.SessionManagerMXBean;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Description(value="The web-app management interface")
public interface WebAppMXBean
extends DeployControllerMXBean {
    @Description(value="The web-app's host")
    public HostMXBean getHost();

    @Description(value="The web-app's session manager")
    public SessionManagerMXBean getSessionManager();

    @Description(value="The configured filesystem directory for the web-app")
    public String getRootDirectory();

    @Description(value="The configured context path that identifies the web-app in a url")
    public String getContextPath();

    @Description(value="The deployed version of the web-app")
    public String getVersion();

    @Description(value="The manifest attributes from the .war file")
    public Map<String, String> getManifestAttributes();

    @Description(value="The total number of 500 status errors")
    public long getStatus500CountTotal();

    @Description(value="The time of the last 500 status error")
    public Date getStatus500LastTime();

    @Description(value="The current number of requests served by the web-app")
    public int getRequestCount();

    @Description(value="The total number of requests served by the web-app since starting")
    public long getRequestCountTotal();

    @Description(value="The total real (wall-clock) time in milliseconds taken by requests served by the web-app")
    @Units(value="milliseconds")
    public long getRequestTimeTotal();

    @Description(value="The total number of bytes received in client requests")
    @Units(value="bytes")
    public long getRequestReadBytesTotal();

    @Description(value="The total number of bytes sent to clients")
    @Units(value="bytes")
    public long getRequestWriteBytesTotal();

    @Description(value="The total number of times a client has disconnected before a request completed")
    public long getClientDisconnectCountTotal();
}

