/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.ContextImpl;
import com.caucho.naming.EnvironmentModelRoot;
import com.caucho.util.L10N;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContextFactoryImpl
implements InitialContextFactory {
    private static Logger log = Logger.getLogger(InitialContextFactoryImpl.class.getName());
    private static L10N L = new L10N(InitialContextFactoryImpl.class);
    private static EnvironmentLocal<AbstractModel> _rootModel = new EnvironmentLocal();

    public static AbstractModel getContextModel() {
        return _rootModel.get();
    }

    public static void setContextModel(AbstractModel model) {
        _rootModel.set(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractModel createRoot() {
        EnvironmentLocal<AbstractModel> environmentLocal = _rootModel;
        synchronized (environmentLocal) {
            AbstractModel model = _rootModel.getLevel();
            if (model == null) {
                EnvironmentModelRoot root = EnvironmentModelRoot.create();
                model = root.get("");
                _rootModel.set(model);
                try {
                    AbstractModel javaComp = model.createSubcontext("java:comp");
                    AbstractModel java = model.createSubcontext("java:");
                    java.bind("comp", javaComp);
                }
                catch (NamingException e) {
                    throw new RuntimeException(e);
                }
            }
            return model;
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        AbstractModel model = InitialContextFactoryImpl.createRoot();
        return new ContextImpl(model, env);
    }
}

