/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.naming.ContextImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class QNameClassEnumeration
implements NamingEnumeration {
    private static final Logger log = Logger.getLogger(QNameClassEnumeration.class.getName());
    private static final L10N L = new L10N(QNameClassEnumeration.class);
    private ContextImpl _context;
    private List _list;
    private int _index;

    QNameClassEnumeration(ContextImpl context, List list) {
        this._context = context;
        this._list = list;
    }

    public boolean hasMore() {
        return this._index < this._list.size();
    }

    public Object next() throws NamingException {
        String name;
        Object obj;
        if ((obj = this._context.lookup(name = (String)this._list.get(this._index++))) != null) {
            return new NameClassPair(name, obj.getClass().getName());
        }
        return new NameClassPair(name, "java.lang.Object");
    }

    public boolean hasMoreElements() {
        return this.hasMore();
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public void close() {
    }

    public String toString() {
        CharBuffer cb = new CharBuffer();
        cb.append("QNameClassEnumeration[");
        ArrayList list = new ArrayList(this._list);
        Collections.sort(list);
        for (int i = 0; i < list.size(); ++i) {
            String name = (String)list.get(i);
            try {
                Object value = this._context.lookup(name);
                if (i != 0) {
                    cb.append(' ');
                }
                if (value != null) {
                    cb.append("{" + name + ", " + value.getClass() + "}");
                    continue;
                }
                cb.append("{" + name + ", " + null + "}");
                continue;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                cb.append(" {" + name + ", " + e + "}");
            }
        }
        cb.append("]");
        return cb.toString();
    }
}

