/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal;

import com.caucho.portal.PortletMediator;
import com.caucho.util.L10N;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletSupport
extends GenericPortlet {
    private static final L10N L = new L10N(PortletSupport.class);
    protected static final Logger log = Logger.getLogger(PortletSupport.class.getName());
    private static final Class[] _actionMethodParams = new Class[]{ActionRequest.class, ActionResponse.class};
    private static final Class[] _renderMethodParams = new Class[]{RenderRequest.class, RenderResponse.class};
    private Map<PortletMode, ActionProxy> _actionProxyCache = Collections.synchronizedMap(new HashMap());
    private Map<PortletMode, RenderProxy> _renderProxyCache = Collections.synchronizedMap(new HashMap());

    public void init() throws PortletException {
    }

    protected <T> T useBean(PortletRequest request, String name, Class<T> c) {
        return this.useBean(request, name, c, true);
    }

    protected <T> T useBean(PortletRequest request, String name, Class<T> c, boolean create) {
        Object bean = request.getAttribute(name);
        if (bean == null && create) {
            try {
                bean = c.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            request.setAttribute(name, bean);
        }
        return (T)bean;
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected static <S extends PortletMediator> S createMediator(RenderRequest request, RenderResponse response, Class<S> mediatorClass) throws PortletException {
        String namespace = response.getNamespace();
        return PortletSupport.createMediator(request, response, mediatorClass, namespace);
    }

    protected static <S extends PortletMediator> S createMediator(RenderRequest request, RenderResponse response, Class<S> mediatorClass, String namespace) throws PortletException {
        PortletMediator mediator;
        String attributeName = mediatorClass.getName();
        if (namespace != null) {
            attributeName = attributeName + namespace;
        }
        if ((mediator = (PortletMediator)request.getAttribute(attributeName)) == null) {
            try {
                mediator = (PortletMediator)mediatorClass.newInstance();
            }
            catch (Exception ex) {
                throw new PortletException((Throwable)ex);
            }
            request.setAttribute(attributeName, (Object)mediator);
        }
        mediator.setNamespace(namespace);
        mediator.setRequest((PortletRequest)request);
        mediator.setResponse((PortletResponse)response);
        return (S)mediator;
    }

    protected void prepare(PortletRequest request, PortletResponse response) throws PortletException {
    }

    protected void checkPrepare(PortletRequest request, PortletResponse response) throws PortletException {
        String attributeName = "__prepared__" + System.identityHashCode((Object)this);
        if (request.getAttribute(attributeName) == null) {
            request.setAttribute(attributeName, (Object)Boolean.TRUE);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(L.l("prepare for mode `{0}'", (Object)request.getPortletMode()));
            }
            this.prepare(request, response);
        }
    }

    private ActionProxy findActionProxy(ActionRequest request, ActionResponse response) {
        ActionProxy proxy;
        PortletMode mode;
        block6: {
            mode = request.getPortletMode();
            proxy = this._actionProxyCache.get(mode);
            if (proxy != null) {
                return proxy;
            }
            try {
                Method method;
                String methodName = new StringBuffer().append("action").append(Character.toUpperCase(mode.toString().charAt(0))).append(mode.toString().substring(1)).toString();
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "looking for method `" + methodName + "'");
                }
                if ((method = ((Object)((Object)this)).getClass().getMethod(methodName, _actionMethodParams)) != null) {
                    proxy = new ActionProxy(){

                        public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
                            try {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.log(Level.FINER, "invoking method " + method);
                                }
                                method.invoke((Object)PortletSupport.this, request, response);
                            }
                            catch (IllegalAccessException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                            catch (InvocationTargetException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                        }
                    };
                }
            }
            catch (NoSuchMethodException ex) {
                if (!log.isLoggable(Level.FINE)) break block6;
                log.log(Level.FINE, ex.toString(), ex);
            }
        }
        if (proxy != null) {
            this._actionProxyCache.put(mode, proxy);
        }
        return proxy;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        ActionProxy proxy;
        PortletMode mode = request.getPortletMode();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("processAction for mode `{0}'", (Object)mode));
        }
        if ((proxy = this.findActionProxy(request, response)) == null) {
            throw new PortletModeException(L.l("No action for mode `{0}'", (Object)mode), mode);
        }
        this.checkPrepare((PortletRequest)request, (PortletResponse)response);
        proxy.processAction(request, response);
    }

    private RenderProxy findRenderProxy(RenderRequest request, RenderResponse response) {
        RenderProxy proxy;
        PortletMode mode;
        block9: {
            mode = request.getPortletMode();
            proxy = this._renderProxyCache.get(mode);
            if (proxy != null) {
                return proxy;
            }
            Iterator<String> candidates = this.getViewCandidates(request, response);
            while (candidates.hasNext()) {
                String candidate = candidates.next();
                if (log.isLoggable(Level.FINER)) {
                    log.finer(L.l("view candidate `{0}'", (Object)candidate));
                }
                if (!new File(this.getPortletContext().getRealPath(candidate)).exists()) continue;
                final String target = candidate;
                proxy = new RenderProxy(){

                    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
                        PortletSupport.this.dispatchView(request, response, target);
                    }
                };
                break;
            }
            if (proxy != null) {
                this._renderProxyCache.put(mode, proxy);
                return proxy;
            }
            String methodName = new StringBuffer().append("do").append(Character.toUpperCase(mode.toString().charAt(0))).append(mode.toString().substring(1)).toString();
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "looking for method `" + methodName + "'");
            }
            try {
                final Method method = ((Object)((Object)this)).getClass().getMethod(methodName, _renderMethodParams);
                if (method != null) {
                    proxy = new RenderProxy(){

                        public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
                            try {
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, "invoking method " + method);
                                }
                                if (log.isLoggable(Level.FINER)) {
                                    log.log(Level.FINER, "with " + request + " " + response);
                                }
                                method.invoke((Object)PortletSupport.this, request, response);
                            }
                            catch (IllegalAccessException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                            catch (InvocationTargetException ex) {
                                throw new PortletException((Throwable)ex);
                            }
                        }
                    };
                }
            }
            catch (NoSuchMethodException ex) {
                if (!log.isLoggable(Level.FINEST)) break block9;
                log.log(Level.FINEST, ex.toString(), ex);
            }
        }
        if (proxy != null) {
            this._renderProxyCache.put(mode, proxy);
        }
        return proxy;
    }

    protected Iterator<String> getViewCandidates(RenderRequest request, RenderResponse response) {
        final String path = new StringBuffer().append(this.getPortletName()).append('/').append(request.getPortletMode().toString()).toString();
        return new Iterator<String>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 3;
            }

            @Override
            public String next() {
                switch (this.i++) {
                    case 0: {
                        return path + ".xtp";
                    }
                    case 1: {
                        return path + ".jsp";
                    }
                    case 2: {
                        return path + ".jspx";
                    }
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WindowState windowState = request.getWindowState();
        if (windowState.equals((Object)WindowState.MINIMIZED)) {
            return;
        }
        RenderProxy proxy = this.findRenderProxy(request, response);
        PortletMode mode = request.getPortletMode();
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("render for mode `{0}'", (Object)mode));
        }
        if (proxy == null) {
            throw new PortletModeException(L.l("No render for mode `{0}'", (Object)mode), mode);
        }
        this.checkPrepare((PortletRequest)request, (PortletResponse)response);
        if (response.getContentType() == null) {
            response.setContentType("text/html");
        }
        proxy.render(request, response);
    }

    protected void dispatchView(RenderRequest request, RenderResponse response, String path) throws PortletException, IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(L.l("dispatching view to `{0}'", (Object)path));
        }
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(path);
        dispatcher.include(request, response);
    }

    private static interface RenderProxy {
        public void render(RenderRequest var1, RenderResponse var2) throws PortletException, IOException;
    }

    private static interface ActionProxy {
        public void processAction(ActionRequest var1, ActionResponse var2) throws PortletException, IOException;
    }
}

