/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.alpharenderer;

import com.caucho.portal.alpharenderer.Location;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

public abstract class Menu {
    private static L10N L = new L10N(Menu.class);
    protected static final Logger log = Logger.getLogger(Menu.class.getName());
    private Location _location = Location.HEADER;
    private int _showMin = 1;

    public void setShowMin(int showMin) {
        this._showMin = showMin;
    }

    public void setLocation(String location) {
        this._location = Location.getLocation(location);
    }

    public Location getLocation() {
        return this._location;
    }

    public void init() {
    }

    public MenuRenderer createRenderer() {
        return new MenuRenderer(this);
    }

    protected abstract void menuStart(StringBuffer var1);

    protected abstract void menuItem(StringBuffer var1, int var2, String var3, String var4, String var5, boolean var6);

    protected abstract void menuEnd(StringBuffer var1, int var2);

    protected static void appendEscaped(StringBuffer buf, String string) {
        if (string == null) {
            buf.append(string);
            return;
        }
        block7: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&rsquo;");
                    continue block7;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
    }

    public static class MenuRenderer {
        private Menu _menu;
        private int _count;
        private StringBuffer _buf = new StringBuffer();

        MenuRenderer(Menu menu) {
            this._menu = menu;
        }

        public void add(String title, String shortDescription, String url, boolean isSelected) {
            if (this._count == 0) {
                this._menu.menuStart(this._buf);
            }
            ++this._count;
            this._menu.menuItem(this._buf, this._count, title, shortDescription, url, isSelected);
        }

        public void print(PrintWriter out) throws IOException {
            if (this._count >= this._menu._showMin) {
                int len = this._buf.length();
                this._menu.menuEnd(this._buf, this._count);
                out.print(this._buf);
                this._buf.setLength(len);
            }
        }

        public String toString() {
            String toString = "";
            if (this._count >= this._menu._showMin) {
                int len = this._buf.length();
                this._menu.menuEnd(this._buf, this._count);
                toString = this._buf.toString();
                this._buf.setLength(len);
            }
            return toString;
        }
    }
}

