/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.KeyLinkMap;
import com.caucho.portal.generic.NameLink;
import com.caucho.portal.generic.NameValuePair;
import com.caucho.portal.generic.StoreUpdateMap;
import com.caucho.portal.generic.UserAttributeStore;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserAttributeStore
implements UserAttributeStore {
    protected static String DELETE = "<delete>";
    private Map<String, String> _defaultMap;
    private Map<String, String> _nameLinkMap;
    private Map<String, String> _reverseNameLinkMap;

    protected abstract Map<String, String> load(PortletRequest var1) throws IOException;

    protected abstract void save(Map<String, String> var1, Map<String, String> var2) throws IOException;

    protected abstract void unload(Map<String, String> var1);

    public void addDefault(String name, String value) {
        if (this._defaultMap == null) {
            this._defaultMap = new LinkedHashMap<String, String>();
        }
        this._defaultMap.put(name, value);
    }

    public void addDefault(NameValuePair nameValuePair) {
        this.addDefault(nameValuePair.getName(), nameValuePair.getValue());
    }

    public void addNameLink(String name, String link) {
        if (this._nameLinkMap == null) {
            this._nameLinkMap = new HashMap<String, String>();
        }
        this._nameLinkMap.put(name, link);
    }

    public void addNameLink(NameLink nameLink) {
        this.addNameLink(nameLink.getName(), nameLink.getLink());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getUserAttributeMap(PortletRequest request, Set<String> names) throws IOException {
        Map<String, String> storeMap = this.load(request);
        StoreUpdateMap<String, String> map = new StoreUpdateMap<String, String>();
        if (this._nameLinkMap != null) {
            Map<String, String> map2 = this._nameLinkMap;
            synchronized (map2) {
                if (this._reverseNameLinkMap == null) {
                    this._reverseNameLinkMap = KeyLinkMap.getReverseKeyLinkMap(this._nameLinkMap);
                }
            }
        }
        map.start(this._nameLinkMap, this._reverseNameLinkMap, this._defaultMap, storeMap, names, DELETE);
        return map;
    }

    @Override
    public void finish(Map<String, String> userAttributeMap) throws IOException {
        StoreUpdateMap map = (StoreUpdateMap)userAttributeMap;
        Map<String, String> storeMap = map.getStoreMap();
        Map<String, String> updateMap = map.getUpdateMap();
        map.finish();
        if (updateMap != null) {
            this.save(storeMap, updateMap);
        }
        this.unload(storeMap);
    }
}

