/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.BufferFactory;
import com.caucho.portal.generic.BufferFactoryImpl;
import com.caucho.portal.generic.Cache;
import com.caucho.portal.generic.Portal;
import com.caucho.portal.generic.PreferencesStore;
import com.caucho.portal.generic.SessionPreferencesStore;
import com.caucho.portal.generic.UserAttributeStore;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPortal
implements Portal,
PortalContext {
    public static final Logger log = Logger.getLogger(GenericPortal.class.getName());
    private String _portalInfo = "GenericPortal/1.0";
    private String _reservedNamespace = "__";
    private Map<String, String> _propertyMap;
    private Set<WindowState> _supportedWindowStates;
    private Set<PortletMode> _supportedPortletModes;
    private Set<String> _userAttributeNames;
    private PreferencesStore _preferencesStore;
    private UserAttributeStore _userAttributeStore;
    private Cache _cache;
    private BufferFactory _bufferFactory;
    private boolean _isInit;

    @Override
    public PortalContext getPortalContext() {
        return this;
    }

    public void setPortalInfo(String portalInfo) {
        this._portalInfo = portalInfo;
    }

    public String getPortalInfo() {
        return this._portalInfo;
    }

    public void setReservedNamespace(String reservedNamespace) {
        this._reservedNamespace = reservedNamespace;
    }

    @Override
    public String getReservedNamespace() {
        return this._reservedNamespace;
    }

    public void setProperty(String name, String value) {
        if (this._propertyMap == null) {
            this._propertyMap = new LinkedHashMap<String, String>();
        }
        this._propertyMap.put(name, value);
    }

    public String getProperty(String name) {
        if (this._propertyMap == null) {
            return null;
        }
        return this._propertyMap.get(name);
    }

    public Enumeration getPropertyNames() {
        if (this._propertyMap == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._propertyMap.keySet());
    }

    public void setSupportedPortletModes(Set<PortletMode> portletModes) {
        this._supportedPortletModes = portletModes;
    }

    public Enumeration getSupportedPortletModes() {
        if (this._supportedPortletModes == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._supportedPortletModes);
    }

    @Override
    public boolean isPortletModeAllowed(PortletRequest portletRequest, PortletMode portletMode) {
        if (this._supportedPortletModes == null) {
            return true;
        }
        return this._supportedPortletModes.contains(portletMode);
    }

    public void setSupportedWindowStates(Set<WindowState> windowStates) {
        this._supportedWindowStates = windowStates;
    }

    public Enumeration getSupportedWindowStates() {
        if (this._supportedWindowStates == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._supportedWindowStates);
    }

    @Override
    public boolean isWindowStateAllowed(PortletRequest portletRequest, WindowState windowState) {
        if (this._supportedWindowStates == null) {
            return true;
        }
        return this._supportedWindowStates.contains(windowState);
    }

    public void setPreferencesStore(PreferencesStore preferencesStore) {
        this._preferencesStore = preferencesStore;
    }

    @Override
    public PreferencesStore getPreferencesStore() {
        if (this._preferencesStore == null) {
            this._preferencesStore = new SessionPreferencesStore();
        }
        return this._preferencesStore;
    }

    public void setUserAttributeNames(Set<String> userAttributeNames) {
        if (this._userAttributeNames != null) {
            throw new IllegalArgumentException("user-attribute-names already set");
        }
        this._userAttributeNames = userAttributeNames;
    }

    @Override
    public Set<String> getUserAttributeNames() {
        return this._userAttributeNames;
    }

    public void setUserAttributeStore(UserAttributeStore userAttributeStore) {
        this._userAttributeStore = userAttributeStore;
    }

    @Override
    public UserAttributeStore getUserAttributeStore() {
        return this._userAttributeStore;
    }

    public void setCache(Cache cache) {
        this._cache = cache;
        throw new UnsupportedOperationException("cache not currently implemented");
    }

    @Override
    public Cache getCache() {
        return this._cache;
    }

    public void setBufferFactory(BufferFactory bufferFactory) {
        this._bufferFactory = bufferFactory;
    }

    @Override
    public BufferFactory getBufferFactory() {
        if (this._bufferFactory == null) {
            this._bufferFactory = new BufferFactoryImpl();
        }
        return this._bufferFactory;
    }
}

