/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.Constraint;
import com.caucho.portal.generic.ConstraintFailureEvent;
import com.caucho.portal.generic.ExceptionEvent;
import com.caucho.portal.generic.GenericPortletPreferences;
import com.caucho.portal.generic.NameValuePair;
import com.caucho.portal.generic.PortletConnection;
import com.caucho.portal.generic.Renderer;
import com.caucho.portal.generic.ResourceBundleFactory;
import com.caucho.portal.generic.Window;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericWindow
implements Window,
PortletConfig {
    protected static final Logger log = Logger.getLogger(GenericWindow.class.getName());
    private String _namespace = "";
    private String _portletName;
    private Map<String, String> _initParamMap;
    private int _expirationCache;
    private boolean _isPrivate;
    private Renderer _renderer;
    private int _bufferSize;
    private Set<Locale> _supportedLocales;
    private GenericPortletPreferences _defaultPreferences;
    private ResourceBundleFactory _resourceBundleFactory;
    private String _errorPage;
    private PortletContext _portletContext;

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public void setPortletName(String portletName) {
        this._portletName = portletName;
    }

    public void addInitParam(String name, String value) {
        if (this._initParamMap == null) {
            this._initParamMap = new LinkedHashMap<String, String>();
        }
        this._initParamMap.put(name, value);
    }

    public void addInitParam(NameValuePair nameValuePair) {
        this.addInitParam(nameValuePair.getName(), nameValuePair.getValue());
    }

    public void setPortletPreferences(GenericPortletPreferences defaultPreferences) {
        this._defaultPreferences = defaultPreferences;
    }

    public void setExpirationCache(int expirationCache) {
        this._expirationCache = expirationCache;
    }

    public void setPrivate(boolean isPrivate) {
        this._isPrivate = isPrivate;
    }

    void addSupportedLocale(String locale) {
        String language = "";
        String country = "";
        String variant = "";
        String[] split = locale.split("_", 3);
        int len = split.length;
        if (len == 0) {
            split = locale.split("-", 3);
            len = split.length;
        }
        if (len == 0) {
            throw new IllegalArgumentException(locale);
        }
        language = split[0];
        if (len > 0) {
            country = split[1];
        }
        if (len > 1) {
            country = split[2];
        }
        if (this._supportedLocales == null) {
            this._supportedLocales = new LinkedHashSet<Locale>();
        }
        this._supportedLocales.add(new Locale(language, country, variant));
    }

    void addSupportedLocales(String locales) {
        String[] split = locales.split("\\s*,\\s*");
        for (int i = 0; i < split.length; ++i) {
            this.addSupportedLocale(split[i]);
        }
    }

    public void setResourceBundle(String name) {
        ResourceBundleFactory resourceBundleFactory = new ResourceBundleFactory();
        resourceBundleFactory.setName(name);
        this.setResourceBundleFactory(resourceBundleFactory);
    }

    public void setResourceBundleFactory(ResourceBundleFactory factory) {
        if (this._resourceBundleFactory != null) {
            throw new IllegalArgumentException("resource-bundle-factory already set");
        }
    }

    public void setRenderer(Renderer renderer) {
        this._renderer = renderer;
    }

    public void setRendererClass(String className) {
        this.setRenderer((Renderer)this.newInstance(Renderer.class, className));
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setErrorPage(String errorPage) {
        this._errorPage = errorPage;
        if (this._bufferSize == 0) {
            this._bufferSize = -1;
        }
    }

    public void init(PortletContext portletContext) throws PortletException {
        if (this._portletContext != null) {
            throw new IllegalStateException("portlet-context already set!");
        }
        this._portletContext = portletContext;
        if (this._portletName == null) {
            this._portletName = this._namespace == null ? "anonymous" : this._namespace;
        }
    }

    protected Object newInstance(Class targetClass, String className) throws IllegalArgumentException {
        Class<?> cl = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            cl = Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (cl == null) {
            throw new IllegalArgumentException("`" + className + "' is not a known class");
        }
        if (!targetClass.isAssignableFrom(cl)) {
            throw new IllegalArgumentException("'" + className + "' must implement " + targetClass.getName());
        }
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw new IllegalArgumentException("'" + className + "' must not be abstract.");
        }
        if (!Modifier.isPublic(cl.getModifiers())) {
            throw new IllegalArgumentException("'" + className + "' must be public.");
        }
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        Constructor<?> zeroArg = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            zeroArg = constructors[i];
            break;
        }
        if (zeroArg == null || !Modifier.isPublic(zeroArg.getModifiers())) {
            throw new IllegalArgumentException("'" + className + "' must have a public zero arg constructor");
        }
        Object obj = null;
        try {
            obj = cl.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("error instantiating `" + className + "': " + ex.toString(), ex);
        }
        return obj;
    }

    protected String getNamespace() {
        return this._namespace;
    }

    public PortletContext getPortletContext() {
        if (this._portletContext == null) {
            throw new IllegalStateException("missing init()?");
        }
        return this._portletContext;
    }

    @Override
    public PortletConfig getPortletConfig() {
        return this;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public String getInitParameter(String name) {
        if (this._initParamMap == null) {
            return null;
        }
        return this._initParamMap.get(name);
    }

    public Enumeration getInitParameterNames() {
        if (this._initParamMap == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._initParamMap.keySet());
    }

    @Override
    public int getExpirationCache() {
        return this._expirationCache;
    }

    @Override
    public boolean isPrivate() {
        return this._isPrivate;
    }

    @Override
    public boolean isWindowStateAllowed(PortletRequest request, WindowState windowState) {
        return true;
    }

    @Override
    public boolean isPortletModeAllowed(PortletRequest request, PortletMode portletMode) {
        return true;
    }

    @Override
    public Set<String> getSupportedContentTypes(PortletMode portletMode) {
        return null;
    }

    @Override
    public Set<Locale> getSupportedLocales() {
        return this._supportedLocales;
    }

    @Override
    public PortletPreferences getDefaultPreferences() {
        return this._defaultPreferences;
    }

    @Override
    public ArrayList<PreferencesValidator> getPreferencesValidators() {
        if (this._defaultPreferences != null) {
            return this._defaultPreferences.getPreferencesValidators();
        }
        return null;
    }

    @Override
    public Map<String, String> getRoleRefMap() {
        return null;
    }

    @Override
    public ArrayList<Constraint> getConstraints() {
        return null;
    }

    @Override
    public Renderer getRenderer() {
        return this._renderer;
    }

    @Override
    public PortletMode handlePortletModeFailure(PortletRequest request, PortletMode notAllowed) {
        return PortletMode.VIEW;
    }

    @Override
    public WindowState handleWindowStateFailure(PortletRequest request, WindowState notAllowed) {
        return WindowState.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleConstraintFailure(RenderRequest request, RenderResponse response, ConstraintFailureEvent event) {
        Object existingStatusCode;
        Object existingConstraintType;
        Object existingConstraint;
        block6: {
            if (this._errorPage == null) {
                return;
            }
            existingConstraint = request.getAttribute("com.caucho.portal.error.constraint");
            existingConstraintType = request.getAttribute("com.caucho.portal.error.constraint_type");
            existingStatusCode = request.getAttribute("com.caucho.portal.error.status_code");
            Constraint constraint = event.getConstraint();
            Class<?> constraintType = constraint.getClass();
            Integer statusCode = new Integer(event.getStatusCode());
            request.setAttribute("com.caucho.portal.error.constraint", (Object)constraint);
            request.setAttribute("com.caucho.portal.error.constraint_type", constraintType);
            request.setAttribute("com.caucho.portal.error.status_code", (Object)statusCode);
            try {
                if (this.handleErrorPage(request, response)) {
                    event.setHandled(false);
                } else {
                    event.setHandled(true);
                }
                Object var11_10 = null;
                if (existingConstraint != null) break block6;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (existingConstraint == null) {
                    request.removeAttribute("com.caucho.portal.error.constraint");
                    request.removeAttribute("com.caucho.portal.error.constraint_type");
                    request.removeAttribute("com.caucho.portal.error.status_code");
                    throw throwable;
                }
                request.setAttribute("com.caucho.portal.error.constraint", existingConstraint);
                request.setAttribute("com.caucho.portal.error.constraint_type", existingConstraintType);
                request.setAttribute("com.caucho.portal.error.status_code", existingStatusCode);
                throw throwable;
            }
            request.removeAttribute("com.caucho.portal.error.constraint");
            request.removeAttribute("com.caucho.portal.error.constraint_type");
            request.removeAttribute("com.caucho.portal.error.status_code");
            return;
        }
        request.setAttribute("com.caucho.portal.error.constraint", existingConstraint);
        request.setAttribute("com.caucho.portal.error.constraint_type", existingConstraintType);
        request.setAttribute("com.caucho.portal.error.status_code", existingStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleException(RenderRequest request, RenderResponse response, ExceptionEvent event) {
        Object existingMessage;
        Object existingExceptionType;
        Object existingException;
        block6: {
            if (this._errorPage == null) {
                return;
            }
            existingException = request.getAttribute("com.caucho.portal.error.exception");
            existingExceptionType = request.getAttribute("com.caucho.portal.error.exception_type");
            existingMessage = request.getAttribute("com.caucho.portal.error.message");
            Exception exception = event.getException();
            Class<?> exceptionType = exception.getClass();
            String message = exception.getMessage();
            request.setAttribute("com.caucho.portal.error.exception", (Object)exception);
            request.setAttribute("com.caucho.portal.error.exception_type", exceptionType);
            request.setAttribute("com.caucho.portal.error.message", (Object)message);
            try {
                if (this.handleErrorPage(request, response)) {
                    event.setHandled(false);
                } else {
                    event.setHandled(true);
                }
                Object var11_10 = null;
                if (existingException != null) break block6;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (existingException == null) {
                    request.removeAttribute("com.caucho.portal.error.exception");
                    request.removeAttribute("com.caucho.portal.error.exception_type");
                    request.removeAttribute("com.caucho.portal.error.message");
                    throw throwable;
                }
                request.setAttribute("com.caucho.portal.error.exception", existingException);
                request.setAttribute("com.caucho.portal.error.exception_type", existingExceptionType);
                request.setAttribute("com.caucho.portal.error.message", existingMessage);
                throw throwable;
            }
            request.removeAttribute("com.caucho.portal.error.exception");
            request.removeAttribute("com.caucho.portal.error.exception_type");
            request.removeAttribute("com.caucho.portal.error.message");
            return;
        }
        request.setAttribute("com.caucho.portal.error.exception", existingException);
        request.setAttribute("com.caucho.portal.error.exception_type", existingExceptionType);
        request.setAttribute("com.caucho.portal.error.message", existingMessage);
    }

    private boolean handleErrorPage(RenderRequest request, RenderResponse response) {
        try {
            PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(this._errorPage);
            dispatcher.include(request, response);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.toString(), ex);
            return false;
        }
        return true;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (this._resourceBundleFactory == null) {
            this._resourceBundleFactory = new ResourceBundleFactory();
        }
        return this._resourceBundleFactory.getResourceBundle(locale);
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    public abstract void processAction(PortletConnection var1) throws PortletException, IOException;

    public abstract void render(PortletConnection var1) throws PortletException, IOException;

    public void destroy() {
    }
}

