/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.Constraint;
import com.caucho.portal.generic.HttpPortletSession;
import com.caucho.portal.generic.HttpUtil;
import com.caucho.portal.generic.InvocationFactory;
import com.caucho.portal.generic.MapBasedInvocationFactory;
import com.caucho.portal.generic.Portal;
import com.caucho.portal.generic.PortletConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPortletConnection
extends PortletConnection {
    public static final String HTTP_SERVLET_REQUEST = "com.caucho.portal.generic.HttpServletRequest";
    public static final String HTTP_SERVLET_RESPONSE = "com.caucho.portal.generic.HttpServletResponse";
    private PortletContext _portletContext;
    private HttpServletRequest _httpRequest;
    private HttpServletResponse _httpResponse;
    private Object _oldHttpRequest;
    private Object _oldHttpResponse;
    private String _servletUrl;
    private MapBasedInvocationFactory _createdInvocationFactory;
    private HttpPortletSession _portletSession;
    private Set<Locale> _clientLocales;
    private Set<String> _clientCharacterEncodings;
    private Set<String> _clientContentTypes;
    private boolean _isLocaleEstablished;
    private boolean _isContentTypeEstablished;

    public static HttpServletRequest getHttpRequest(PortletRequest request) {
        return (HttpServletRequest)request.getAttribute(HTTP_SERVLET_REQUEST);
    }

    public static HttpServletResponse getHttpResponse(PortletRequest request) {
        return (HttpServletResponse)request.getAttribute(HTTP_SERVLET_RESPONSE);
    }

    public void start(Portal portal, PortletContext portletContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse, boolean useParameters) {
        if (this._createdInvocationFactory != null) {
            throw new IllegalStateException("missing finish?");
        }
        this._createdInvocationFactory = new MapBasedInvocationFactory();
        if (useParameters) {
            this._createdInvocationFactory.start(httpRequest.getParameterMap());
        } else {
            this._createdInvocationFactory.start(null);
        }
        this.start(portal, portletContext, httpRequest, httpResponse, this._createdInvocationFactory);
    }

    public void start(Portal portal, PortletContext portletContext, HttpServletRequest httpRequest, HttpServletResponse httpResponse, InvocationFactory invocationFactory) {
        super.start(portal, invocationFactory);
        this._portletContext = portletContext;
        this._httpRequest = httpRequest;
        this._httpResponse = httpResponse;
        this._oldHttpRequest = this._httpRequest.getAttribute(HTTP_SERVLET_REQUEST);
        if (this._oldHttpRequest != null) {
            this._oldHttpResponse = this._httpRequest.getAttribute(HTTP_SERVLET_RESPONSE);
        }
        this._httpRequest.setAttribute(HTTP_SERVLET_REQUEST, (Object)this._httpRequest);
        this._httpRequest.setAttribute(HTTP_SERVLET_RESPONSE, (Object)this._httpResponse);
        this._servletUrl = this.makeServletUrl(this._httpRequest);
    }

    protected String makeServletUrl(HttpServletRequest request) {
        String servletPath;
        String contextPath;
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int port = request.getServerPort();
        if (port == 80 && scheme.equals("http")) {
            port = -1;
        }
        if (port == 443 && scheme.equals("https")) {
            port = -1;
        }
        if ((contextPath = (String)request.getAttribute("javax.servlet.include.context_path")) == null) {
            contextPath = request.getContextPath();
            servletPath = request.getServletPath();
        } else {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        }
        StringBuffer buf = new StringBuffer(256);
        buf.append(scheme);
        buf.append("://");
        buf.append(serverName);
        if (port > 0) {
            buf.append(':');
            buf.append(port);
        }
        buf.append(contextPath);
        buf.append(servletPath);
        return buf.toString();
    }

    @Override
    public void finish() {
        int expirationCache = this.getExpirationCache();
        if (expirationCache == 0) {
            this._httpResponse.setHeader("Cache-Control", "no-cache,post-check=0,pre-check=0");
            this._httpResponse.setHeader("Pragma", "no-cache");
            this._httpResponse.setHeader("Expires", "Thu,01Dec199416:00:00GMT");
        } else if (this.isPrivate()) {
            this._httpResponse.setHeader("Cache-Control", "private,max-age=" + expirationCache);
        } else {
            this._httpResponse.setHeader("Cache-Control", "max-age=" + expirationCache);
        }
        this._isLocaleEstablished = false;
        this._isContentTypeEstablished = false;
        this._clientLocales = null;
        this._clientCharacterEncodings = null;
        this._clientContentTypes = null;
        PortletContext portletContext = this._portletContext;
        MapBasedInvocationFactory createdInvocationFactory = this._createdInvocationFactory;
        HttpServletRequest httpRequest = this._httpRequest;
        Object oldHttpRequest = this._oldHttpRequest;
        HttpServletResponse httpResponse = this._httpResponse;
        Object oldHttpResponse = this._oldHttpResponse;
        HttpPortletSession portletSession = this._portletSession;
        this._servletUrl = null;
        this._portletContext = null;
        this._portletSession = null;
        this._oldHttpRequest = null;
        this._oldHttpResponse = null;
        this._createdInvocationFactory = null;
        this._httpRequest = null;
        this._httpResponse = null;
        httpRequest.setAttribute(HTTP_SERVLET_RESPONSE, oldHttpResponse);
        httpRequest.setAttribute(HTTP_SERVLET_REQUEST, oldHttpRequest);
        super.finish();
        if (portletSession != null) {
            portletSession.finish();
        }
        if (createdInvocationFactory != null) {
            createdInvocationFactory.finish();
        }
    }

    public HttpServletRequest getHttpRequest() {
        return this._httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this._httpResponse;
    }

    @Override
    public Set<String> getClientContentTypes() {
        if (this._clientContentTypes != null) {
            return this._clientContentTypes;
        }
        this._clientContentTypes = HttpUtil.getHeaderElements(this.getProperty("Accept"));
        return this._clientContentTypes;
    }

    @Override
    public Set<Locale> getClientLocales() {
        if (this._clientLocales != null) {
            return this._clientLocales;
        }
        this._clientLocales = new LinkedHashSet<Locale>();
        this._clientLocales.add(this._httpRequest.getLocale());
        Enumeration en = this._httpRequest.getLocales();
        while (en.hasMoreElements()) {
            this._clientLocales.add((Locale)en.nextElement());
        }
        return this._clientLocales;
    }

    @Override
    public Set<String> getClientCharacterEncodings() {
        if (this._clientCharacterEncodings != null) {
            return this._clientCharacterEncodings;
        }
        this._clientCharacterEncodings = HttpUtil.getHeaderElements(this.getProperty("Accept-Charset"));
        return this._clientCharacterEncodings;
    }

    @Override
    public String resolveURL(String url) {
        StringBuffer buf = new StringBuffer(256);
        this.appendUrlPrefix(this._httpRequest, buf);
        buf.append(url);
        return buf.toString();
    }

    @Override
    public String resolveURL(String url, boolean secure) throws PortletSecurityException {
        if (!secure) {
            return this.resolveURL(url);
        }
        StringBuffer buf = new StringBuffer(256);
        this.appendSecureUrlPrefix(this._httpRequest, buf);
        buf.append(url);
        return buf.toString();
    }

    private String appendUrlPrefix(HttpServletRequest request, StringBuffer buf) {
        buf.append(this._servletUrl);
        return buf.toString();
    }

    private String appendSecureUrlPrefix(HttpServletRequest request, StringBuffer buf) throws PortletSecurityException {
        if (request.isSecure()) {
            return this.appendUrlPrefix(request, buf);
        }
        throw new PortletSecurityException("cannot make url secure");
    }

    @Override
    public boolean handleConstraintFailure(Constraint constraint, int failureCode) throws IOException {
        if (failureCode == 403) {
            this._httpResponse.sendError(403);
        } else {
            this._httpResponse.sendError(503);
        }
        return true;
    }

    @Override
    public boolean handleException(Exception exception) {
        return false;
    }

    @Override
    public boolean canGuaranteeIntegrity() {
        return this.isSecure();
    }

    @Override
    public boolean canGuaranteeConfidentiality() {
        return this.isSecure();
    }

    @Override
    public Object getAttribute(String name) {
        return this._httpRequest.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object o) {
        this._httpRequest.setAttribute(name, o);
    }

    @Override
    public void removeAttribute(String name) {
        this._httpRequest.removeAttribute(name);
    }

    @Override
    public Enumeration getAttributeNames() {
        return this._httpRequest.getAttributeNames();
    }

    @Override
    public PortletSession getPortletSession(boolean create) {
        if (this._portletSession != null) {
            return this._portletSession;
        }
        HttpSession httpSession = this._httpRequest.getSession(create);
        if (httpSession != null) {
            this._portletSession = new HttpPortletSession();
            this._portletSession.start(this._portletContext, httpSession);
        }
        return this._portletSession;
    }

    @Override
    public String getScheme() {
        return this._httpRequest.getScheme();
    }

    @Override
    public String getServerName() {
        return this._httpRequest.getServerName();
    }

    @Override
    public int getServerPort() {
        return this._httpRequest.getServerPort();
    }

    @Override
    public String getContextPath() {
        return this._httpRequest.getContextPath();
    }

    @Override
    public String getAuthType() {
        String authType = this._httpRequest.getAuthType();
        if (authType == null) {
            return null;
        }
        if (authType == "BASIC") {
            return "BASIC";
        }
        if (authType == "DIGEST") {
            return "DIGEST";
        }
        if (authType == "FORM") {
            return "FORM";
        }
        if (authType.equals("BASIC")) {
            return "BASIC";
        }
        if (authType.equals("CLIENT_CERT")) {
            return "CLIENT_CERT";
        }
        if (authType.equals("DIGEST")) {
            return "DIGEST";
        }
        if (authType.equals("FORM")) {
            return "FORM";
        }
        return authType;
    }

    @Override
    public boolean isSecure() {
        return this._httpRequest.isSecure();
    }

    @Override
    public String getRequestedSessionId() {
        return this._httpRequest.getRequestedSessionId();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this._httpRequest.isRequestedSessionIdValid();
    }

    @Override
    public String getRemoteUser() {
        return this._httpRequest.getRemoteUser();
    }

    @Override
    public Principal getUserPrincipal() {
        return this._httpRequest.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this._httpRequest.isUserInRole(role);
    }

    @Override
    public String getProperty(String propertyName) {
        return this._httpRequest.getHeader(propertyName);
    }

    @Override
    public Enumeration getProperties(String propertyName) {
        return this._httpRequest.getHeaders(propertyName);
    }

    @Override
    public Enumeration getPropertyNames() {
        return this._httpRequest.getHeaderNames();
    }

    @Override
    public String getSubmitContentType() {
        return this._httpRequest.getContentType();
    }

    @Override
    public int getSubmitContentLength() {
        return this._httpRequest.getContentLength();
    }

    @Override
    public InputStream getSubmitInputStream() throws IOException {
        return this._httpRequest.getInputStream();
    }

    @Override
    public void setSubmitCharacterEncoding(String enc) throws UnsupportedEncodingException, IllegalStateException {
        this._httpRequest.setCharacterEncoding(enc);
    }

    @Override
    public String getSubmitCharacterEncoding() {
        return this._httpRequest.getCharacterEncoding();
    }

    @Override
    public BufferedReader getSubmitReader() throws UnsupportedEncodingException, IOException {
        return this._httpRequest.getReader();
    }

    @Override
    public String encodeURL(String location) {
        int slash = location.indexOf(47);
        int colon = location.indexOf(58);
        if (colon == -1 || slash < colon) {
            String scheme = this._httpRequest.getScheme();
            String serverName = this._httpRequest.getServerName();
            int port = this._httpRequest.getServerPort();
            if (port == 80 && scheme.equals("http")) {
                port = -1;
            }
            if (port == 443 && scheme.equals("https")) {
                port = -1;
            }
            String contextPath = (String)this._httpRequest.getAttribute("javax.servlet.include.context_path");
            String servletPath = null;
            if (contextPath == null) {
                contextPath = this._httpRequest.getContextPath();
                servletPath = this._httpRequest.getServletPath();
            }
            StringBuffer buf = new StringBuffer();
            buf.append(scheme);
            buf.append("://");
            buf.append(serverName);
            if (port > 0) {
                buf.append(':');
                buf.append(port);
            }
            buf.append(contextPath);
            if (slash != 0) {
                if (servletPath == null) {
                    servletPath = (String)this._httpRequest.getAttribute("javax.servlet.include.servlet_path");
                }
                buf.append(servletPath);
                buf.append('/');
                buf.append(location);
            } else {
                buf.append(location);
            }
            location = buf.toString();
        }
        return this._httpResponse.encodeURL(location);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        String url = this._httpResponse.encodeRedirectURL(location);
        this._httpResponse.sendRedirect(url);
    }

    @Override
    public void setProperty(String name, String value) {
        this._httpResponse.setHeader(name, value);
    }

    @Override
    public void addProperty(String name, String value) {
        this._httpResponse.addHeader(name, value);
    }

    @Override
    public void setContentType(String contentType) {
        this._isContentTypeEstablished = true;
        this._httpResponse.setContentType(contentType);
    }

    @Override
    public String getContentType() {
        if (this._isContentTypeEstablished) {
            return this._httpResponse.getContentType();
        }
        return null;
    }

    @Override
    public void setLocale(Locale locale) {
        this._isLocaleEstablished = true;
        this._httpResponse.setLocale(locale);
    }

    @Override
    public Locale getLocale() {
        if (this._isLocaleEstablished) {
            return this._httpResponse.getLocale();
        }
        return null;
    }

    @Override
    public void setBufferSize(int size) {
        this._httpResponse.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return this._httpResponse.getBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        this._httpResponse.flushBuffer();
    }

    @Override
    public void resetBuffer() {
        this._httpResponse.resetBuffer();
    }

    @Override
    public void reset() {
        this._httpResponse.reset();
    }

    @Override
    public boolean isCommitted() {
        return this._httpResponse.isCommitted();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this._httpResponse.getOutputStream();
    }

    @Override
    public String getCharacterEncoding() {
        return this._httpResponse.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        this._httpResponse.setCharacterEncoding(enc);
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this._httpResponse.getWriter();
    }
}

