/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;

public class HttpPortletSession
implements PortletSession {
    protected static final Logger log = Logger.getLogger(HttpPortletSession.class.getName());
    public final String PORTLET_SCOPE_PREFIX = "javax.portlet.p.";
    public final String PORTLET_SCOPE_RESERVED_PREFIX = "javax.portlet.p.javax.portlet.";
    private PortletContext _portletContext;
    private HttpSession _httpSession;

    public void start(PortletContext portletContext, HttpSession httpSession) {
        this._portletContext = portletContext;
        this._httpSession = httpSession;
        if (this._httpSession != null) {
            Enumeration en = this._httpSession.getAttributeNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                Object value = this._httpSession.getAttribute(name);
            }
        }
    }

    public void finish() {
        this._httpSession = null;
        this._portletContext = null;
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public HttpSession getHttpSession() {
        return this._httpSession;
    }

    private String scopedName(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (scope != 1) {
            if (scope == 2) {
                StringBuffer sb = new StringBuffer("javax.portlet.p.");
                sb.append(name);
                name = sb.toString();
            } else {
                throw new IllegalArgumentException("invalid scope `" + scope + "'");
            }
        }
        return name;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        return this._httpSession.getAttribute(this.scopedName(name, scope));
    }

    public Enumeration getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration getAttributeNames(int scope) {
        if (scope == 1) {
            return this._httpSession.getAttributeNames();
        }
        if (scope == 2) {
            return new Enumeration(){
                private Enumeration _e;
                private Object _next;
                {
                    this._e = HttpPortletSession.this._httpSession.getAttributeNames();
                }

                public boolean hasMoreElements() {
                    this.nextIfNeeded();
                    return this._next != null;
                }

                public Object nextElement() {
                    this.nextIfNeeded();
                    if (this._next == null) {
                        throw new NoSuchElementException();
                    }
                    String result = (String)this._next;
                    result = result.substring("javax.portlet.p.".length());
                    this._next = null;
                    return result;
                }

                private void nextIfNeeded() {
                    if (this._next == null) {
                        while (this._e.hasMoreElements()) {
                            String e = (String)this._e.nextElement();
                            if (!e.startsWith("javax.portlet.p.") || e.startsWith("javax.portlet.p.javax.portlet.")) continue;
                            this._next = e;
                            break;
                        }
                    }
                }
            };
        }
        throw new IllegalArgumentException("invalid scope `" + scope + "'");
    }

    public long getCreationTime() {
        return this._httpSession.getCreationTime();
    }

    public String getId() {
        return this._httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this._httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this._httpSession.getMaxInactiveInterval();
    }

    public void invalidate() {
        this._httpSession.invalidate();
    }

    public boolean isNew() {
        return this._httpSession.isNew();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        this._httpSession.removeAttribute(this.scopedName(name, scope));
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        this._httpSession.setAttribute(this.scopedName(name, scope), value);
    }

    public void setMaxInactiveInterval(int interval) {
        this._httpSession.setMaxInactiveInterval(interval);
    }
}

