/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtil {
    private static Object _bufferLock = new Integer(1);
    private static StringBuffer _buffer = new StringBuffer(256);
    private static Pattern _headerPattern = Pattern.compile("s/[,;\\s]*([^;,\\s]+)[^,]*//");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer getStringBuffer() {
        StringBuffer buf;
        Object object = _bufferLock;
        synchronized (object) {
            buf = _buffer;
            _buffer = null;
        }
        if (buf == null) {
            buf = new StringBuffer(256);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseStringBuffer(StringBuffer buf) {
        if (buf.capacity() <= 1024) {
            Object object = _bufferLock;
            synchronized (object) {
                if (_buffer == null || _buffer.capacity() < buf.capacity()) {
                    buf.setLength(0);
                    _buffer = buf;
                }
            }
        }
    }

    public static Set<String> getHeaderElements(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        Matcher matcher = _headerPattern.matcher(headerValue);
        Set resultSet = null;
        while (matcher.find()) {
            if (resultSet == null) {
                return new LinkedHashSet<String>();
            }
            resultSet.add(matcher.group(1));
        }
        return resultSet;
    }

    public static String getFirstHeaderElement(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        Matcher matcher = _headerPattern.matcher(headerValue);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractParameters(Map<String, String[]> map, String url) {
        int beginIndex = url.indexOf(63);
        if (beginIndex == -1) {
            return url;
        }
        return HttpUtil.extractParameters(map, url, beginIndex + 1);
    }

    public static String extractParameters(Map<String, String[]> map, String url, int beginIndex) {
        int endIndex;
        if (beginIndex == -1) {
            return url;
        }
        String result = url.substring(0, beginIndex);
        StringBuffer buf = HttpUtil.getStringBuffer();
        if (buf == null) {
            buf = new StringBuffer(256);
        }
        String name = null;
        String value = null;
        int len = url.length();
        do {
            if ((endIndex = url.indexOf(61, beginIndex)) == -1) {
                endIndex = len;
            } else {
                buf.setLength(0);
                HttpUtil.decode(url, beginIndex, endIndex, buf);
                name = buf.toString();
            }
            if (endIndex == len) {
                value = "";
            } else {
                beginIndex = endIndex + 1;
                if ((endIndex = url.indexOf(38, beginIndex)) == -1) {
                    endIndex = len;
                }
                buf.setLength(0);
                HttpUtil.decode(url, beginIndex, endIndex, buf);
                value = buf.toString();
            }
            String[] values = map.get(name);
            if (values == null) {
                map.put(name, new String[]{value});
                continue;
            }
            int valuesLen = values.length;
            String[] newValues = new String[valuesLen + 1];
            for (int valuesIndex = 0; valuesIndex < valuesLen; ++valuesIndex) {
                newValues[valuesIndex] = values[valuesIndex];
            }
            newValues[valuesLen] = value;
            map.put(name, newValues);
        } while ((beginIndex = endIndex == len ? -1 : url.indexOf(38, endIndex) + 1) > 0);
        HttpUtil.releaseStringBuffer(buf);
        return result;
    }

    public static String encode(String source) {
        StringBuffer dest = HttpUtil.getStringBuffer();
        HttpUtil.encodeUri((CharSequence)source, 0, source.length(), dest);
        String result = dest.toString();
        HttpUtil.releaseStringBuffer(dest);
        return result;
    }

    public static void encode(String source, StringBuffer dest) {
        HttpUtil.encodeUri((CharSequence)source, 0, source.length(), dest);
    }

    public static void encode(String source, int beginIndex, int endIndex, StringBuffer dest) {
        HttpUtil.encodeUri((CharSequence)source, beginIndex, endIndex, dest);
    }

    public static void encode(StringBuffer source, int beginIndex, int endIndex, StringBuffer dest) {
        HttpUtil.encodeUri((CharSequence)source, beginIndex, endIndex, dest);
    }

    public static void encodeUri(CharSequence source, int beginIndex, int endIndex, StringBuffer dest) {
        for (int i = beginIndex; i < endIndex; ++i) {
            char ch = source.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '*') {
                dest.append(ch);
                continue;
            }
            if (ch == ' ') {
                dest.append('+');
                continue;
            }
            if (ch <= '\u00ff') {
                dest.append('%');
                dest.append(HttpUtil.encodeHex(ch >> 4));
                dest.append(HttpUtil.encodeHex(ch));
                continue;
            }
            dest.append('%');
            dest.append('u');
            dest.append(HttpUtil.encodeHex(ch >> 12));
            dest.append(HttpUtil.encodeHex(ch >> 8));
            dest.append(HttpUtil.encodeHex(ch >> 4));
            dest.append(HttpUtil.encodeHex(ch));
        }
    }

    public static void encode(String source, Writer dest) throws IOException {
        HttpUtil.encodeUri((CharSequence)source, 0, source.length(), dest);
    }

    public static void encode(String source, int beginIndex, int endIndex, Writer dest) throws IOException {
        HttpUtil.encodeUri((CharSequence)source, beginIndex, endIndex, dest);
    }

    public static void encode(StringBuffer source, int beginIndex, int endIndex, Writer dest) throws IOException {
        HttpUtil.encodeUri((CharSequence)source, beginIndex, endIndex, dest);
    }

    public static void encodeUri(CharSequence source, int beginIndex, int endIndex, Writer dest) throws IOException {
        for (int i = beginIndex; i < endIndex; ++i) {
            char ch = source.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '*') {
                dest.write(ch);
                continue;
            }
            if (ch == ' ') {
                dest.write(43);
                continue;
            }
            if (ch <= '\u00ff') {
                dest.write(37);
                dest.write(HttpUtil.encodeHex(ch >> 4));
                dest.write(HttpUtil.encodeHex(ch));
                continue;
            }
            dest.write(37);
            dest.write(117);
            dest.write(HttpUtil.encodeHex(ch >> 12));
            dest.write(HttpUtil.encodeHex(ch >> 8));
            dest.write(HttpUtil.encodeHex(ch >> 4));
            dest.write(HttpUtil.encodeHex(ch));
        }
    }

    public static String decode(String source) {
        StringBuffer dest = HttpUtil.getStringBuffer();
        HttpUtil.decodeUri(source, 0, source.length(), dest);
        String result = dest.toString();
        HttpUtil.releaseStringBuffer(dest);
        return result;
    }

    public static void decode(String source, StringBuffer dest) {
        HttpUtil.decodeUri(source, 0, source.length(), dest);
    }

    public static void decode(String source, int beginIndex, int endIndex, StringBuffer dest) {
        HttpUtil.decodeUri(source, beginIndex, endIndex, dest);
    }

    public static void decode(StringBuffer source, int beginIndex, int endIndex, StringBuffer dest) {
        HttpUtil.decodeUri(source, beginIndex, endIndex, dest);
    }

    private static void decodeUri(CharSequence source, int beginIndex, int endIndex, StringBuffer dest) {
        int i = beginIndex;
        while (i < endIndex) {
            char ch = source.charAt(i);
            if (ch == '%') {
                i = HttpUtil.scanUriEscape(source, i + 1, endIndex, dest);
                continue;
            }
            if (ch == '+') {
                dest.append(' ');
                ++i;
                continue;
            }
            dest.append(ch);
            ++i;
        }
    }

    private static int scanUriEscape(CharSequence source, int i, int len, StringBuffer dest) {
        int ch1;
        int n = ch1 = i < len ? source.charAt(i++) & 0xFF : -1;
        if (ch1 == 117) {
            ch1 = i < len ? source.charAt(i++) & 0xFF : -1;
            int ch2 = i < len ? source.charAt(i++) & 0xFF : -1;
            int ch3 = i < len ? source.charAt(i++) & 0xFF : -1;
            int ch4 = i < len ? source.charAt(i++) & 0xFF : -1;
            dest.append((char)((HttpUtil.decodeHex(ch1) << 12) + (HttpUtil.decodeHex(ch2) << 8) + (HttpUtil.decodeHex(ch3) << 4) + HttpUtil.decodeHex(ch4)));
        } else {
            int ch2 = i < len ? source.charAt(i++) & 0xFF : -1;
            int b = (HttpUtil.decodeHex(ch1) << 4) + HttpUtil.decodeHex(ch2);
            dest.append((char)b);
        }
        return i;
    }

    static char encodeHex(int ch) {
        if ((ch &= 0xF) < 10) {
            return (char)(ch + 48);
        }
        return (char)(ch + 97 - 10);
    }

    private static int decodeHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }
}

