/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.KeyLinkMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreUpdateMap<K, V>
implements Map<K, V> {
    protected static final Logger log = Logger.getLogger(StoreUpdateMap.class.getName());
    private Map<K, K> _nameLinkMap;
    private Map<K, K> _reverseNameLinkMap;
    private Map<K, V> _storeMapUnlinked;
    private Map<K, V> _storeMap;
    private Map<K, V> _defaultMap;
    private Set<K> _names;
    private V _deletedValue;
    private Set<K> _keySet;
    private boolean _keySetModifiable;
    private Map<K, V> _updateMapUnlinked;
    private Map<K, V> _updateMap;

    void start(Map<K, K> nameLinkMap, Map<K, K> reverseNameLinkMap, Map<K, V> defaultMap, Map<K, V> storeMap, Set<K> names, V deletedValue) {
        if (this._defaultMap != null || this._storeMap != null) {
            throw new IllegalStateException("missing finish()?");
        }
        this._nameLinkMap = nameLinkMap;
        this._reverseNameLinkMap = reverseNameLinkMap;
        if (nameLinkMap != null) {
            this._defaultMap = new KeyLinkMap<K, V>(defaultMap, this._nameLinkMap, this._reverseNameLinkMap);
            this._storeMapUnlinked = storeMap;
            this._storeMap = new KeyLinkMap<K, V>(storeMap, this._nameLinkMap, this._reverseNameLinkMap);
        } else {
            this._defaultMap = defaultMap;
            this._storeMapUnlinked = storeMap;
            this._storeMap = storeMap;
        }
        this._names = names;
        this._deletedValue = deletedValue;
    }

    void finish() {
        this._updateMap = null;
        this._updateMapUnlinked = null;
        this._keySet = null;
        this._keySetModifiable = false;
        this._nameLinkMap = null;
        this._defaultMap = null;
        this._storeMapUnlinked = null;
        this._storeMap = null;
        this._names = null;
    }

    Map<K, V> getStoreMap() {
        return this._storeMapUnlinked;
    }

    Map<K, V> getUpdateMap() {
        return this._updateMapUnlinked;
    }

    private Set<K> getKeySet(boolean modifiable) {
        if (!modifiable) {
            if (this._keySet != null) {
                return this._keySet;
            }
            while (true) {
                Set<K> keySet = this._names;
                if (this._defaultMap != null) {
                    if (keySet != null) break;
                    keySet = this._defaultMap.keySet();
                }
                if (this._storeMap != null) {
                    if (keySet != null) break;
                    keySet = this._storeMap.keySet();
                }
                if (this._updateMap == null) continue;
                if (keySet != null) break;
                keySet = this._updateMap.keySet();
            }
        }
        if (this._keySetModifiable) {
            return this._keySet;
        }
        this._keySet = new HashSet<K>();
        this._keySetModifiable = true;
        if (this._names != null) {
            for (K key : this._names) {
                if ((this._storeMap == null || !this._storeMap.containsKey(key)) && (this._defaultMap == null || !this._defaultMap.containsKey(key))) continue;
                this._keySet.add(key);
            }
        } else {
            if (this._defaultMap != null) {
                this._keySet.addAll(this._defaultMap.keySet());
            }
            if (this._storeMap != null) {
                this._keySet.addAll(this._storeMap.keySet());
            }
        }
        return this._keySet;
    }

    @Override
    public int size() {
        return this.getKeySet(false).size();
    }

    @Override
    public boolean isEmpty() {
        return this.getKeySet(false).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getKeySet(false).contains(key);
    }

    @Override
    public V get(Object key) {
        if (!this.getKeySet(false).contains(key)) {
            return null;
        }
        if (this._updateMap != null && this._updateMap.containsKey(key)) {
            V v = this._updateMap.get(key);
            return v;
        }
        if (this._storeMap != null && this._storeMap.containsKey(key)) {
            return this._storeMap.get(key);
        }
        if (this._defaultMap != null) {
            return this._defaultMap.get(key);
        }
        return null;
    }

    @Override
    public Set<K> keySet() {
        return this.getKeySet(false);
    }

    @Override
    public boolean containsValue(Object v) {
        for (K key : this._keySet) {
            V value = this.get(key);
            if (!(value == null ? v == null : value.equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        LinkedList<V> values = new LinkedList<V>();
        for (K key : this.getKeySet(false)) {
            V value = this.get(key);
            values.add(value);
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (K key : this.getKeySet(false)) {
            V value = this.get(key);
            map.put(key, value);
        }
        return map.entrySet();
    }

    private void makeUpdateMap() {
        if (this._updateMap == null) {
            this._updateMapUnlinked = new LinkedHashMap();
            this._updateMap = this._nameLinkMap != null ? new KeyLinkMap<K, V>(this._updateMapUnlinked, this._nameLinkMap, this._reverseNameLinkMap) : this._updateMapUnlinked;
        }
    }

    @Override
    public V put(K key, V value) {
        V oldValue;
        if (this._names != null && !this._names.contains(key)) {
            throw new IllegalArgumentException("attribute name `" + key + "' not allowed");
        }
        this.makeUpdateMap();
        Set<K> keySet = this.getKeySet(false);
        if (!keySet.contains(key)) {
            if (keySet != this._updateMap.keySet()) {
                keySet = this.getKeySet(true);
            }
            if (value != this._deletedValue) {
                keySet.add(key);
            }
        }
        if ((oldValue = this._updateMap.put(key, value)) == this._deletedValue) {
            oldValue = null;
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> srcMap) {
        for (Map.Entry<K, V> entry : srcMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Set<K> keySet = this.getKeySet(false);
        V oldValue = null;
        if (keySet.contains(key)) {
            oldValue = this.put(key, this._deletedValue);
            this.getKeySet(true).remove(key);
        }
        return oldValue;
    }

    @Override
    public void clear() {
        Iterator<K> iter = this.getKeySet(true).iterator();
        while (iter.hasNext()) {
            K key = iter.next();
            if (this._storeMap != null && this._storeMap.containsKey(key)) {
                this.put(key, this._deletedValue);
            } else if (this._updateMap != null) {
                this._updateMap.remove(key);
            }
            iter.remove();
        }
    }
}

