/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic.context;

import com.caucho.portal.generic.FastPrintWriter;
import com.caucho.portal.generic.context.ResponseHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AbstractResponseHandler
implements ResponseHandler {
    protected static final Logger log = Logger.getLogger(AbstractResponseHandler.class.getName());
    private PrintWriter _internalWriter;
    private OutputStream _internalOutputStream;
    private ResponseHandler _successor;
    protected PrintWriter _writer;
    protected OutputStream _outputStream;
    protected PrintWriter _writerOut;
    protected OutputStream _outputStreamOut;
    private Exception _errorCause;

    public AbstractResponseHandler() {
    }

    public AbstractResponseHandler(ResponseHandler successor) {
        this.open(successor);
    }

    public void open(ResponseHandler successor) {
        if (this._successor != null) {
            throw new IllegalStateException("already open");
        }
        this._successor = successor;
    }

    public void finish() throws IOException {
        Exception errorCause = this._errorCause;
        this._writerOut = null;
        this._outputStreamOut = null;
        this._successor = null;
        this._errorCause = null;
        if (errorCause != null) {
            if (errorCause instanceof IOException) {
                throw (IOException)errorCause;
            }
            IOException ex = new IOException();
            ex.initCause(errorCause);
            throw ex;
        }
    }

    public ResponseHandler getSuccessor() {
        return this._successor;
    }

    public void setProperty(String name, String value) {
        this._successor.setProperty(name, value);
    }

    public void addProperty(String name, String value) {
        this._successor.addProperty(name, value);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this._writer == null && this._outputStream == null) {
            this._successor.setCharacterEncoding(enc);
        }
    }

    public String getCharacterEncoding() {
        return this._successor.getCharacterEncoding();
    }

    public void setContentType(String contentType) {
        if (this._writer == null && this._outputStream == null) {
            this._successor.setContentType(contentType);
        }
    }

    public String getContentType() {
        return this._successor.getContentType();
    }

    public void setLocale(Locale locale) {
        if (this._writer == null && this._outputStream == null) {
            this._successor.setLocale(locale);
        }
    }

    public Locale getLocale() {
        return this._successor.getLocale();
    }

    public boolean isCommitted() {
        return this._successor.isCommitted();
    }

    public PrintWriter getWriter() throws IOException {
        this.checkErrorOrFail();
        if (this._writer != null) {
            return this._writer;
        }
        if (this._outputStream != null) {
            throw new IllegalStateException("getOutputStream() already called");
        }
        if (this.getContentType() == null) {
            throw new IllegalStateException("response.setContentType() must be called before getWriter()");
        }
        try {
            PrintWriter writerOut = this._successor.getWriter();
            if (this._internalWriter == null) {
                this._internalWriter = new GenericPrintWriter(this);
            }
            this._writerOut = writerOut;
            this._writer = this._internalWriter;
        }
        catch (Exception ex) {
            this.setError(ex);
        }
        this.checkErrorOrFail();
        return this._writer;
    }

    protected PrintWriter getUnderlyingWriter() {
        return this._writerOut;
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkErrorOrFail();
        if (this._outputStream != null) {
            return this._outputStream;
        }
        if (this._writer != null) {
            throw new IllegalStateException("getWriter() already called");
        }
        if (this.getContentType() == null) {
            throw new IllegalStateException("response.setContentType() must be called before getOutputStream()");
        }
        boolean fail = true;
        try {
            OutputStream outputStreamOut = this._successor.getOutputStream();
            if (this._internalOutputStream == null) {
                this._internalOutputStream = new GenericOutputStream(this);
            }
            this._outputStreamOut = outputStreamOut;
            this._outputStream = this._internalOutputStream;
            fail = false;
        }
        catch (Exception ex) {
            this.setError(ex);
        }
        this.checkErrorOrFail();
        return this._outputStream;
    }

    protected OutputStream getUnderlyingOutputStream() {
        return this._outputStreamOut;
    }

    protected void setError(Exception cause) {
        if (cause == null) {
            throw new NullPointerException();
        }
        if (this._errorCause != null) {
            this._errorCause = cause;
            log.log(Level.FINEST, this._errorCause.toString(), cause);
        }
    }

    public Exception getErrorCause() {
        return this._errorCause;
    }

    public boolean isError() {
        return this._errorCause != null;
    }

    protected void checkErrorOrFail() throws IOException {
        if (this._errorCause != null) {
            if (this._errorCause instanceof IOException) {
                throw (IOException)this._errorCause;
            }
            IOException ex = new IOException();
            ex.initCause(this._errorCause);
            throw ex;
        }
    }

    public void setBufferSize(int bufferSize) {
        this._successor.setBufferSize(bufferSize);
    }

    public int getBufferSize() {
        return this._successor.getBufferSize();
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void flushBuffer() throws IOException {
        this.checkErrorOrFail();
    }

    protected void print(char[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.checkErrorOrFail();
        this._writerOut.write(buf, off, len);
    }

    protected void print(String str, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.checkErrorOrFail();
        this._writerOut.write(str, off, len);
    }

    protected void print(char c) throws IOException {
        this.checkErrorOrFail();
        this._writerOut.write(c);
    }

    protected void write(byte[] buf, int off, int len) throws IOException {
        this.checkErrorOrFail();
        this._outputStreamOut.write(buf, off, len);
    }

    protected void write(byte b) throws IOException {
        this.checkErrorOrFail();
        this._outputStreamOut.write(b);
    }

    private static class GenericOutputStream
    extends OutputStream {
        private AbstractResponseHandler _successor;

        public GenericOutputStream(AbstractResponseHandler successor) {
            this._successor = successor;
        }

        public void flush() throws IOException {
            this._successor.flushBuffer();
        }

        public void write(byte[] buf) throws IOException {
            this._successor.write(buf, 0, buf.length);
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            this._successor.write(buf, off, len);
        }

        public void write(int b) throws IOException {
            this._successor.write((byte)b);
        }

        public void close() {
        }
    }

    private static class GenericPrintWriter
    extends FastPrintWriter {
        private AbstractResponseHandler _successor;

        public GenericPrintWriter(AbstractResponseHandler successor) {
            this._successor = successor;
        }

        protected void setError() {
            this._successor.setError(new IOException());
        }

        protected void setError(Exception errorCause) {
            this._successor.setError(errorCause);
        }

        public boolean checkError() {
            return this._successor.getErrorCause() != null;
        }

        public Exception getErrorCause() {
            return this._successor.getErrorCause();
        }

        public void writeOut(char[] buf, int off, int len) throws IOException {
            this._successor.print(buf, off, len);
        }

        public void writeOut(String str, int off, int len) throws IOException {
            this._successor.print(str, off, len);
        }

        public void writeOut(char c) throws IOException {
            this._successor.print(c);
        }

        public void close() {
        }
    }
}

