/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus;

import com.caucho.Version;
import com.caucho.java.WorkDir;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.module.ModuleContext;
import com.caucho.quercus.module.ResinModuleContext;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.sql.DBPool;
import com.caucho.sql.DatabaseManager;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.sql.UserConnection;
import com.caucho.sql.UserStatement;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.caucho.vfs.Vfs;
import java.sql.Connection;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class ResinQuercus
extends Quercus {
    private static L10N L = new L10N(ResinQuercus.class);
    private static final Logger log = Log.open(ResinQuercus.class);
    private static EnvironmentLocal<ModuleContext> _localModuleContext = new EnvironmentLocal();
    private WebApp _webApp;

    public ResinQuercus() {
        this.setPwd(Vfs.lookup());
        this.setWorkDir(WorkDir.getLocalWorkDir());
    }

    public void setWebApp(WebApp webApp) {
        this._webApp = webApp;
    }

    public WebApp getWebApp() {
        return this._webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleContext getLocalContext(ClassLoader loader) {
        EnvironmentLocal<ModuleContext> environmentLocal = _localModuleContext;
        synchronized (environmentLocal) {
            ModuleContext context = _localModuleContext.getLevel(loader);
            if (context == null) {
                context = this.createModuleContext(loader);
                _localModuleContext.set(context, loader);
            }
            return context;
        }
    }

    protected ModuleContext createModuleContext(ClassLoader loader) {
        return new ResinModuleContext(loader);
    }

    public String getCookieName() {
        SessionManager sm = this.getSessionManager();
        if (sm != null) {
            return sm.getCookieName();
        }
        return "JSESSIONID";
    }

    public SessionManager getSessionManager() {
        if (this._webApp != null) {
            return this._webApp.getSessionManager();
        }
        return null;
    }

    public String getVersion() {
        return Version.VERSION;
    }

    public String getVersionDate() {
        return Version.VERSION_DATE;
    }

    public DataSource findDatabase(String driver, String url) {
        try {
            if (this.getDatabase() != null) {
                return this.getDatabase();
            }
            return DatabaseManager.findDatabase(url, driver);
        }
        catch (Exception e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    public Connection getConnection(Connection conn) {
        try {
            return ((UserConnection)conn).getConnection();
        }
        catch (Exception e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    public void markForPoolRemoval(Connection conn) {
        ManagedConnectionImpl mConn = ((UserConnection)conn).getMConn();
        String url = mConn.getURL();
        String driver = mConn.getDriverClass().getCanonicalName();
        DataSource ds = this.findDatabase(driver, url);
        ((DBPool)ds).markForPoolRemoval(mConn);
    }

    public Statement getStatement(Statement stmt) {
        return ((UserStatement)stmt).getStatement();
    }

    public boolean isResin() {
        return true;
    }
}

