/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib;

import com.caucho.Version;
import com.caucho.naming.Jndi;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.NotNull;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.annotation.ReadOnly;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.NullValue;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.module.AbstractQuercusModule;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class ResinModule
extends AbstractQuercusModule {
    private static final L10N L = new L10N(ResinModule.class);
    private static final Logger log = Logger.getLogger(ResinModule.class.getName());
    public static final int XA_STATUS_ACTIVE = 0;
    public static final int XA_STATUS_MARKED_ROLLBACK = 1;
    public static final int XA_STATUS_PREPARED = 2;
    public static final int XA_STATUS_COMMITTED = 3;
    public static final int XA_STATUS_ROLLEDBACK = 4;
    public static final int XA_STATUS_UNKNOWN = 5;
    public static final int XA_STATUS_NO_TRANSACTION = 6;
    public static final int XA_STATUS_PREPARING = 7;
    public static final int XA_STATUS_COMMITTING = 8;
    public static final int XA_STATUS_ROLLING_BACK = 9;

    public static Value string_to_binary(Env env, String string, @Optional String encoding) {
        if (encoding == null || encoding.length() == 0) {
            encoding = env.getScriptEncoding();
        }
        try {
            byte[] bytes = string.getBytes(encoding);
            return env.createBinaryBuilder(bytes);
        }
        catch (UnsupportedEncodingException e) {
            env.error((Throwable)e);
            return BooleanValue.FALSE;
        }
    }

    public static Object java_bean(String name) {
        WebBeansContainer webBeans = WebBeansContainer.create();
        ComponentImpl comp = webBeans.findByName(name);
        if (comp != null) {
            return comp.get();
        }
        return null;
    }

    public static Object jndi_lookup(String name) {
        return Jndi.lookup(name);
    }

    public static String resin_version() {
        return Version.FULL_VERSION;
    }

    public static boolean xa_begin(Env env) {
        try {
            ResinModule.getUserTransaction().begin();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning((Throwable)e);
            return false;
        }
    }

    public static boolean xa_commit(Env env) {
        try {
            ResinModule.getUserTransaction().commit();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning((Throwable)e);
            return false;
        }
    }

    public static boolean xa_rollback(Env env) {
        try {
            ResinModule.getUserTransaction().rollback();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning((Throwable)e);
            return false;
        }
    }

    public static boolean xa_rollback_only(Env env) {
        try {
            ResinModule.getUserTransaction().setRollbackOnly();
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning((Throwable)e);
            return false;
        }
    }

    public static boolean xa_set_timeout(Env env, int timeoutSeconds) {
        try {
            ResinModule.getUserTransaction().setTransactionTimeout(timeoutSeconds);
            return true;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getMessage(), e);
            env.warning((Throwable)e);
            return false;
        }
    }

    public static int xa_status() {
        try {
            return ResinModule.getUserTransaction().getStatus();
        }
        catch (Exception e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    private static UserTransaction getUserTransaction() {
        try {
            InitialContext ic = new InitialContext();
            return (UserTransaction)ic.lookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    public ArrayValue mbean_explode(String name) {
        try {
            ArrayValueImpl exploded = new ArrayValueImpl();
            if (name == null) {
                name = "";
            }
            ObjectName objectName = new ObjectName(name);
            exploded.put(":domain:", objectName.getDomain());
            Hashtable<String, String> entries = objectName.getKeyPropertyList();
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                exploded.put(entry.getKey(), entry.getValue());
            }
            return exploded;
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    public static String mbean_implode(@NotNull @ReadOnly ArrayValue exploded) {
        try {
            if (exploded == null) {
                return null;
            }
            Value domainValue = exploded.get(StringValue.create((String)":domain:"));
            String domain = domainValue.isNull() ? "*" : domainValue.toString();
            Hashtable<String, String> entries = new Hashtable<String, String>();
            for (Map.Entry entry : exploded.entrySet()) {
                String key = ((Value)entry.getKey()).toString();
                String value = ((Value)entry.getValue()).toString();
                if (":domain:".equals(key)) continue;
                entries.put(key, value);
            }
            ObjectName objectName = entries.isEmpty() ? new ObjectName(domain + ":" + "*") : new ObjectName(domain, entries);
            return objectName.getCanonicalName();
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    public static Value resin_var_dump(Env env, @ReadOnly Value[] args) {
        try {
            WriteStream out = Vfs.openWrite("stdout:");
            out.setNewlineString("\n");
            if (args != null) {
                for (Value v : args) {
                    if (v != null) {
                        v.varDump(env, out, 0, new IdentityHashMap());
                    }
                    out.println();
                }
            }
            out.close();
            return NullValue.NULL;
        }
        catch (IOException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }
}

