/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.dom;

import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.LongValue;
import com.caucho.quercus.env.ObjectValue;
import com.caucho.quercus.env.TraversableDelegate;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.dom.DOMNodeList;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMNodeListDelegate
implements TraversableDelegate {
    public Iterator<Value> getKeyIterator(Env env, ObjectValue obj) {
        return new DOMNodeListKeyIterator((DOMNodeList)obj.toJavaObject());
    }

    public Iterator<Value> getValueIterator(Env env, ObjectValue obj) {
        return new DOMNodeListValueIterator(env, (DOMNodeList)obj.toJavaObject());
    }

    public Iterator<Map.Entry<Value, Value>> getIterator(Env env, ObjectValue obj) {
        return new DOMNodeListIterator(env, (DOMNodeList)obj.toJavaObject());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DOMNodeListEntry
    implements Map.Entry<Value, Value> {
        private int _key;
        private Value _value;

        public DOMNodeListEntry(int index, Value value) {
            this._key = index;
            this._value = value;
        }

        @Override
        public Value getKey() {
            return LongValue.create((long)this._key);
        }

        @Override
        public Value getValue() {
            return this._value;
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DOMNodeListIterator
    implements Iterator<Map.Entry<Value, Value>> {
        private Env _env;
        private DOMNodeList _list;
        private int _index;

        public DOMNodeListIterator(Env env, DOMNodeList list) {
            this._env = env;
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._list.getLength();
        }

        @Override
        public Map.Entry<Value, Value> next() {
            return new DOMNodeListEntry(this._index, this._env.wrapJava((Object)this._list.item(this._index++)));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DOMNodeListValueIterator
    implements Iterator<Value> {
        private Env _env;
        private DOMNodeList _list;
        private int _index;

        public DOMNodeListValueIterator(Env env, DOMNodeList list) {
            this._env = env;
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._list.getLength();
        }

        @Override
        public Value next() {
            return this._env.wrapJava((Object)this._list.item(this._index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DOMNodeListKeyIterator
    implements Iterator<Value> {
        private DOMNodeList _list;
        private int _index;

        public DOMNodeListKeyIterator(DOMNodeList list) {
            this._list = list;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._list.getLength();
        }

        @Override
        public Value next() {
            return LongValue.create((long)this._index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

