/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.dom;

import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.dom.DOMDocument;
import com.caucho.quercus.lib.dom.DOMNode;
import com.caucho.quercus.lib.dom.DOMNodeList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMXPath {
    private XPath _xpath;
    private XPathExpression _compiledXPath;
    private String _expression;
    private DOMNamespaceContext _context;
    private DOMDocument _document;

    public static DOMXPath __construct(Env env, DOMDocument document) {
        return new DOMXPath(document);
    }

    private DOMXPath(DOMDocument document) {
        this._document = document;
        this._context = new DOMNamespaceContext();
        this._xpath = XPathFactory.newInstance().newXPath();
        this._xpath.setNamespaceContext(this._context);
    }

    public Object evaluate(Env env, String expression) {
        Node node = this._document.getDelegate();
        NodeList nodeList = this.query(env, expression, node);
        if (nodeList.getLength() == 1) {
            return this._document.wrap(nodeList.item(0));
        }
        return this._document.wrap(nodeList);
    }

    public DOMNodeList query(Env env, String expression, @Optional DOMNode<Node> contextNode) {
        Node node = contextNode != null ? contextNode.getDelegate() : this._document.getDelegate();
        NodeList nodeList = this.query(env, expression, node);
        return (DOMNodeList)this._document.wrap(nodeList);
    }

    private NodeList query(Env env, String expression, Node node) {
        try {
            this.compile(expression);
            NodeList nodeList = (NodeList)this._compiledXPath.evaluate(node, XPathConstants.NODESET);
            return nodeList;
        }
        catch (XPathExpressionException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    private void compile(String expression) {
        try {
            if (this._compiledXPath == null || !expression.equals(this._expression)) {
                this._compiledXPath = this._xpath.compile(expression);
                this._expression = expression;
            }
        }
        catch (XPathExpressionException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    public boolean registerNamespace(String prefix, String namespaceURI) {
        this._context.addNamespace(prefix, namespaceURI);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DOMNamespaceContext
    implements NamespaceContext {
        private HashMap<String, LinkedHashSet<String>> _namespaceMap = new HashMap();

        protected void addNamespace(String prefix, String namespaceURI) {
            LinkedHashSet<String> list = this._namespaceMap.get(namespaceURI);
            if (list == null) {
                list = new LinkedHashSet();
                this._namespaceMap.put(namespaceURI, list);
            }
            list.add(prefix);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            for (Map.Entry<String, LinkedHashSet<String>> entry : this._namespaceMap.entrySet()) {
                if (!entry.getValue().contains(prefix)) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            Iterator<String> iter = this.getPrefixes(namespaceURI);
            if (iter != null) {
                return iter.next();
            }
            return null;
        }

        @Override
        public Iterator<String> getPrefixes(String namespaceURI) {
            LinkedHashSet<String> prefixList = this._namespaceMap.get(namespaceURI);
            if (prefixList != null) {
                return prefixList.iterator();
            }
            return null;
        }
    }
}

