/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.pdf;

import com.caucho.quercus.lib.pdf.Font;
import com.caucho.quercus.lib.pdf.PDFObject;
import com.caucho.quercus.lib.pdf.PDFWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;

public class PDFFont
extends PDFObject {
    private static final Logger log = Logger.getLogger(PDFFont.class.getName());
    private static final L10N L = new L10N(PDFFont.class);
    private int _id;
    private final Font _face;
    private final String _encoding;
    private final String _opt;

    PDFFont(Font face, String encoding, String opt) {
        this._face = face;
        this._encoding = encoding;
        this._opt = opt;
    }

    void setId(int id) {
        this._id = id;
    }

    public int getId() {
        return this._id;
    }

    public String getFontName() {
        return this._face.getFontName();
    }

    public String getFontStyle() {
        return this._face.getWeight();
    }

    public double getAscender() {
        return this._face.getAscender();
    }

    public double getCapHeight() {
        return this._face.getCapHeight();
    }

    public double getDescender() {
        return this._face.getDescender();
    }

    public double stringWidth(String text) {
        return this._face.stringWidth(text);
    }

    public String getPDFName() {
        return "F" + this._id;
    }

    String getResource() {
        return "/Font << /F" + this._id + " " + this._id + " 0 R>>";
    }

    public void writeObject(PDFWriter out) throws IOException {
        out.println("<< /Type /Font");
        out.println("   /Subtype /Type1");
        out.println("   /Name /" + this._face.getFontName());
        out.println("   /BaseFont /Helvetica");
        out.println("   /Encoding /MacRomanEncoding");
        out.println(">>");
    }

    public int hashCode() {
        int hash = 37;
        hash = 65521 * hash + this._face.hashCode();
        hash = 65521 * hash + this._encoding.hashCode();
        hash = 65521 * hash + this._opt.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PDFFont)) {
            return false;
        }
        PDFFont font = (PDFFont)o;
        return this._face == font._face && this._encoding.equals(font._encoding) && this._opt.equals(font._opt);
    }

    public String toString() {
        return "PDFFont[" + this._face.getFontName() + "," + this._encoding + "," + this._opt + "]";
    }
}

