/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.resin;

import com.caucho.jmx.Jmx;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.resin.MBean;
import com.caucho.server.admin.RemoteMBeanConnectionFactory;
import com.caucho.server.cluster.Cluster;
import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanServer {
    private static Logger log = Logger.getLogger(MBeanServer.class.getName());
    private static final Comparator<ObjectName> OBJECTNAME_COMPARATOR = new Comparator<ObjectName>(){

        @Override
        public int compare(ObjectName o1, ObjectName o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getCanonicalName().compareTo(o2.getCanonicalName());
        }
    };
    private final MBeanServerConnection _server;

    public MBeanServer(@Optional String serverId) {
        this._server = serverId == null || "".equals(serverId) || Cluster.getServerId().equals(serverId) ? Jmx.getGlobalMBeanServer() : RemoteMBeanConnectionFactory.create(serverId);
    }

    public MBean lookup(Env env, @Optional String name) {
        try {
            if (name == null || name.length() == 0) {
                return null;
            }
            ObjectName objectName = Jmx.getObjectName(name);
            if (this._server.isRegistered(objectName)) {
                return new MBean(this._server, objectName);
            }
            return null;
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException((Throwable)e);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public ArrayValue query(Env env, String pattern) {
        try {
            ArrayValueImpl values = new ArrayValueImpl();
            ObjectName patternObjectName = new ObjectName(pattern);
            Set<ObjectName> objectNames = this._server.queryNames(patternObjectName, null);
            if (objectNames == null) {
                return values;
            }
            TreeSet<ObjectName> sortedObjectNames = new TreeSet<ObjectName>(OBJECTNAME_COMPARATOR);
            sortedObjectNames.addAll(objectNames);
            for (ObjectName objectName : sortedObjectNames) {
                values.put(env.wrapJava((Object)new MBean(this._server, objectName)));
            }
            return values;
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException((Throwable)e);
        }
        catch (IOException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    public String toString() {
        return "MBeanServer[" + this._server + "]";
    }
}

