/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.servlet;

import com.caucho.quercus.Quercus;
import com.caucho.quercus.QuercusDieException;
import com.caucho.quercus.QuercusErrorException;
import com.caucho.quercus.QuercusExitException;
import com.caucho.quercus.QuercusLineRuntimeException;
import com.caucho.quercus.QuercusRequestAdapter;
import com.caucho.quercus.ResinQuercus;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.QuercusValueException;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.servlet.QuercusServletImpl;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.resin.Resin;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResinQuercusServlet
extends QuercusServletImpl {
    private static final L10N L = new L10N(ResinQuercusServlet.class);
    private static final Logger log = Logger.getLogger(ResinQuercusServlet.class.getName());
    private WebApp _webApp;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._webApp = (WebApp)config.getServletContext();
        ResinQuercus quercus = (ResinQuercus)this.getQuercus();
        quercus.setWebApp(this._webApp);
        this.getQuercus().setPwd(Vfs.lookup());
        quercus.setIni("caucho.server_id", Resin.getLocal().getServerId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Env env = null;
        WriteStream ws = null;
        try {
            block29: {
                QuercusPage page;
                Path path = this.getPath(request);
                try {
                    page = this.getQuercus().parse(path);
                }
                catch (FileNotFoundException ex) {
                    log.log(Level.FINER, ex.toString(), ex);
                    response.sendError(404);
                    return;
                }
                if (response instanceof CauchoResponse) {
                    ws = Vfs.openWrite((OutputStream)((Object)((CauchoResponse)response).getResponseStream()));
                } else {
                    ServletOutputStream out = response.getOutputStream();
                    ws = Vfs.openWrite((OutputStream)out);
                }
                ws.setNewlineString("\n");
                Quercus quercus = this.getQuercus();
                env = quercus.createEnv(page, ws, request, response);
                quercus.setServletContext(this._servletContext);
                try {
                    block28: {
                        try {
                            env.start();
                            env.setGlobalValue("request", env.wrapJava((Object)request));
                            env.setGlobalValue("response", env.wrapJava((Object)response));
                            env.setGlobalValue("servletContext", env.wrapJava((Object)this._servletContext));
                            String prepend = env.getIniString("auto_prepend_file");
                            if (prepend != null) {
                                Path prependPath = env.lookup(prepend);
                                if (prependPath == null) {
                                    env.error(L.l("auto_prepend_file '{0}' not found.", (Object)prepend));
                                } else {
                                    QuercusPage prependPage = this.getQuercus().parse(prependPath);
                                    prependPage.executeTop(env);
                                }
                            }
                            page.executeTop(env);
                            String append = env.getIniString("auto_append_file");
                            if (append == null) break block28;
                            Path appendPath = env.lookup(append);
                            if (appendPath == null) {
                                env.error(L.l("auto_append_file '{0}' not found.", (Object)append));
                            } else {
                                QuercusPage appendPage = this.getQuercus().parse(appendPath);
                                appendPage.executeTop(env);
                            }
                        }
                        catch (QuercusExitException e) {
                            throw e;
                        }
                        catch (QuercusErrorException e) {
                            throw e;
                        }
                        catch (QuercusLineRuntimeException e) {
                            log.log(Level.FINE, e.toString(), e);
                            ws.println(e.getMessage());
                            Object var13_24 = null;
                            if (env != null) {
                                env.close();
                            }
                            if (ws == null) return;
                            ws.close();
                            return;
                        }
                        catch (QuercusValueException e) {
                            log.log(Level.FINE, e.toString(), e);
                            ws.println(e.toString());
                            Object var13_25 = null;
                            if (env != null) {
                                env.close();
                            }
                            if (ws == null) return;
                            ws.close();
                            return;
                        }
                        catch (Throwable e) {
                            if (response.isCommitted()) {
                                e.printStackTrace(ws.getPrintWriter());
                            }
                            ws = null;
                            throw e;
                        }
                    }
                    Object var13_23 = null;
                    if (env == null) break block29;
                }
                catch (Throwable throwable) {
                    Object var13_26 = null;
                    if (env != null) {
                        env.close();
                    }
                    if (ws == null) throw throwable;
                    ws.close();
                    throw throwable;
                }
                env.close();
            }
            if (ws == null) return;
            ws.close();
            return;
        }
        catch (QuercusDieException e) {
            log.log(Level.FINE, e.toString(), e);
            return;
        }
        catch (QuercusExitException e) {
            log.log(Level.FINER, e.toString(), e);
            return;
        }
        catch (QuercusErrorException e) {
            log.log(Level.FINE, e.toString(), e);
            return;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    Path getPath(HttpServletRequest req) {
        String scriptPath = QuercusRequestAdapter.getPageServletPath((HttpServletRequest)req);
        String pathInfo = QuercusRequestAdapter.getPagePathInfo((HttpServletRequest)req);
        Path pwd = Vfs.lookup();
        Path path = pwd.lookup(req.getRealPath(scriptPath));
        if (path.isFile()) {
            return path;
        }
        String fullPath = pathInfo != null ? scriptPath + pathInfo : scriptPath;
        return Vfs.lookup().lookup(req.getRealPath(fullPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Quercus getQuercus() {
        ResinQuercusServlet resinQuercusServlet = this;
        synchronized (resinQuercusServlet) {
            if (this._quercus == null) {
                this._quercus = new ResinQuercus();
            }
        }
        return this._quercus;
    }
}

