/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.relaxng;

import com.caucho.relaxng.RelaxException;
import com.caucho.relaxng.SchemaImpl;
import com.caucho.relaxng.VerifierHandler;
import com.caucho.relaxng.VerifierImpl;
import com.caucho.relaxng.program.EmptyItem;
import com.caucho.relaxng.program.Item;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.xml.QName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifierHandlerImpl
extends DefaultHandler
implements VerifierHandler {
    private static final L10N L = new L10N(VerifierHandlerImpl.class);
    protected static final Logger log = Logger.getLogger(VerifierHandlerImpl.class.getName());
    private static final boolean _isDebug = false;
    private SchemaImpl _schema;
    private VerifierImpl _verifier;
    private boolean _hasProgram;
    private boolean _isValid = true;
    private LruCache<Object, Item> _programCache;
    private QName _name;
    private ArrayList<QName> _nameStack = new ArrayList();
    private String _eltLocation;
    private ArrayList<String> _eltLocationStack = new ArrayList();
    private Item _item;
    private ArrayList<Item> _itemStack = new ArrayList();
    private Locator _locator;
    private boolean _isLogFinest;
    private CharBuffer _text = new CharBuffer();
    private boolean _hasText;
    private StartKey _startKey = new StartKey();
    private EndElementKey _endElementKey = new EndElementKey();

    public VerifierHandlerImpl(SchemaImpl schema, VerifierImpl verifier) {
        this._schema = schema;
        this._programCache = this._schema.getProgramCache();
        this._verifier = verifier;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void setErrorHandler(ErrorHandler errorHandler) throws SAXException {
        this._verifier.setErrorHandler(errorHandler);
    }

    private String getFileName() {
        if (this._locator != null) {
            return this._locator.getSystemId();
        }
        return null;
    }

    private int getLine() {
        if (this._locator != null) {
            return this._locator.getLineNumber();
        }
        return -1;
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this._nameStack.clear();
            this._itemStack.clear();
            this._eltLocationStack.clear();
            this._name = new QName("#top", "");
            this._item = this._schema.getStartItem();
            this._itemStack.add(this._item);
            this._eltLocation = this.getLocation();
            this._isLogFinest = false;
            this._hasText = false;
            this._text.clear();
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (!this._isValid) {
            return;
        }
        if (this._hasText) {
            this.sendText();
        }
        if (this._isLogFinest) {
            log.finest("element start: " + qName);
        }
        try {
            QName name;
            QName parent = this._name;
            this._nameStack.add(parent);
            String parentLocation = this._eltLocation;
            this._eltLocationStack.add(parentLocation);
            this._name = name = new QName(qName, uri);
            this._eltLocation = this.getLocation();
            Item newItem = this.getStartElement(this._item, name);
            if (newItem == null) {
                Item parentItem = this._itemStack.get(this._itemStack.size() - 1);
                if (parent.getName().equals("#top")) {
                    throw new RelaxException(L.l("<{0}> is an unexpected top-level tag.{1}", (Object)this.errorNodeName(name, this._item, parentItem), (Object)this.errorMessageDetail(this._item, parentItem, null, name)));
                }
                throw new RelaxException(L.l("<{0}> is an unexpected tag (parent <{1}> starts at {2}).{3}", (Object)this.errorNodeName(name, this._item, parentItem), (Object)parent.getName(), (Object)parentLocation, (Object)this.errorMessageDetail(this._item, parentItem, parent.getName(), name)));
            }
            this._item = newItem;
            this._itemStack.add(newItem);
            Item parentItem = newItem;
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                String attrUri = attrs.getURI(i);
                String attrQName = attrs.getQName(i);
                String value = attrs.getValue(i);
                if (this._isLogFinest) {
                    log.finest("attribute: " + attrQName + "=\"" + value + "\"");
                }
                name = new QName(attrQName, attrUri);
                if (!attrQName.startsWith("xml:")) {
                    if (!this._item.allowAttribute(name, value)) {
                        throw new RelaxException(L.l("{0}=\"{1}\" is an unexpected attribute in <{2}>.{3}", (Object)attrQName, (Object)value, (Object)qName, (Object)this.attributeMessageDetail(this._item, parentItem, qName, null)));
                    }
                    this._item = this._item.setAttribute(name, value);
                }
                if (this._item != null) continue;
                this._item = EmptyItem.create();
            }
            newItem = this._item.attributeEnd();
            if (newItem == null) {
                throw new RelaxException(L.l("<{0}> expects more attributes.{1}", (Object)qName, (Object)this.attributeMessageDetail(this._item, parentItem, qName, null)));
            }
            this._item = newItem;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private Item getStartElement(Item item, QName name) throws RelaxException {
        this._startKey.init(item, name);
        Item newItem = null;
        if (newItem != null) {
            return newItem;
        }
        newItem = this._item.startElement(name);
        return newItem;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._hasText = true;
        this._text.append(ch, start, length);
    }

    public void sendText() throws SAXException {
        if (!this._hasText) {
            return;
        }
        this._hasText = false;
        try {
            Item newItem = this._item.text((CharSequence)this._text);
            if (newItem == null) {
                String string = this._text.toString();
                Item parentItem = this._itemStack.get(this._itemStack.size() - 1);
                throw new RelaxException(L.l("The following text is not allowed in this context.\n{0}\n{1}", (Object)string, (Object)this.errorMessageDetail(this._item, parentItem, this._name.getName(), null)));
            }
            this._text.clear();
            this._item = newItem;
        }
        catch (Exception e) {
            this._text.clear();
            this.error(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        QName parent;
        if (this._hasText) {
            this.sendText();
        }
        if (!this._isValid) {
            return;
        }
        if (this._isLogFinest) {
            log.finest("element end: " + qName);
        }
        QName name = this._name;
        this._name = parent = this._nameStack.remove(this._nameStack.size() - 1);
        Item parentItem = this._itemStack.remove(this._itemStack.size() - 1);
        String eltOpen = this._eltLocation;
        this._eltLocation = this._eltLocationStack.remove(this._eltLocationStack.size() - 1);
        try {
            Item nextItem = this.getEndElement(this._item);
            if (nextItem == null) {
                throw new RelaxException(L.l("<{0}> closed while expecting more elements (open at {1}).{2}", (Object)qName, (Object)eltOpen, (Object)this.requiredMessageDetail(this._item, parentItem, qName, null)));
            }
            this._item = nextItem;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private Item getEndElement(Item item) throws RelaxException {
        this._endElementKey.init(item);
        Item newItem = null;
        if (newItem != null) {
            return newItem;
        }
        newItem = this._item.endElement();
        return newItem;
    }

    private void error(SAXException e) throws SAXException {
        this._isValid = false;
        this._verifier.error(new SAXParseException(e.getMessage(), this._locator));
    }

    private void error(Exception e) throws SAXException {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof SAXException) {
            this.error((SAXException)e);
        } else {
            this.error(new SAXException(e.getMessage(), e));
        }
    }

    private String errorNodeName(QName name, Item item, Item parentItem) {
        Item currentItem = item;
        if (currentItem == null) {
            currentItem = parentItem;
        }
        if (currentItem == null) {
            return name.toString();
        }
        LinkedHashSet<QName> values = new LinkedHashSet<QName>();
        currentItem.firstSet(values);
        for (QName value : values) {
            if (!name.getLocalName().equals(value.getLocalName())) continue;
            if (name.getPrefix() == null || name.getPrefix().equals("")) {
                return name.getName() + " xmlns=\"" + name.getNamespaceURI() + "\"";
            }
            return name.getName() + " xmlns:" + name.getPrefix() + "=\"" + name.getNamespaceURI() + "\"";
        }
        return name.getName();
    }

    private String errorMessageDetail(Item item, Item parentItem, String parentName, QName qName) {
        Item currentItem = item;
        if (currentItem == null) {
            currentItem = parentItem;
        }
        LinkedHashSet<QName> values = new LinkedHashSet<QName>();
        currentItem.firstSet(values);
        String expected = null;
        if (values.size() <= 5) {
            expected = this.namesToString(values, parentName, qName, currentItem.allowEmpty());
        }
        return this.getLineContext(this.getFileName(), this.getLine()) + this.syntaxMessage(item, parentItem, parentName, qName, expected);
    }

    private String requiredMessageDetail(Item item, Item parentItem, String parentName, QName qName) {
        Item currentItem = item;
        if (currentItem == null) {
            currentItem = parentItem;
        }
        LinkedHashSet<QName> values = new LinkedHashSet<QName>();
        currentItem.requiredFirstSet(values);
        String expected = null;
        if (values.size() <= 5) {
            expected = this.namesToString(values, parentName, qName, currentItem.allowEmpty());
        }
        return this.getLineContext(this.getFileName(), this.getLine()) + this.syntaxMessage(item, parentItem, parentName, qName, expected);
    }

    private String attributeMessageDetail(Item item, Item parentItem, String parentName, QName qName) {
        Item currentItem = item;
        if (currentItem == null) {
            currentItem = parentItem;
        }
        String allowed = this.allowedAttributes(currentItem, qName);
        return this.getLineContext(this.getFileName(), this.getLine()) + this.syntaxMessage(item, parentItem, parentName, qName, allowed);
    }

    private String syntaxMessage(Item item, Item parentItem, String parentName, QName qName, String expected) {
        String prefix;
        String syntaxPrefix = parentName == null || parentName.equals("#top") ? "Syntax: " : "<" + parentName + "> syntax: ";
        String msg = "";
        Item topParent = null;
        Item parent = item;
        while (parent != null) {
            if (qName != null && parent.allowsElement(qName)) {
                msg = "\n Check for duplicate and out-of-order tags.";
                if (expected != null) {
                    msg = msg + expected + "\n";
                }
                msg = msg + "\n";
                String prefix2 = "Syntax: ";
                if (parent == parentItem) {
                    prefix2 = syntaxPrefix;
                }
                msg = msg + prefix2 + parent.toSyntaxDescription(prefix2.length());
                break;
            }
            parent = null;
        }
        if (topParent == null || topParent instanceof EmptyItem) {
            topParent = parentItem;
            if (qName != null && topParent.allowsElement(qName)) {
                msg = "\n Check for duplicate and out-of-order tags.";
                if (expected != null) {
                    msg = msg + expected + "\n";
                }
                msg = msg + "\n";
                prefix = syntaxPrefix;
                msg = msg + prefix + topParent.toSyntaxDescription(prefix.length());
            }
        }
        if (msg.equals("")) {
            msg = "";
            if (expected != null) {
                msg = msg + expected + "\n";
            }
            msg = msg + "\n";
            prefix = syntaxPrefix;
            msg = msg + prefix + topParent.toSyntaxDescription(prefix.length());
        }
        return msg;
    }

    private String requiredValues(Item item, String parentName, QName qName) {
        if (item == null) {
            return "";
        }
        LinkedHashSet<QName> values = new LinkedHashSet<QName>();
        item.requiredFirstSet(values);
        return this.namesToString(values, parentName, qName, item.allowEmpty());
    }

    private String namesToString(HashSet<QName> values, String parentName, QName qName, boolean allowEmpty) {
        CharBuffer cb = new CharBuffer();
        if (values.size() > 0) {
            ArrayList<QName> sortedValues = new ArrayList<QName>(values);
            Collections.sort(sortedValues);
            for (int i = 0; i < sortedValues.size(); ++i) {
                QName name = sortedValues.get(i);
                if (i == 0) {
                    cb.append("\n\n");
                } else if (i == sortedValues.size() - 1) {
                    cb.append(" or\n");
                } else {
                    cb.append(",\n");
                }
                if (name.getName().equals("#text")) {
                    cb.append("text");
                    continue;
                }
                if (name.getNamespaceURI() == null || qName == null) {
                    cb.append("<" + name.getName() + ">");
                    continue;
                }
                if (qName.getNamespaceURI() != name.getNamespaceURI()) {
                    if (name.getPrefix() != null) {
                        cb.append("<" + name.getName() + " xmlns:" + name.getPrefix() + "=\"" + name.getNamespaceURI() + "\">");
                        continue;
                    }
                    cb.append("<" + name.getName() + " xmlns=\"" + name.getNamespaceURI() + "\">");
                    continue;
                }
                cb.append("<" + name.getName() + ">");
            }
            if (values.size() == 1) {
                cb.append(" is expected");
            } else {
                cb.append(" are expected");
            }
            if (allowEmpty) {
                if (parentName == null || parentName.equals("#top")) {
                    cb.append(",\nor the document may end.");
                } else {
                    cb.append(",\nor </" + parentName + "> may close.");
                }
            } else {
                cb.append(".");
            }
        } else if (allowEmpty) {
            if (parentName == null || parentName.equals("#top")) {
                cb.append("\n\nThe document is expected to end.");
            } else {
                cb.append("\n\n</" + parentName + "> is expected to close.");
            }
        }
        return cb.toString();
    }

    private String allowedAttributes(Item item, QName qName) {
        if (item == null) {
            return "";
        }
        LinkedHashSet<QName> values = new LinkedHashSet<QName>();
        item.attributeSet(values);
        CharBuffer cb = new CharBuffer();
        if (values.size() > 0) {
            ArrayList<QName> sortedValues = new ArrayList<QName>(values);
            Collections.sort(sortedValues);
            for (int i = 0; i < sortedValues.size(); ++i) {
                QName name = sortedValues.get(i);
                if (i == 0) {
                    cb.append("\n\n");
                } else if (i == sortedValues.size() - 1) {
                    cb.append(" or ");
                } else {
                    cb.append(", ");
                }
                String uri = name.getNamespaceURI();
                if (uri == null || uri.equals("")) {
                    cb.append("'" + name.getName() + "'");
                    continue;
                }
                if (qName == null || qName.getName().equals(name.getName())) {
                    cb.append("'" + name.getCanonicalName() + "'");
                    continue;
                }
                cb.append("'" + name.getName() + "'");
            }
            if (values.size() == 1) {
                cb.append(" is expected.");
            } else {
                cb.append(" are expected.");
            }
        }
        return cb.toString();
    }

    private String getLocation() {
        if (this._locator == null) {
            return "";
        }
        return "" + this._locator.getLineNumber();
    }

    @Override
    public boolean isValid() throws IllegalStateException {
        return this._isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLineContext(String filename, int errorLine) {
        String string;
        block6: {
            if (filename == null || errorLine <= 0) {
                return "";
            }
            ReadStream is = null;
            try {
                String text;
                Path path = Vfs.lookup().lookup(filename);
                StringBuilder sb = new StringBuilder("\n\n");
                is = path.openRead();
                int line = 0;
                while ((text = is.readLine()) != null) {
                    if (errorLine - 2 > ++line || line > errorLine + 2) continue;
                    sb.append(line);
                    sb.append(": ");
                    sb.append(text);
                    sb.append("\n");
                }
                string = sb.toString();
                Object var10_11 = null;
                if (is == null) break block6;
            }
            catch (IOException e) {
                String string2;
                block7: {
                    try {
                        log.log(Level.FINEST, e.toString(), e);
                        string2 = "";
                        Object var10_12 = null;
                        if (is == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block8: {
                            Object var10_13 = null;
                            if (is == null) break block8;
                            is.close();
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return string2;
            }
            is.close();
        }
        return string;
    }

    static class EndElementKey {
        private Item _item;

        public EndElementKey(Item item) {
            this._item = item;
        }

        public EndElementKey() {
        }

        public void init(Item item) {
            this._item = item;
        }

        public int hashCode() {
            return 137 + this._item.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.getClass() != EndElementKey.class) {
                return false;
            }
            EndElementKey key = (EndElementKey)o;
            return this._item.equals(key._item);
        }
    }

    static class StartKey {
        private Item _item;
        private QName _name;

        public StartKey(Item item, QName name) {
            this._item = item;
            this._name = name;
        }

        public StartKey() {
        }

        public void init(Item item, QName name) {
            this._item = item;
            this._name = name;
        }

        public int hashCode() {
            return this._name.hashCode() + 137 * System.identityHashCode(this._item);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o.getClass() != StartKey.class) {
                return false;
            }
            StartKey key = (StartKey)o;
            return this._name.equals(key._name) && this._item == key._item;
        }
    }
}

